/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.rest;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.util.XACMLProperties;

public class XACMLRest {
    private static final Log logger = LogFactory.getLog(XACMLRest.class);
    private static Properties restProperties = new Properties();

    public static void xacmlInit(ServletConfig config) {
        String propFile = config.getInitParameter("XACML_PROPERTIES_NAME");
        if (propFile != null) {
            String xacmlPropertiesName = System.getProperty("xacml.properties");
            if (xacmlPropertiesName == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Using Servlet Config Property for XACML_PROPERTIES_NAME:" + propFile));
                }
                System.setProperty("xacml.properties", propFile);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using System Property for XACML_PROPERTIES_NAME:" + xacmlPropertiesName));
            }
        }
        Enumeration params = config.getInitParameterNames();
        while (params.hasMoreElements()) {
            String param = (String)params.nextElement();
            if (param.equals("XACML_PROPERTIES_NAME")) continue;
            String value = config.getInitParameter(param);
            logger.info((Object)(param + "=" + config.getInitParameter(param)));
            restProperties.setProperty(param, value);
        }
    }

    public static void loadXacmlProperties(Properties policyProperties, Properties pipProperties) {
        try {
            XACMLProperties.reloadProperties();
            XACMLProperties.getProperties().putAll((Map<?, ?>)restProperties);
            if (policyProperties != null) {
                XACMLProperties.getProperties().putAll((Map<?, ?>)policyProperties);
            }
            if (pipProperties != null) {
                XACMLProperties.getProperties().putAll((Map<?, ?>)pipProperties);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Failed to put init properties into Xacml properties", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug((Object)XACMLProperties.getProperties().toString());
            }
            catch (IOException e) {
                logger.error((Object)"Cannot dump properties", (Throwable)e);
            }
        }
    }

    public static void dumpRequest(HttpServletRequest request) {
        if (logger.isDebugEnabled()) {
            block11: {
                String element;
                if (request.getMethod().equals("GET") && "hb".equals(request.getParameter("type"))) {
                    logger.debug((Object)"GET type=hb : heartbeat received");
                    return;
                }
                logger.debug((Object)(request.getMethod() + ":" + request.getRemoteAddr() + " " + request.getRemoteHost() + " " + request.getRemotePort()));
                logger.debug((Object)(request.getLocalAddr() + " " + request.getLocalName() + " " + request.getLocalPort()));
                Enumeration en = request.getHeaderNames();
                logger.debug((Object)"Headers:");
                while (en.hasMoreElements()) {
                    element = (String)en.nextElement();
                    Enumeration values = request.getHeaders(element);
                    while (values.hasMoreElements()) {
                        String value = (String)values.nextElement();
                        logger.debug((Object)(element + ":" + value));
                    }
                }
                logger.debug((Object)"Attributes:");
                en = request.getAttributeNames();
                while (en.hasMoreElements()) {
                    element = (String)en.nextElement();
                    logger.debug((Object)(element + ":" + request.getAttribute(element)));
                }
                logger.debug((Object)("ContextPath: " + request.getContextPath()));
                if (request.getMethod().equals("PUT") || request.getMethod().equals("POST")) {
                    logger.debug((Object)("Query String:" + request.getQueryString()));
                    try {
                        if (request.getInputStream() == null) {
                            logger.debug((Object)"Content: No content inputStream");
                            break block11;
                        }
                        logger.debug((Object)("Content available: " + request.getInputStream().available()));
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Content: inputStream exception: " + e.getMessage() + ";  (May not be relevant)"));
                    }
                } else {
                    logger.debug((Object)"Parameters:");
                    Map params = request.getParameterMap();
                    Set keys = params.keySet();
                    for (String key : keys) {
                        String[] values = (String[])params.get(key);
                        logger.debug((Object)(key + "(" + values.length + "): " + (values.length > 0 ? values[0] : "")));
                    }
                }
            }
            logger.debug((Object)("Request URL:" + request.getRequestURL()));
        }
    }
}

