/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.testing;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeGadgetToken
extends AbstractSecurityToken
implements SecurityToken {
    private String updatedToken = null;
    private String trustedJson = null;
    private String ownerId = null;
    private String viewerId = null;
    private String appId = null;
    private String domain = null;
    private String container = null;
    private String appUrl = null;
    private String activeUrl = null;
    private String authMode = AuthenticationMode.SECURITY_TOKEN_URL_PARAMETER.name();
    private int moduleId = 0;
    private Long expiresAt = null;

    public FakeGadgetToken setUpdatedToken(String updatedToken) {
        this.updatedToken = updatedToken;
        return this;
    }

    public FakeGadgetToken setTrustedJson(String trustedJson) {
        this.trustedJson = trustedJson;
        return this;
    }

    public FakeGadgetToken setOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public FakeGadgetToken setViewerId(String viewerId) {
        this.viewerId = viewerId;
        return this;
    }

    public FakeGadgetToken setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public FakeGadgetToken setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public FakeGadgetToken setContainer(String container) {
        this.container = container;
        return this;
    }

    public FakeGadgetToken setAppUrl(String appUrl) {
        this.appUrl = appUrl;
        return this;
    }

    public FakeGadgetToken setModuleId(int moduleId) {
        this.moduleId = moduleId;
        return this;
    }

    public FakeGadgetToken setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    public FakeGadgetToken setActiveUrl(String activeUrl) {
        this.activeUrl = activeUrl;
        return this;
    }

    public void setAuthenticationMode(String authMode) {
        this.authMode = authMode;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getViewerId() {
        return this.viewerId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getContainer() {
        return this.container;
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public long getModuleId() {
        return this.moduleId;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public String getUpdatedToken() {
        return this.updatedToken;
    }

    public String getAuthenticationMode() {
        return this.authMode;
    }

    public String getTrustedJson() {
        return this.trustedJson;
    }

    public boolean isAnonymous() {
        return false;
    }

    public String getActiveUrl() {
        return this.activeUrl;
    }

    public static SecurityToken createToken(String tokenString) {
        String[] keyValuePairs = tokenString.split("&");
        HashMap paramMap = Maps.newHashMap();
        for (String keyValuePair : keyValuePairs) {
            String[] keyAndValue = keyValuePair.split("=");
            if (keyAndValue.length != 2) continue;
            paramMap.put(keyAndValue[0], keyAndValue[1]);
        }
        return FakeGadgetToken.createToken(paramMap);
    }

    public static FakeGadgetToken createToken(Map<String, String> paramMap) {
        FakeGadgetToken fakeToken = new FakeGadgetToken();
        fakeToken.setAppId(paramMap.get("appId"));
        fakeToken.setAppUrl(paramMap.get("appUrl"));
        fakeToken.setDomain(paramMap.get("domain"));
        fakeToken.setOwnerId(paramMap.get("ownerId"));
        fakeToken.setTrustedJson(paramMap.get("trustedJson"));
        fakeToken.setViewerId(paramMap.get("viewerId"));
        String moduleIdStr = paramMap.get("module");
        if (moduleIdStr != null) {
            fakeToken.setModuleId(Integer.parseInt(moduleIdStr));
        }
        return fakeToken;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Codec
    implements SecurityTokenCodec {
        public SecurityToken createToken(Map<String, String> tokenParameters) {
            return FakeGadgetToken.createToken(tokenParameters);
        }

        public String encodeToken(SecurityToken token) throws SecurityTokenException {
            return null;
        }
    }
}

