/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuth;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlParameterAuthenticationHandler
implements AuthenticationHandler {
    private static final String SECURITY_TOKEN_PARAM = "st";
    private final SecurityTokenCodec securityTokenCodec;
    private static final Pattern COMMAWHITESPACE = Pattern.compile("\\s*,\\s*");
    private static final Pattern AUTHORIZATION = Pattern.compile("\\s*(\\w*)\\s+(.*)");
    private static final Pattern NVP = Pattern.compile("(\\S*)\\s*\\=\\s*\"([^\"]*)\"");

    @Inject
    public UrlParameterAuthenticationHandler(SecurityTokenCodec securityTokenCodec) {
        this.securityTokenCodec = securityTokenCodec;
    }

    @Override
    public String getName() {
        return AuthenticationMode.SECURITY_TOKEN_URL_PARAMETER.name();
    }

    @Override
    public SecurityToken getSecurityTokenFromRequest(HttpServletRequest request) throws AuthenticationHandler.InvalidAuthenticationException {
        Map<String, String> parameters = this.getMappedParameters(request);
        String token = parameters.get("token");
        try {
            if (token == null || StringUtils.isBlank((String)token)) {
                return null;
            }
            return this.securityTokenCodec.createToken(parameters);
        }
        catch (SecurityTokenException e) {
            throw new AuthenticationHandler.InvalidAuthenticationException("Malformed security token " + token, e);
        }
    }

    @Override
    public String getWWWAuthenticateHeader(String realm) {
        return null;
    }

    protected SecurityTokenCodec getSecurityTokenCodec() {
        return this.securityTokenCodec;
    }

    protected Map<String, String> getMappedParameters(HttpServletRequest request) {
        HashMap params = Maps.newHashMap();
        String token = null;
        if (token == null) {
            token = request.getParameter(SECURITY_TOKEN_PARAM);
        }
        if (token == null && request.isSecure() && request.getParameter("oauth_signature_method") == null) {
            token = request.getParameter("oauth_token");
        }
        if (token == null) {
            Enumeration headers = request.getHeaders("Authorization");
            while (headers != null && headers.hasMoreElements()) {
                Matcher m = AUTHORIZATION.matcher((CharSequence)headers.nextElement());
                if (!m.matches() || !"Token".equalsIgnoreCase(m.group(1))) continue;
                for (String nvp : COMMAWHITESPACE.split(m.group(2))) {
                    m = NVP.matcher(nvp);
                    if (!m.matches() || !"token".equals(m.group(1))) continue;
                    token = OAuth.decodePercent((String)m.group(2));
                }
            }
        }
        params.put("token", token);
        params.put("activeUrl", this.getActiveUrl(request));
        return params;
    }

    protected String getActiveUrl(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }
}

