/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.base.Preconditions;

public class ProtocolException
extends RuntimeException {
    private final int errorCode;
    private final Object response;

    public ProtocolException(int errorCode, String errorMessage, Throwable cause) {
        super(errorMessage, cause);
        this.checkErrorCode(errorCode);
        this.errorCode = errorCode;
        this.response = null;
    }

    public ProtocolException(int errorCode, String errorMessage) {
        this(errorCode, errorMessage, null);
    }

    public ProtocolException(int errorCode, String errorMessage, Object response) {
        super(errorMessage);
        this.checkErrorCode(errorCode);
        this.errorCode = errorCode;
        this.response = response;
    }

    public int getCode() {
        return this.errorCode;
    }

    public Object getResponse() {
        return this.response;
    }

    private void checkErrorCode(int code) {
        Preconditions.checkArgument((code != 200 ? 1 : 0) != 0, (Object)"May not use OK error code with ProtocolException");
    }
}

