/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.LruCacheProvider;
import org.apache.shindig.common.testing.TestExecutorService;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.gadgets.DefaultMessageBundleFactory;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DefaultMessageBundleFactoryTest {
    private static final Uri BUNDLE_URI = Uri.parse((String)"http://example.org/messagex.xml");
    private static final Uri LANG_BUNDLE_URI = Uri.parse((String)"http://example.org/messagex.xml");
    private static final Uri COUNTRY_BUNDLE_URI = Uri.parse((String)"http://example.org/messagex.xml");
    private static final Uri ALL_BUNDLE_URI = Uri.parse((String)"http://example.org/messagex.xml");
    private static final Uri SPEC_URI = Uri.parse((String)"http://example.org/gadget.xml");
    private static final String MSG_0_NAME = "messageZero";
    private static final String MSG_1_NAME = "message1";
    private static final String MSG_2_NAME = "message 2";
    private static final String MSG_3_NAME = "message 3";
    private static final String MSG_0_VALUE = "Message 0 VALUE";
    private static final String MSG_0_LANG_VALUE = "Message 0 language VALUE";
    private static final String MSG_0_COUNTRY_VALUE = "Message 0 country VALUE";
    private static final String MSG_0_ALL_VALUE = "Message 0 a VALUE";
    private static final String MSG_1_VALUE = "msg one val";
    private static final String MSG_2_VALUE = "message two val.";
    private static final String MSG_3_VALUE = "message three value";
    private static final Locale COUNTRY_LOCALE = new Locale("all", "US");
    private static final Locale LANG_LOCALE = new Locale("en", "ALL");
    private static final Locale LOCALE = new Locale("en", "US");
    private static final String BASIC_BUNDLE = "<messagebundle>  <msg name='messageZero'>Message 0 VALUE</msg>  <msg name='message1'>msg one val</msg></messagebundle>";
    private static final String LANG_BUNDLE = "<messagebundle>  <msg name='messageZero'>Message 0 language VALUE</msg>  <msg name='lang'>true</msg></messagebundle>";
    private static final String COUNTRY_BUNDLE = "<messagebundle>  <msg name='messageZero'>Message 0 country VALUE</msg>  <msg name='country'>true</msg></messagebundle>";
    private static final String ALL_ALL_BUNDLE = "<messagebundle>  <msg name='messageZero'>Message 0 a VALUE</msg>  <msg name='all'>true</msg></messagebundle>";
    private static final String BASIC_SPEC = "<Module><ModulePrefs title='foo'> <Locale>  <msg name='messageZero'>Message 0 a VALUE</msg> </Locale> <Locale country='" + LOCALE.getCountry() + "'>" + "  <msg name='" + "messageZero" + "'>" + "Message 0 country VALUE" + "</msg>" + "  <msg name='" + "message 3" + "'>" + "message three value" + "</msg>" + " </Locale>" + " <Locale lang='" + LOCALE.getLanguage() + "'>" + "  <msg name='" + "messageZero" + "'>" + "Message 0 language VALUE" + "</msg>" + "  <msg name='" + "message1" + "'>" + "msg one val" + "</msg>" + "  <msg name='" + "message 2" + "'>" + "message two val." + "</msg>" + " </Locale>" + " <Locale lang='" + LOCALE.getLanguage() + "' country='" + LOCALE.getCountry() + "' " + "  messages='" + BUNDLE_URI + "'/>" + "</ModulePrefs>" + "<Content type='html'/>" + "</Module>";
    private static final String ALL_EXTERNAL_SPEC = "<Module><ModulePrefs title='foo'> <Locale messages='" + BUNDLE_URI + "'/>" + " <Locale country='" + LOCALE.getCountry() + '\'' + "  messages='" + COUNTRY_BUNDLE_URI + "'/>" + " <Locale lang='" + LOCALE.getLanguage() + "' messages='" + LANG_BUNDLE_URI + "'/>" + " <Locale lang='" + LOCALE.getLanguage() + "' country='" + LOCALE.getCountry() + "' " + "  messages='" + ALL_BUNDLE_URI + "'/>" + "</ModulePrefs>" + "<Content type='html'/>" + "</Module>";
    private static final int MAX_AGE = 10000;
    private final RequestPipeline pipeline = (RequestPipeline)EasyMock.createNiceMock(RequestPipeline.class);
    private final CacheProvider cacheProvider = new LruCacheProvider(10);
    private final Cache<String, MessageBundle> cache = this.cacheProvider.createCache("messageBundles");
    private final DefaultMessageBundleFactory bundleFactory = new DefaultMessageBundleFactory((ExecutorService)new TestExecutorService(), this.pipeline, this.cacheProvider, 10000L);
    private final GadgetSpec gadgetSpec;
    private final GadgetSpec externalSpec;

    public DefaultMessageBundleFactoryTest() {
        try {
            this.gadgetSpec = new GadgetSpec(SPEC_URI, BASIC_SPEC);
            this.externalSpec = new GadgetSpec(SPEC_URI, ALL_EXTERNAL_SPEC);
        }
        catch (GadgetException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void getExactBundle() throws Exception {
        HttpResponse response = new HttpResponse(BASIC_BUNDLE);
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        MessageBundle bundle = this.bundleFactory.getBundle(this.gadgetSpec, LOCALE, true, "default");
        Assert.assertEquals((Object)MSG_0_VALUE, bundle.getMessages().get(MSG_0_NAME));
        Assert.assertEquals((Object)MSG_1_VALUE, bundle.getMessages().get(MSG_1_NAME));
        Assert.assertEquals((Object)MSG_2_VALUE, bundle.getMessages().get(MSG_2_NAME));
        Assert.assertEquals((Object)MSG_3_VALUE, bundle.getMessages().get(MSG_3_NAME));
    }

    @Test
    public void getLangBundle() throws Exception {
        MessageBundle bundle = this.bundleFactory.getBundle(this.gadgetSpec, LANG_LOCALE, true, "default");
        Assert.assertEquals((Object)MSG_0_LANG_VALUE, bundle.getMessages().get(MSG_0_NAME));
        Assert.assertEquals((Object)MSG_1_VALUE, bundle.getMessages().get(MSG_1_NAME));
        Assert.assertEquals((Object)MSG_2_VALUE, bundle.getMessages().get(MSG_2_NAME));
        Assert.assertNull(bundle.getMessages().get(MSG_3_NAME));
    }

    @Test
    public void getCountryBundle() throws Exception {
        MessageBundle bundle = this.bundleFactory.getBundle(this.gadgetSpec, COUNTRY_LOCALE, true, "default");
        Assert.assertEquals((Object)MSG_0_COUNTRY_VALUE, bundle.getMessages().get(MSG_0_NAME));
        Assert.assertNull(bundle.getMessages().get(MSG_1_NAME));
        Assert.assertNull(bundle.getMessages().get(MSG_2_NAME));
        Assert.assertEquals((Object)MSG_3_VALUE, bundle.getMessages().get(MSG_3_NAME));
    }

    @Test
    public void getAllAllBundle() throws Exception {
        MessageBundle bundle = this.bundleFactory.getBundle(this.gadgetSpec, new Locale("all", "ALL"), true, "default");
        Assert.assertEquals((Object)MSG_0_ALL_VALUE, bundle.getMessages().get(MSG_0_NAME));
        Assert.assertNull(bundle.getMessages().get(MSG_1_NAME));
        Assert.assertNull(bundle.getMessages().get(MSG_2_NAME));
        Assert.assertNull(bundle.getMessages().get(MSG_3_NAME));
    }

    @Test
    public void getExactBundleAllExternal() throws Exception {
        HttpResponse response = new HttpResponse(BASIC_BUNDLE);
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)response);
        HttpResponse langResponse = new HttpResponse(LANG_BUNDLE);
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)langResponse);
        HttpResponse countryResponse = new HttpResponse(COUNTRY_BUNDLE);
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)countryResponse);
        HttpResponse allAllResponse = new HttpResponse(ALL_ALL_BUNDLE);
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)allAllResponse);
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        MessageBundle bundle = this.bundleFactory.getBundle(this.externalSpec, LOCALE, true, "default");
        EasyMock.verify((Object[])new Object[]{this.pipeline});
        Assert.assertEquals((Object)"true", bundle.getMessages().get("lang"));
        Assert.assertEquals((Object)"true", bundle.getMessages().get("country"));
        Assert.assertEquals((Object)"true", bundle.getMessages().get("all"));
        Assert.assertEquals((Object)MSG_0_VALUE, bundle.getMessages().get(MSG_0_NAME));
    }

    @Test
    public void getLangBundleAllExternal() throws Exception {
        HttpResponse langResponse = new HttpResponse(LANG_BUNDLE);
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)langResponse);
        HttpResponse allAllResponse = new HttpResponse(ALL_ALL_BUNDLE);
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)allAllResponse);
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        MessageBundle bundle = this.bundleFactory.getBundle(this.externalSpec, LANG_LOCALE, true, "default");
        EasyMock.verify((Object[])new Object[]{this.pipeline});
        Assert.assertEquals((Object)"true", bundle.getMessages().get("lang"));
        Assert.assertEquals((Object)"true", bundle.getMessages().get("all"));
        Assert.assertEquals((Object)MSG_0_LANG_VALUE, bundle.getMessages().get(MSG_0_NAME));
    }

    @Test
    public void getCountryBundleAllExternal() throws Exception {
        HttpResponse countryResponse = new HttpResponse(COUNTRY_BUNDLE);
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)countryResponse);
        HttpResponse allAllResponse = new HttpResponse(ALL_ALL_BUNDLE);
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)allAllResponse);
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        MessageBundle bundle = this.bundleFactory.getBundle(this.externalSpec, COUNTRY_LOCALE, true, "default");
        EasyMock.verify((Object[])new Object[]{this.pipeline});
        Assert.assertEquals((Object)"true", bundle.getMessages().get("country"));
        Assert.assertEquals((Object)"true", bundle.getMessages().get("all"));
        Assert.assertEquals((Object)MSG_0_COUNTRY_VALUE, bundle.getMessages().get(MSG_0_NAME));
    }

    @Test
    public void getAllAllExternal() throws Exception {
        HttpResponse allAllResponse = new HttpResponse(ALL_ALL_BUNDLE);
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)allAllResponse);
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        MessageBundle bundle = this.bundleFactory.getBundle(this.externalSpec, new Locale("all", "ALL"), true, "default");
        EasyMock.verify((Object[])new Object[]{this.pipeline});
        Assert.assertEquals((Object)"true", bundle.getMessages().get("all"));
        Assert.assertEquals((Object)MSG_0_ALL_VALUE, bundle.getMessages().get(MSG_0_NAME));
    }

    @Test
    public void getBundleFromCache() throws Exception {
        HttpResponse response = new HttpResponse(BASIC_BUNDLE);
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)response).once();
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        MessageBundle bundle0 = this.bundleFactory.getBundle(this.gadgetSpec, LOCALE, false, "default");
        MessageBundle bundle1 = this.bundleFactory.getBundle(this.gadgetSpec, LOCALE, false, "default");
        EasyMock.verify((Object[])new Object[]{this.pipeline});
        Assert.assertEquals(bundle0.getMessages().get(MSG_0_NAME), bundle1.getMessages().get(MSG_0_NAME));
    }

    @Test
    public void ignoreCacheDoesNotStore() throws Exception {
        this.bundleFactory.getBundle(this.gadgetSpec, new Locale("all", "ALL"), true, "default");
        Assert.assertEquals((long)0L, (long)this.cache.getSize());
    }

    @Test
    public void badResponseServedFromCache() throws Exception {
        HttpResponse expiredResponse = new HttpResponseBuilder().setResponse(BASIC_BUNDLE.getBytes("UTF-8")).addHeader("Pragma", "no-cache").create();
        HttpResponse badResponse = HttpResponse.error();
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)expiredResponse).once();
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)badResponse).once();
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        final AtomicLong time = new AtomicLong();
        this.bundleFactory.cache.setTimeSource(new TimeSource(){

            public long currentTimeMillis() {
                return time.get();
            }
        });
        time.set(System.currentTimeMillis());
        MessageBundle bundle0 = this.bundleFactory.getBundle(this.gadgetSpec, LOCALE, false, "default");
        time.set(time.get() + 10000L + 1L);
        MessageBundle bundle1 = this.bundleFactory.getBundle(this.gadgetSpec, LOCALE, false, "default");
        EasyMock.verify((Object[])new Object[]{this.pipeline});
        Assert.assertEquals(bundle0.getMessages().get(MSG_0_NAME), bundle1.getMessages().get(MSG_0_NAME));
    }

    @Test(expected=GadgetException.class)
    public void badResponsePropagatesException() throws Exception {
        HttpResponse badResponse = HttpResponse.error();
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)badResponse).once();
        EasyMock.replay((Object[])new Object[]{this.pipeline});
        this.bundleFactory.getBundle(this.gadgetSpec, LOCALE, false, "default");
    }

    @Test
    public void ttlPropagatesToFetcher() throws Exception {
        CapturingFetcher capturingFetcher = new CapturingFetcher();
        DefaultMessageBundleFactory factory = new DefaultMessageBundleFactory((ExecutorService)new TestExecutorService(), (RequestPipeline)capturingFetcher, this.cacheProvider, 10000L);
        factory.getBundle(this.gadgetSpec, LOCALE, false, "default");
        Assert.assertEquals((long)10L, (long)capturingFetcher.request.getCacheTtl());
    }

    private static class CapturingFetcher
    implements RequestPipeline {
        HttpRequest request;

        protected CapturingFetcher() {
        }

        public HttpResponse execute(HttpRequest request) {
            this.request = request;
            return new HttpResponse(DefaultMessageBundleFactoryTest.BASIC_BUNDLE);
        }
    }
}

