/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.features.FeatureResourceLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureRegistryTest {
    private static final String NODEP_TPL = FeatureRegistryTest.getFeatureTpl("nodep", new String[0]);
    private static final String TOP_TPL = FeatureRegistryTest.getFeatureTpl("top", new String[]{"mid_a", "mid_b"});
    private static final String MID_A_TPL = FeatureRegistryTest.getFeatureTpl("mid_a", new String[]{"bottom"});
    private static final String MID_B_TPL = FeatureRegistryTest.getFeatureTpl("mid_b", new String[]{"bottom"});
    private static final String BOTTOM_TPL = FeatureRegistryTest.getFeatureTpl("bottom", new String[0]);
    private static final String LOOP_A_TPL = FeatureRegistryTest.getFeatureTpl("loop_a", new String[]{"loop_b"});
    private static final String LOOP_B_TPL = FeatureRegistryTest.getFeatureTpl("loop_b", new String[]{"loop_c"});
    private static final String LOOP_C_TPL = FeatureRegistryTest.getFeatureTpl("loop_c", new String[]{"loop_a"});
    private static final String BAD_DEP_TPL = FeatureRegistryTest.getFeatureTpl("bad_dep", new String[]{"no-exists"});
    private static String RESOURCE_BASE_PATH = "/resource/base/path";
    private static int resourceIdx = 0;
    private FeatureResourceLoader resourceLoader;
    private ResourceMock resourceMock;
    private FeatureRegistry registry;
    private Map<String, String> lastAttribs;

    @Before
    public void setUp() {
        this.resourceMock = new ResourceMock();
        this.lastAttribs = null;
        this.resourceLoader = new FeatureResourceLoader(){

            public FeatureResource load(Uri uri, Map<String, String> attribs) throws GadgetException {
                FeatureRegistryTest.this.lastAttribs = (Map)ImmutableMap.copyOf(attribs);
                return super.load(uri, attribs);
            }

            protected String getResourceContent(String resource) {
                try {
                    return FeatureRegistryTest.this.resourceMock.get(resource);
                }
                catch (IOException e) {
                    return null;
                }
            }
        };
    }

    @Test
    public void registerFromFileFeatureXmlFileScheme() throws Exception {
        this.checkRegisterFromFileFeatureXml(true);
    }

    @Test
    public void registerFromFileFeatureXmlNoScheme() throws Exception {
        this.checkRegisterFromFileFeatureXml(false);
    }

    private void checkRegisterFromFileFeatureXml(boolean withScheme) throws Exception {
        String content = "content-" + (withScheme ? "withScheme" : "noScheme");
        Uri resUri = FeatureRegistryTest.makeFile(content);
        Uri featureFile = FeatureRegistryTest.makeFile(FeatureRegistryTest.xml(NODEP_TPL, "gadget", withScheme ? resUri.toString() : resUri.getPath(), null));
        this.registry = new TestFeatureRegistry(withScheme ? featureFile.toString() : featureFile.getPath());
        List resources = this.registry.getAllFeatures();
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)content, (Object)((FeatureResource)resources.get(0)).getContent());
    }

    @Test
    public void registerFromFileInNestedDirectoryFeatureXmlFile() throws Exception {
        File tmpFile = File.createTempFile("dummy", ".dat");
        tmpFile.deleteOnExit();
        File parentDir = tmpFile.getParentFile();
        String childDirName = String.valueOf(Math.random());
        File childDir = new File(parentDir, childDirName);
        childDir.mkdirs();
        childDir.deleteOnExit();
        File featureDir = new File(childDir, "thefeature");
        featureDir.mkdirs();
        featureDir.deleteOnExit();
        File resFile = File.createTempFile("content", ".js", featureDir);
        resFile.deleteOnExit();
        String content = "content-foo";
        BufferedWriter out = new BufferedWriter(new FileWriter(resFile));
        out.write(content);
        out.close();
        File featureFile = File.createTempFile("feature", ".xml", featureDir);
        featureFile.deleteOnExit();
        out = new BufferedWriter(new FileWriter(featureFile));
        out.write(FeatureRegistryTest.xml(NODEP_TPL, "gadget", resFile.toURI().toString(), null));
        out.close();
        this.registry = new TestFeatureRegistry(childDir.toURI().toString());
        List resources = this.registry.getAllFeatures();
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)content, (Object)((FeatureResource)resources.get(0)).getContent());
    }

    @Test
    public void registerFromResourceFeatureXml() throws Exception {
        String content = "resource-content()";
        Uri contentUri = this.expectResource(content);
        Uri featureUri = this.expectResource(FeatureRegistryTest.xml(NODEP_TPL, "gadget", contentUri.getPath(), null));
        this.registry = new TestFeatureRegistry(featureUri.toString());
        List resources = this.registry.getAllFeatures();
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)content, (Object)((FeatureResource)resources.get(0)).getContent());
    }

    @Test
    public void registerFromResourceFeatureXmlRelativeContent() throws Exception {
        String content = "resource-content-relative()";
        Uri contentUri = this.expectResource(content);
        String relativePath = contentUri.getPath().substring(contentUri.getPath().lastIndexOf(47) + 1);
        Uri featureUri = this.expectResource(FeatureRegistryTest.xml(NODEP_TPL, "gadget", relativePath, null));
        this.registry = new TestFeatureRegistry(featureUri.toString());
        List resources = this.registry.getAllFeatures();
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)content, (Object)((FeatureResource)resources.get(0)).getContent());
    }

    @Test
    public void registerFromResourceIndex() throws Exception {
        String content1 = "content1()";
        Uri content1Uri = this.expectResource(content1);
        Uri feature1Uri = this.expectResource(FeatureRegistryTest.xml(MID_A_TPL, "gadget", content1Uri.getPath(), null));
        String content2 = "inline()";
        Uri feature2Uri = this.expectResource(FeatureRegistryTest.xml(BOTTOM_TPL, "gadget", null, content2));
        Uri txtFile = this.expectResource(feature1Uri.toString() + '\n' + feature2Uri.toString(), ".txt");
        this.registry = new TestFeatureRegistry(txtFile.toString());
        List resources = this.registry.getAllFeatures();
        Assert.assertEquals((long)2L, (long)resources.size());
        Assert.assertEquals((Object)content2, (Object)((FeatureResource)resources.get(0)).getContent());
        Assert.assertEquals((Object)content1, (Object)((FeatureResource)resources.get(1)).getContent());
    }

    @Test
    public void registerOverrideFeature() throws Exception {
        String content1 = "content1()";
        Uri content1Uri = this.expectResource(content1);
        Uri feature1Uri = this.expectResource(FeatureRegistryTest.xml(BOTTOM_TPL, "gadget", content1Uri.getPath(), null));
        String content2 = "content_two()";
        Uri content2Uri = this.expectResource(content2);
        Uri feature2Uri = this.expectResource(FeatureRegistryTest.xml(BOTTOM_TPL, "gadget", content2Uri.getPath(), null));
        this.registry = new TestFeatureRegistry(feature1Uri.toString());
        List resources1 = this.registry.getAllFeatures();
        Assert.assertEquals((long)1L, (long)resources1.size());
        Assert.assertEquals((Object)content1, (Object)((FeatureResource)resources1.get(0)).getContent());
        this.registry = new TestFeatureRegistry(feature2Uri.toString());
        List resources2 = this.registry.getAllFeatures();
        Assert.assertEquals((long)1L, (long)resources2.size());
        Assert.assertEquals((Object)content2, (Object)((FeatureResource)resources2.get(0)).getContent());
        List resourcesAgain = this.registry.getAllFeatures();
        Assert.assertSame((Object)resources2, (Object)resourcesAgain);
    }

    @Test
    public void cacheAccountsForUnsupportedState() throws Exception {
        String content1 = "content1()";
        Uri content1Uri = this.expectResource(content1);
        HashMap attribs = Maps.newHashMap();
        String theContainer = "the-container";
        attribs.put("container", theContainer);
        Uri feature1Uri = this.expectResource(FeatureRegistryTest.xml(BOTTOM_TPL, "gadget", content1Uri.getPath(), null, attribs));
        this.registry = new TestFeatureRegistry(feature1Uri.toString());
        ArrayList needed = Lists.newArrayList((Object[])new String[]{"bottom"});
        ArrayList unsupported = Lists.newArrayList();
        List resources = this.registry.getFeatureResources(this.getCtx(RenderingContext.GADGET, theContainer), (Collection)needed, (List)unsupported);
        List resourcesUnsup = this.registry.getFeatureResources(this.getCtx(RenderingContext.GADGET, theContainer), (Collection)needed, null);
        Assert.assertNotSame((Object)resources, (Object)resourcesUnsup);
        Assert.assertEquals((Object)resources, (Object)resourcesUnsup);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)content1, (Object)((FeatureResource)resources.get(0)).getContent());
        List resources2 = this.registry.getFeatureResources(this.getCtx(RenderingContext.GADGET, theContainer), (Collection)needed, (List)unsupported);
        Assert.assertSame((Object)resources, (Object)resources2);
        List resourcesUnsup2 = this.registry.getFeatureResources(this.getCtx(RenderingContext.GADGET, theContainer), (Collection)needed, null);
        Assert.assertSame((Object)resourcesUnsup, (Object)resourcesUnsup2);
        List resourcesIgnoreCache = this.registry.getFeatureResources(this.getCtx(RenderingContext.GADGET, theContainer, true), (Collection)needed, (List)unsupported);
        Assert.assertNotSame((Object)resources, (Object)resourcesIgnoreCache);
        Assert.assertEquals((long)1L, (long)resourcesIgnoreCache.size());
        Assert.assertEquals((Object)content1, (Object)((FeatureResource)resourcesIgnoreCache.get(0)).getContent());
    }

    @Test
    public void cacheAccountsForContext() throws Exception {
        String content1 = "content1()";
        Uri content1Uri = this.expectResource(content1);
        HashMap attribs = Maps.newHashMap();
        String theContainer = "the-container";
        attribs.put("container", theContainer);
        Uri feature1Uri = this.expectResource(FeatureRegistryTest.xml(BOTTOM_TPL, "gadget", content1Uri.getPath(), null, attribs));
        this.registry = new TestFeatureRegistry(feature1Uri.toString());
        ArrayList needed = Lists.newArrayList((Object[])new String[]{"bottom"});
        ArrayList unsupported = Lists.newArrayList();
        List resources = this.registry.getFeatureResources(this.getCtx(RenderingContext.GADGET, theContainer), (Collection)needed, (List)unsupported);
        List resourcesNoMatch = this.registry.getFeatureResources(this.getCtx(RenderingContext.GADGET, "foo"), (Collection)needed, (List)unsupported);
        List ctxMismatch = this.registry.getFeatureResources(this.getCtx(RenderingContext.CONTAINER, theContainer), (Collection)needed, (List)unsupported);
        Assert.assertNotSame((Object)resources, (Object)resourcesNoMatch);
        Assert.assertNotSame((Object)resources, (Object)ctxMismatch);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)content1, (Object)((FeatureResource)resources.get(0)).getContent());
        Assert.assertEquals((long)0L, (long)resourcesNoMatch.size());
        Assert.assertEquals((long)0L, (long)ctxMismatch.size());
        List resources2 = this.registry.getFeatureResources(this.getCtx(RenderingContext.GADGET, theContainer), (Collection)needed, (List)unsupported);
        Assert.assertSame((Object)resources, (Object)resources2);
        List resourcesNoMatch2 = this.registry.getFeatureResources(this.getCtx(RenderingContext.GADGET, "foo"), (Collection)needed, (List)unsupported);
        Assert.assertSame((Object)resourcesNoMatch, (Object)resourcesNoMatch2);
        List ctxMismatch2 = this.registry.getFeatureResources(this.getCtx(RenderingContext.CONTAINER, theContainer), (Collection)needed, (List)unsupported);
        Assert.assertSame((Object)ctxMismatch, (Object)ctxMismatch2);
        List resourcesIC = this.registry.getFeatureResources(this.getCtx(RenderingContext.GADGET, theContainer, true), (Collection)needed, (List)unsupported);
        Assert.assertNotSame((Object)resources, (Object)resourcesIC);
    }

    @Test
    public void missingIndexResultsInException() throws Exception {
        try {
            this.registry = new TestFeatureRegistry(FeatureRegistryTest.makeResourceUri(".txt").toString());
            Assert.fail((String)"Should have thrown an exception for missing .txt file");
        }
        catch (GadgetException e) {
            Assert.assertEquals((Object)GadgetException.Code.INVALID_PATH, (Object)e.getCode());
        }
    }

    @Test
    public void missingFileResultsInException() throws Exception {
        try {
            this.registry = new TestFeatureRegistry(new UriBuilder().setScheme("file").setPath("/is/not/there.foo.xml").toUri().toString());
            Assert.fail((String)"Should have thrown missing .xml file exception");
        }
        catch (GadgetException e) {
            Assert.assertEquals((Object)GadgetException.Code.INVALID_CONFIG, (Object)e.getCode());
        }
    }

    @Test
    public void selectExactFeatureResourcesGadget() throws Exception {
        this.checkExactFeatureResources("gadget", RenderingContext.GADGET);
    }

    @Test
    public void selectExactFeatureResourcesContainer() throws Exception {
        this.checkExactFeatureResources("container", RenderingContext.CONTAINER);
    }

    private void checkExactFeatureResources(String type, RenderingContext rctx) throws Exception {
        this.setupFullRegistry(type, null);
        GadgetContext ctx = this.getCtx(rctx, null);
        ArrayList needed = Lists.newArrayList((Object[])new String[]{"nodep", "bottom"});
        LinkedList unsupported = Lists.newLinkedList();
        List resources = this.registry.getFeatureResources(ctx, (Collection)needed, (List)unsupported);
        Assert.assertEquals((long)0L, (long)unsupported.size());
        Assert.assertEquals((long)2L, (long)resources.size());
        Assert.assertEquals((Object)"nodep", (Object)((FeatureResource)resources.get(0)).getContent());
        Assert.assertEquals((Object)"bottom", (Object)((FeatureResource)resources.get(1)).getContent());
    }

    @Test
    public void selectNoContentValidFeatureResourcesGadget() throws Exception {
        this.checkNoContentValidFeatureResources("gadget", RenderingContext.CONTAINER);
    }

    @Test
    public void selectNoContentValidFeatureResourcesContainer() throws Exception {
        this.checkNoContentValidFeatureResources("container", RenderingContext.GADGET);
    }

    private void checkNoContentValidFeatureResources(String type, RenderingContext rctx) throws Exception {
        this.setupFullRegistry(type, null);
        GadgetContext ctx = this.getCtx(rctx, null);
        ArrayList needed = Lists.newArrayList((Object[])new String[]{"nodep", "bottom"});
        LinkedList unsupported = Lists.newLinkedList();
        List resources = this.registry.getFeatureResources(ctx, (Collection)needed, (List)unsupported);
        Assert.assertEquals((long)0L, (long)resources.size());
    }

    @Test
    public void testTransitiveFeatureResourcesGadget() throws Exception {
        this.checkTransitiveFeatureResources("gadget", RenderingContext.GADGET);
    }

    @Test
    public void testTransitiveFeatureResourcesContainer() throws Exception {
        this.checkTransitiveFeatureResources("container", RenderingContext.CONTAINER);
    }

    private void checkTransitiveFeatureResources(String type, RenderingContext rctx) throws Exception {
        this.setupFullRegistry(type, null);
        GadgetContext ctx = this.getCtx(rctx, null);
        ArrayList needed = Lists.newArrayList((Object[])new String[]{"top", "nodep"});
        LinkedList unsupported = Lists.newLinkedList();
        List resources = this.registry.getFeatureResources(ctx, (Collection)needed, (List)unsupported);
        Assert.assertEquals((long)5L, (long)resources.size());
        Assert.assertEquals((Object)"bottom", (Object)((FeatureResource)resources.get(0)).getContent());
        Assert.assertEquals((Object)"mid_a", (Object)((FeatureResource)resources.get(1)).getContent());
        Assert.assertEquals((Object)"mid_b", (Object)((FeatureResource)resources.get(2)).getContent());
        Assert.assertEquals((Object)"top", (Object)((FeatureResource)resources.get(3)).getContent());
        Assert.assertEquals((Object)"nodep", (Object)((FeatureResource)resources.get(4)).getContent());
    }

    @Test
    public void unsupportedFeaturesPopulated() throws Exception {
        this.setupFullRegistry("gadget", null);
        GadgetContext ctx = this.getCtx(RenderingContext.GADGET, null);
        ArrayList needed = Lists.newArrayList((Object[])new String[]{"nodep", "does-not-exist"});
        LinkedList unsupported = Lists.newLinkedList();
        List resources = this.registry.getFeatureResources(ctx, (Collection)needed, (List)unsupported);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"nodep", (Object)((FeatureResource)resources.get(0)).getContent());
        Assert.assertEquals((long)1L, (long)unsupported.size());
        Assert.assertEquals((Object)"does-not-exist", unsupported.get(0));
    }

    @Test
    public void filterFeaturesByContainerMatch() throws Exception {
        this.setupFullRegistry("gadget", "one, two , three");
        GadgetContext ctx = this.getCtx(RenderingContext.GADGET, "two");
        ArrayList needed = Lists.newArrayList((Object[])new String[]{"nodep", "bottom"});
        LinkedList unsupported = Lists.newLinkedList();
        List resources = this.registry.getFeatureResources(ctx, (Collection)needed, (List)unsupported);
        Assert.assertEquals((long)2L, (long)resources.size());
        Assert.assertEquals((Object)"nodep", (Object)((FeatureResource)resources.get(0)).getContent());
        Assert.assertEquals((Object)"bottom", (Object)((FeatureResource)resources.get(1)).getContent());
        Assert.assertEquals((long)0L, (long)unsupported.size());
    }

    @Test
    public void filterFeaturesByContainerNoMatch() throws Exception {
        this.setupFullRegistry("gadget", "one, two, three");
        GadgetContext ctx = this.getCtx(RenderingContext.GADGET, "four");
        ArrayList needed = Lists.newArrayList((Object[])new String[]{"nodep", "bottom"});
        LinkedList unsupported = Lists.newLinkedList();
        List resources = this.registry.getFeatureResources(ctx, (Collection)needed, (List)unsupported);
        Assert.assertEquals((long)0L, (long)resources.size());
        Assert.assertEquals((long)0L, (long)unsupported.size());
    }

    @Test
    public void getFeatureResourcesNoTransitiveSingle() throws Exception {
        this.setupFullRegistry("gadget", null);
        GadgetContext ctx = this.getCtx(RenderingContext.GADGET, null);
        ArrayList needed = Lists.newArrayList((Object[])new String[]{"top", "bottom"});
        LinkedList unsupported = Lists.newLinkedList();
        List resources = this.registry.getFeatureResources(ctx, (Collection)needed, (List)unsupported, false);
        Assert.assertEquals((long)2L, (long)resources.size());
        Assert.assertEquals((Object)"top", (Object)((FeatureResource)resources.get(0)).getContent());
        Assert.assertEquals((Object)"bottom", (Object)((FeatureResource)resources.get(1)).getContent());
        Assert.assertEquals((long)0L, (long)unsupported.size());
    }

    @Test
    public void getAllFeatures() throws Exception {
        this.setupFullRegistry("gadget", null);
        List resources = this.registry.getAllFeatures();
        Assert.assertEquals((long)5L, (long)resources.size());
    }

    @Test
    public void getFeaturesStringsNoTransitive() throws Exception {
        this.setupFullRegistry("gadget", null);
        ArrayList needed = Lists.newArrayList((Object[])new String[]{"nodep", "bottom"});
        List featureNames = this.registry.getFeatures((Collection)needed);
        Assert.assertEquals((long)2L, (long)featureNames.size());
        Assert.assertEquals((Object)"nodep", featureNames.get(0));
        Assert.assertEquals((Object)"bottom", featureNames.get(1));
    }

    @Test
    public void getFeaturesStringsTransitive() throws Exception {
        this.setupFullRegistry("gadget", null);
        ArrayList needed = Lists.newArrayList((Object[])new String[]{"top", "nodep"});
        List featureNames = this.registry.getFeatures((Collection)needed);
        Assert.assertEquals((long)5L, (long)featureNames.size());
        Assert.assertEquals((Object)"bottom", featureNames.get(0));
        Assert.assertEquals((Object)"mid_a", featureNames.get(1));
        Assert.assertEquals((Object)"mid_b", featureNames.get(2));
        Assert.assertEquals((Object)"top", featureNames.get(3));
        Assert.assertEquals((Object)"nodep", featureNames.get(4));
    }

    @Test
    public void loopIsDetectedAndCrashes() throws Exception {
        String type = "gadget";
        Uri loopAUri = this.expectResource(FeatureRegistryTest.xml(LOOP_A_TPL, type, null, "loop_a"));
        Uri loopBUri = this.expectResource(FeatureRegistryTest.xml(LOOP_B_TPL, type, null, "loop_b"));
        Uri loopCUri = this.expectResource(FeatureRegistryTest.xml(LOOP_C_TPL, type, null, "loop_c"));
        Uri txtFile = this.expectResource(loopAUri.toString() + '\n' + loopBUri.toString() + '\n' + loopCUri.toString(), ".txt");
        try {
            this.registry = new TestFeatureRegistry(txtFile.toString());
            Assert.fail((String)"Should have thrown a loop-detected exception");
        }
        catch (GadgetException e) {
            Assert.assertEquals((Object)GadgetException.Code.INVALID_CONFIG, (Object)e.getCode());
        }
    }

    @Test
    public void unavailableFeatureCrashes() throws Exception {
        Uri featUri = this.expectResource(FeatureRegistryTest.xml(BAD_DEP_TPL, "gadget", null, "content"));
        try {
            this.registry = new TestFeatureRegistry(featUri.toString());
        }
        catch (GadgetException e) {
            Assert.assertEquals((Object)GadgetException.Code.INVALID_CONFIG, (Object)e.getCode());
        }
    }

    @Test
    public void returnOnlyContainerFilteredJs() throws Exception {
        String feature = "thefeature";
        String container = "foo";
        String containerContent = "content1();";
        String defaultContent = "content2();";
        Uri featureUri = this.expectResource(this.getContainerAndDefaultTpl(feature, container, containerContent, defaultContent));
        this.registry = new TestFeatureRegistry(featureUri.toString());
        ArrayList needed = Lists.newArrayList((Object[])new String[]{feature});
        LinkedList unsupported = Lists.newLinkedList();
        List resources = this.registry.getFeatureResources(this.getCtx(RenderingContext.GADGET, container), (Collection)needed, (List)unsupported);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)containerContent, (Object)((FeatureResource)resources.get(0)).getContent());
    }

    @Test
    public void returnDefaultMatchJs() throws Exception {
        String feature = "thefeature";
        String container = "foo";
        String containerContent = "content1();";
        String defaultContent = "content2();";
        Uri featureUri = this.expectResource(this.getContainerAndDefaultTpl(feature, container, containerContent, defaultContent));
        this.registry = new TestFeatureRegistry(featureUri.toString());
        ArrayList needed = Lists.newArrayList((Object[])new String[]{feature});
        LinkedList unsupported = Lists.newLinkedList();
        List resources = this.registry.getFeatureResources(this.getCtx(RenderingContext.GADGET, "othercontainer"), (Collection)needed, (List)unsupported);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)defaultContent, (Object)((FeatureResource)resources.get(0)).getContent());
    }

    private String getContainerAndDefaultTpl(String name, String container, String c1, String c2) {
        StringBuilder sb = new StringBuilder();
        sb.append("<feature><name>").append(name).append("</name>");
        sb.append("<gadget container=\"").append(container).append("\">");
        sb.append("<script>").append(c1).append("</script></gadget>");
        sb.append("<gadget>");
        sb.append("<script>").append(c2).append("</script></gadget>");
        sb.append("</feature>");
        return sb.toString();
    }

    @Test
    public void resourceGetsMergedAttribs() throws Exception {
        String content1 = "content1()";
        Uri content1Uri = this.expectResource(content1);
        HashMap attribs = Maps.newHashMap();
        String theContainer = "the-container";
        attribs.put("container", theContainer);
        attribs.put("one", "bundle-one");
        attribs.put("two", "bundle-two");
        HashMap resourceAttribs = Maps.newHashMap();
        attribs.put("two", "attrib-two");
        attribs.put("three", "attrib-three");
        Uri feature1Uri = this.expectResource(FeatureRegistryTest.xml(BOTTOM_TPL, "gadget", content1Uri.getPath(), null, attribs, resourceAttribs));
        this.registry = new TestFeatureRegistry(feature1Uri.toString());
        ArrayList needed = Lists.newArrayList((Object[])new String[]{"bottom"});
        ArrayList unsupported = Lists.newArrayList();
        List resources = this.registry.getFeatureResources(this.getCtx(RenderingContext.GADGET, theContainer), (Collection)needed, (List)unsupported);
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertNotNull(this.lastAttribs);
        Assert.assertEquals((long)4L, (long)this.lastAttribs.size());
        Assert.assertEquals((Object)theContainer, (Object)this.lastAttribs.get("container"));
        Assert.assertEquals((Object)"bundle-one", (Object)this.lastAttribs.get("one"));
        Assert.assertEquals((Object)"attrib-two", (Object)this.lastAttribs.get("two"));
        Assert.assertEquals((Object)"attrib-three", (Object)this.lastAttribs.get("three"));
    }

    private GadgetContext getCtx(RenderingContext rctx, String container) {
        return this.getCtx(rctx, container, false);
    }

    private GadgetContext getCtx(final RenderingContext rctx, final String container, final boolean ignoreCache) {
        return new GadgetContext(){

            public RenderingContext getRenderingContext() {
                return rctx;
            }

            public String getContainer() {
                return container != null ? container : "default";
            }

            public boolean getIgnoreCache() {
                return ignoreCache;
            }
        };
    }

    private void setupFullRegistry(String type, String containers) throws Exception {
        HashMap attribs = Maps.newHashMap();
        if (containers != null) {
            attribs.put("container", containers);
        }
        Uri nodepUri = this.expectResource(FeatureRegistryTest.xml(NODEP_TPL, type, null, "nodep", attribs));
        Uri topUri = this.expectResource(FeatureRegistryTest.xml(TOP_TPL, type, null, "top", attribs));
        Uri midAUri = this.expectResource(FeatureRegistryTest.xml(MID_A_TPL, type, null, "mid_a", attribs));
        Uri midBUri = this.expectResource(FeatureRegistryTest.xml(MID_B_TPL, type, null, "mid_b", attribs));
        Uri bottomUri = this.expectResource(FeatureRegistryTest.xml(BOTTOM_TPL, type, null, "bottom", attribs));
        Uri txtFile = this.expectResource(nodepUri.toString() + '\n' + topUri.toString() + '\n' + midAUri.toString() + '\n' + midBUri.toString() + '\n' + bottomUri.toString(), ".txt");
        this.registry = new TestFeatureRegistry(txtFile.toString());
    }

    private Uri expectResource(String content) {
        return this.expectResource(content, ".xml");
    }

    private Uri expectResource(String content, String suffix) {
        Uri res = FeatureRegistryTest.makeResourceUri(suffix);
        this.resourceMock.put(res.getPath(), content);
        return res;
    }

    private static String getFeatureTpl(String name, String[] deps) {
        StringBuilder sb = new StringBuilder();
        sb.append("<feature><name>").append(name).append("</name>");
        for (String dep : deps) {
            sb.append("<dependency>").append(dep).append("</dependency>");
        }
        sb.append("<%type% %type_attribs%><script %uri% %res_attribs%>%content%</script></%type%>");
        sb.append("</feature>");
        return sb.toString();
    }

    private static String xml(String tpl, String type, String uri, String content) {
        return FeatureRegistryTest.xml(tpl, type, uri, content, Maps.newHashMap());
    }

    private static String xml(String tpl, String type, String uri, String content, Map<String, String> attribs) {
        return FeatureRegistryTest.xml(tpl, type, uri, content, attribs, Maps.newHashMap());
    }

    private static String xml(String tpl, String type, String uri, String content, Map<String, String> attribs, Map<String, String> resourceAttribs) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : attribs.entrySet()) {
            sb.append(entry.getKey()).append("=\"").append(entry.getValue()).append("\" ");
        }
        StringBuilder sbRes = new StringBuilder();
        for (Map.Entry<String, String> entry : resourceAttribs.entrySet()) {
            sbRes.append(entry.getKey()).append("=\"").append(entry.getValue()).append("\" ");
        }
        return tpl.replace("%type%", type).replace("%uri%", uri != null ? "src=\"" + uri + '\"' : "").replace("%content%", content != null ? content : "").replace("%type_attribs%", sb.toString()).replace("%res_attribs%", sbRes.toString());
    }

    private static Uri makeFile(String content) throws Exception {
        File file = File.createTempFile("feat", ".xml");
        file.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write(content);
        out.close();
        return Uri.fromJavaUri((URI)file.toURI());
    }

    private static Uri makeResourceUri(String suffix) {
        return Uri.parse((String)("res://" + RESOURCE_BASE_PATH + "/file" + ++resourceIdx + suffix));
    }

    private static class ResourceMock {
        private final Map<String, String> resourceMap = Maps.newHashMap();

        private ResourceMock() {
        }

        private void put(String key, String value) {
            this.resourceMap.put(this.clean(key), value);
        }

        private String get(String key) throws IOException {
            if (!this.resourceMap.containsKey(key = this.clean(key))) {
                throw new IOException("Missing resource: " + key);
            }
            return this.resourceMap.get(key);
        }

        private String clean(String key) {
            return key.startsWith("/") ? key.substring(1) : key;
        }
    }

    private class TestFeatureRegistry
    extends FeatureRegistry {
        TestFeatureRegistry(String featureFiles) throws GadgetException {
            super(FeatureRegistryTest.this.resourceLoader, (List)ImmutableList.of((Object)featureFiles));
        }

        String getResourceContent(String resource) throws IOException {
            return FeatureRegistryTest.this.resourceMock.get(resource);
        }
    }
}

