/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.http.InvalidationHandler;
import org.apache.shindig.gadgets.http.InvalidationService;
import org.apache.shindig.protocol.DefaultHandlerRegistry;
import org.apache.shindig.protocol.HandlerExecutionListener;
import org.apache.shindig.protocol.HandlerRegistry;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestHandler;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class InvalidationHandlerTest
extends EasyMockTestCase {
    private BeanJsonConverter converter;
    private InvalidationService invalidationService;
    private InvalidationHandler handler;
    private FakeGadgetToken token;
    private Map<String, String[]> params;
    protected HandlerRegistry registry;
    protected ContainerConfig containerConfig;

    @Before
    public void setUp() throws Exception {
        this.token = new FakeGadgetToken();
        this.token.setAppId("appId");
        this.token.setViewerId("userX");
        this.converter = (BeanJsonConverter)this.mock(BeanJsonConverter.class);
        this.invalidationService = (InvalidationService)this.mock(InvalidationService.class);
        this.handler = new InvalidationHandler(this.invalidationService);
        this.registry = new DefaultHandlerRegistry(null, this.converter, (HandlerExecutionListener)new HandlerExecutionListener.NoOpHandler());
        this.registry.addHandlers((Set)Sets.newHashSet((Object[])new Object[]{this.handler}));
        this.params = Maps.newHashMap();
    }

    @Test
    public void testHandleSimpleGetInvalidateViewer() throws Exception {
        String path = "/cache/invalidate";
        RestHandler operation = this.registry.getRestHandler(path, "GET");
        this.invalidationService.invalidateUserResources((Set)EasyMock.eq((Object)ImmutableSet.of((Object)"userX")), (SecurityToken)EasyMock.eq((Object)this.token));
        EasyMock.expectLastCall();
        this.replay();
        operation.execute(this.params, null, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
        this.reset();
    }

    @Test
    public void testAllowConsumerAuthInvalidateAppResource() throws Exception {
        String path = "/cache/invalidate";
        RestHandler operation = this.registry.getRestHandler(path, "POST");
        this.params.put("invalidationKeys", new String[]{"http://www.example.org/gadget.xml"});
        this.token.setAuthenticationMode(AuthenticationMode.OAUTH_CONSUMER_REQUEST.name());
        this.invalidationService.invalidateApplicationResources((Set)EasyMock.eq((Object)ImmutableSet.of((Object)Uri.parse((String)"http://www.example.org/gadget.xml"))), (SecurityToken)EasyMock.eq((Object)this.token));
        EasyMock.expectLastCall();
        this.replay();
        operation.execute(this.params, null, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
        this.reset();
    }

    @Test
    public void testFailTokenAuthInvalidateAppResource() throws Exception {
        String path = "/cache/invalidate";
        RestHandler operation = this.registry.getRestHandler(path, "POST");
        this.params.put("invalidationKeys", new String[]{"http://www.example.org/gadget.xml"});
        try {
            operation.execute(this.params, null, (SecurityToken)this.token, (BeanConverter)this.converter).get();
            InvalidationHandlerTest.fail((String)"Expected error");
        }
        catch (ExecutionException ee) {
            InvalidationHandlerTest.assertTrue((boolean)(ee.getCause() instanceof ProtocolException));
        }
    }

    @Test
    public void testFailInvalidateNoApp() throws Exception {
        String path = "/cache/invalidate";
        RestHandler operation = this.registry.getRestHandler(path, "POST");
        this.params.put("invalidationKeys", new String[]{"http://www.example.org/gadget.xml"});
        try {
            this.token.setAppId("");
            this.token.setAppUrl("");
            operation.execute(this.params, null, (SecurityToken)this.token, (BeanConverter)this.converter).get();
            InvalidationHandlerTest.fail((String)"Expected error");
        }
        catch (ExecutionException ee) {
            InvalidationHandlerTest.assertTrue((boolean)(ee.getCause() instanceof ProtocolException));
        }
    }
}

