/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import org.apache.shindig.auth.BasicSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.oauth.GadgetOAuthCallbackGenerator;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.oauth.OAuthCallbackState;
import org.apache.shindig.gadgets.oauth.OAuthError;
import org.apache.shindig.gadgets.oauth.OAuthFetcherConfig;
import org.apache.shindig.gadgets.oauth.OAuthGadgetContext;
import org.apache.shindig.gadgets.oauth.OAuthRequestException;
import org.apache.shindig.gadgets.oauth.OAuthResponseParams;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.uri.OAuthUriManager;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.easymock.IMocksControl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GadgetOAuthCallbackGeneratorTest {
    private static final String MAKE_REQUEST_URL = "http://renderinghost/gadgets/makeRequest";
    private static final Uri DEST_URL = Uri.parse((String)"http://www.example.com/destination");
    private IMocksControl control;
    private Processor processor;
    private LockedDomainService lockedDomainService;
    private OAuthUriManager oauthUriManager;
    private BlobCrypter stateCrypter;
    private SecurityToken securityToken;
    private Gadget gadget;
    private OAuthFetcherConfig fetcherConfig;
    private OAuthResponseParams responseParams;

    @Before
    public void setUp() throws Exception {
        this.control = EasyMock.createNiceControl();
        this.processor = (Processor)this.control.createMock(Processor.class);
        this.lockedDomainService = (LockedDomainService)this.control.createMock(LockedDomainService.class);
        this.oauthUriManager = (OAuthUriManager)this.control.createMock(OAuthUriManager.class);
        this.stateCrypter = new BasicBlobCrypter("1111111111111111111".getBytes());
        this.securityToken = new BasicSecurityToken("viewer", "viewer", "app", "container.com", "gadget", "0", "default", MAKE_REQUEST_URL, null);
        this.gadget = (Gadget)this.control.createMock(Gadget.class);
        this.fetcherConfig = new OAuthFetcherConfig(null, null, null, null, false);
        this.responseParams = new OAuthResponseParams(null, null, null);
    }

    private GadgetOAuthCallbackGenerator getGenerator() {
        return new GadgetOAuthCallbackGenerator(this.processor, this.lockedDomainService, this.oauthUriManager, this.stateCrypter);
    }

    @Test
    public void testWrongDomain() throws Exception {
        HttpRequest request = new HttpRequest(DEST_URL);
        request.setSecurityToken(this.securityToken);
        request.setOAuthArguments(new OAuthArguments());
        EasyMock.expect((Object)this.processor.process(this.eqContext(this.securityToken, request.getOAuthArguments()))).andReturn((Object)this.gadget);
        EasyMock.expect((Object)this.lockedDomainService.gadgetCanRender("renderinghost", this.gadget, "default")).andReturn((Object)false);
        this.control.replay();
        try {
            this.getGenerator().generateCallback(this.fetcherConfig, "base", request, this.responseParams);
            Assert.fail((String)"Should have thrown");
        }
        catch (OAuthRequestException e) {
            Assert.assertEquals((Object)OAuthError.UNKNOWN_PROBLEM.name(), (Object)e.getError());
        }
        this.control.verify();
    }

    @Test
    public void testBadGadget() throws Exception {
        HttpRequest request = new HttpRequest(DEST_URL);
        request.setSecurityToken(this.securityToken);
        request.setOAuthArguments(new OAuthArguments());
        EasyMock.expect((Object)this.processor.process(this.eqContext(this.securityToken, request.getOAuthArguments()))).andThrow((Throwable)new ProcessingException("doh", 400));
        this.control.replay();
        try {
            this.getGenerator().generateCallback(this.fetcherConfig, "base", request, this.responseParams);
            Assert.fail((String)"Should have thrown");
        }
        catch (OAuthRequestException e) {
            Assert.assertEquals((Object)OAuthError.UNKNOWN_PROBLEM.name(), (Object)e.getError());
        }
        this.control.verify();
    }

    @Test
    public void testGenerateUrl_schemeRelative() throws Exception {
        HttpRequest request = new HttpRequest(DEST_URL);
        request.setSecurityToken(this.securityToken);
        request.setOAuthArguments(new OAuthArguments());
        EasyMock.expect((Object)this.processor.process(this.eqContext(this.securityToken, request.getOAuthArguments()))).andReturn((Object)this.gadget);
        EasyMock.expect((Object)this.lockedDomainService.gadgetCanRender("renderinghost", this.gadget, "default")).andReturn((Object)true);
        EasyMock.expect((Object)this.oauthUriManager.makeOAuthCallbackUri("default", "renderinghost")).andReturn((Object)Uri.parse((String)"//renderinghost/final/callback"));
        this.control.replay();
        String callback = this.getGenerator().generateCallback(this.fetcherConfig, "http://base/basecallback", request, this.responseParams);
        Uri callbackUri = Uri.parse((String)callback);
        Assert.assertEquals((Object)"http", (Object)callbackUri.getScheme());
        Assert.assertEquals((Object)"base", (Object)callbackUri.getAuthority());
        Assert.assertEquals((Object)"/basecallback", (Object)callbackUri.getPath());
        OAuthCallbackState state = new OAuthCallbackState(this.stateCrypter, callbackUri.getQueryParameter("cs"));
        Assert.assertEquals((Object)"http://renderinghost/final/callback", (Object)state.getRealCallbackUrl());
        this.control.verify();
    }

    @Test
    public void testGenerateUrl_absolute() throws Exception {
        HttpRequest request = new HttpRequest(DEST_URL);
        request.setSecurityToken(this.securityToken);
        request.setOAuthArguments(new OAuthArguments());
        EasyMock.expect((Object)this.processor.process(this.eqContext(this.securityToken, request.getOAuthArguments()))).andReturn((Object)this.gadget);
        EasyMock.expect((Object)this.lockedDomainService.gadgetCanRender("renderinghost", this.gadget, "default")).andReturn((Object)true);
        EasyMock.expect((Object)this.oauthUriManager.makeOAuthCallbackUri("default", "renderinghost")).andReturn((Object)Uri.parse((String)"https://renderinghost/final/callback"));
        this.control.replay();
        String callback = this.getGenerator().generateCallback(this.fetcherConfig, "http://base/basecallback", request, this.responseParams);
        Uri callbackUri = Uri.parse((String)callback);
        Assert.assertEquals((Object)"http", (Object)callbackUri.getScheme());
        Assert.assertEquals((Object)"base", (Object)callbackUri.getAuthority());
        Assert.assertEquals((Object)"/basecallback", (Object)callbackUri.getPath());
        OAuthCallbackState state = new OAuthCallbackState(this.stateCrypter, callbackUri.getQueryParameter("cs"));
        Assert.assertEquals((Object)"https://renderinghost/final/callback", (Object)state.getRealCallbackUrl());
        this.control.verify();
    }

    @Test
    public void testGenerateUrl_otherQueryParams() throws Exception {
        HttpRequest request = new HttpRequest(DEST_URL);
        request.setSecurityToken(this.securityToken);
        request.setOAuthArguments(new OAuthArguments());
        EasyMock.expect((Object)this.processor.process(this.eqContext(this.securityToken, request.getOAuthArguments()))).andReturn((Object)this.gadget);
        EasyMock.expect((Object)this.lockedDomainService.gadgetCanRender("renderinghost", this.gadget, "default")).andReturn((Object)true);
        EasyMock.expect((Object)this.oauthUriManager.makeOAuthCallbackUri("default", "renderinghost")).andReturn((Object)Uri.parse((String)"https://renderinghost/final/callback"));
        this.control.replay();
        String callback = this.getGenerator().generateCallback(this.fetcherConfig, "http://base/basecallback?foo=bar%20baz", request, this.responseParams);
        Uri callbackUri = Uri.parse((String)callback);
        Assert.assertEquals((Object)"http", (Object)callbackUri.getScheme());
        Assert.assertEquals((Object)"base", (Object)callbackUri.getAuthority());
        Assert.assertEquals((Object)"/basecallback", (Object)callbackUri.getPath());
        Assert.assertEquals((Object)"bar baz", (Object)callbackUri.getQueryParameter("foo"));
        OAuthCallbackState state = new OAuthCallbackState(this.stateCrypter, callbackUri.getQueryParameter("cs"));
        Assert.assertEquals((Object)"https://renderinghost/final/callback", (Object)state.getRealCallbackUrl());
        this.control.verify();
    }

    @Test
    public void testGenerateUrl_noGadgetDomainCallback() throws Exception {
        HttpRequest request = new HttpRequest(DEST_URL);
        request.setSecurityToken(this.securityToken);
        request.setOAuthArguments(new OAuthArguments());
        EasyMock.expect((Object)this.processor.process(this.eqContext(this.securityToken, request.getOAuthArguments()))).andReturn((Object)this.gadget);
        EasyMock.expect((Object)this.lockedDomainService.gadgetCanRender("renderinghost", this.gadget, "default")).andReturn((Object)true);
        EasyMock.expect((Object)this.oauthUriManager.makeOAuthCallbackUri("default", "renderinghost")).andReturn(null);
        this.control.replay();
        Assert.assertNull((Object)this.getGenerator().generateCallback(this.fetcherConfig, "http://base/basecallback?foo=bar%20baz", request, this.responseParams));
        this.control.verify();
    }

    private GadgetContext eqContext(SecurityToken securityToken, OAuthArguments arguments) {
        EasyMock.reportMatcher((IArgumentMatcher)new GadgetContextMatcher(securityToken, arguments));
        return null;
    }

    private static class GadgetContextMatcher
    implements IArgumentMatcher {
        private final SecurityToken securityToken;
        private final OAuthArguments arguments;

        public GadgetContextMatcher(SecurityToken securityToken, OAuthArguments arguments) {
            this.securityToken = securityToken;
            this.arguments = arguments;
        }

        public boolean matches(Object argument) {
            if (!(argument instanceof OAuthGadgetContext)) {
                return false;
            }
            OAuthGadgetContext context = (OAuthGadgetContext)argument;
            return this.securityToken == context.getToken() && this.arguments.getBypassSpecCache() == context.getIgnoreCache();
        }

        public void appendTo(StringBuffer buffer) {
            buffer.append("GadgetContextMatcher(").append(this.securityToken).append(", ").append(this.arguments).append(')');
        }
    }
}

