/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth.testing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.oauth.OAuth;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.oauth.OAuthFetcherConfig;
import org.apache.shindig.gadgets.oauth.OAuthRequest;
import org.apache.shindig.gadgets.oauth.testing.FakeOAuthServiceProvider;

public class MakeRequestClient {
    private final SecurityToken securityToken;
    private final OAuthFetcherConfig fetcherConfig;
    private final FakeOAuthServiceProvider serviceProvider;
    private final String serviceName;
    private OAuthArguments baseArgs;
    private String oauthState;
    private String approvalUrl;
    private String receivedCallbackUrl;
    private boolean ignoreCache;
    private Map<String, String> trustedParams = Maps.newHashMap();
    private HttpFetcher nextFetcher;

    public MakeRequestClient(SecurityToken securityToken, OAuthFetcherConfig fetcherConfig, FakeOAuthServiceProvider serviceProvider, String serviceName) {
        this.securityToken = securityToken;
        this.fetcherConfig = fetcherConfig;
        this.serviceProvider = serviceProvider;
        this.serviceName = serviceName;
        this.baseArgs = this.makeNonSocialOAuthArguments();
        this.ignoreCache = false;
    }

    public void setBaseArgs(OAuthArguments baseArgs) {
        this.baseArgs = baseArgs;
    }

    public OAuthArguments getBaseArgs() {
        return this.baseArgs;
    }

    public void setIgnoreCache(boolean ignoreCache) {
        this.ignoreCache = ignoreCache;
    }

    public void setNextFetcher(HttpFetcher nextFetcher) {
        this.nextFetcher = nextFetcher;
    }

    public void setTrustedParam(String name, String value) {
        this.trustedParams.put(name, value);
    }

    private OAuthRequest createRequest() {
        FakeOAuthServiceProvider dest = this.serviceProvider;
        if (this.nextFetcher != null) {
            dest = this.nextFetcher;
        }
        if (this.trustedParams != null) {
            ArrayList trusted = Lists.newArrayList();
            for (Map.Entry<String, String> e : this.trustedParams.entrySet()) {
                trusted.add(new OAuth.Parameter(e.getKey(), e.getValue()));
            }
            return new OAuthRequest(this.fetcherConfig, (HttpFetcher)dest, (List)trusted);
        }
        return new OAuthRequest(this.fetcherConfig, (HttpFetcher)dest);
    }

    public HttpResponse sendGet(String target) throws Exception {
        HttpRequest request = new HttpRequest(Uri.parse((String)target));
        request.setOAuthArguments(this.recallState());
        OAuthRequest dest = this.createRequest();
        request.setIgnoreCache(this.ignoreCache);
        request.setSecurityToken(this.securityToken);
        HttpResponse response = dest.fetch(request);
        this.saveState(response);
        return response;
    }

    public HttpResponse sendGetWithBody(String target, String type, byte[] body) {
        HttpRequest request = new HttpRequest(Uri.parse((String)target));
        request.setOAuthArguments(this.recallState());
        OAuthRequest dest = this.createRequest();
        if (type != null) {
            request.setHeader("Content-Type", type);
        }
        request.setPostBody(body);
        request.setSecurityToken(this.securityToken);
        HttpResponse response = dest.fetch(request);
        this.saveState(response);
        return response;
    }

    public HttpResponse sendFormPost(String target, String body) throws Exception {
        HttpRequest request = new HttpRequest(Uri.parse((String)target));
        request.setOAuthArguments(this.recallState());
        OAuthRequest dest = this.createRequest();
        request.setMethod("POST");
        request.setPostBody(CharsetUtil.getUtf8Bytes((String)body));
        request.setHeader("content-type", "application/x-www-form-urlencoded");
        request.setSecurityToken(this.securityToken);
        HttpResponse response = dest.fetch(request);
        this.saveState(response);
        return response;
    }

    public HttpResponse sendRawPost(String target, String type, byte[] body) throws Exception {
        HttpRequest request = new HttpRequest(Uri.parse((String)target));
        request.setOAuthArguments(this.recallState());
        OAuthRequest dest = this.createRequest();
        request.setMethod("POST");
        if (type != null) {
            request.setHeader("Content-Type", type);
        }
        request.setPostBody(body);
        request.setSecurityToken(this.securityToken);
        HttpResponse response = dest.fetch(request);
        this.saveState(response);
        return response;
    }

    public OAuthArguments makeNonSocialOAuthArguments() {
        OAuthArguments params = new OAuthArguments();
        params.setUseToken(OAuthArguments.UseToken.ALWAYS);
        params.setServiceName(this.serviceName);
        params.setSignOwner(false);
        params.setSignViewer(false);
        return params;
    }

    public OAuthArguments makeSignedFetchArguments() {
        OAuthArguments params = new OAuthArguments();
        params.setUseToken(OAuthArguments.UseToken.NEVER);
        params.setSignOwner(true);
        params.setSignViewer(true);
        return params;
    }

    private OAuthArguments recallState() {
        OAuthArguments params = new OAuthArguments(this.baseArgs);
        params.setOrigClientState(this.oauthState);
        params.setReceivedCallbackUrl(this.receivedCallbackUrl);
        this.receivedCallbackUrl = null;
        return params;
    }

    private void saveState(HttpResponse response) {
        this.approvalUrl = null;
        if (response.getMetadata() != null) {
            if (response.getMetadata().containsKey("oauthState")) {
                this.oauthState = (String)response.getMetadata().get("oauthState");
            }
            this.approvalUrl = (String)response.getMetadata().get("oauthApprovalUrl");
        }
    }

    public void approveToken(String params) throws Exception {
        this.receivedCallbackUrl = this.serviceProvider.browserVisit(this.approvalUrl + '&' + params);
    }

    public void setReceivedCallbackUrl(String receivedCallbackUrl) {
        this.receivedCallbackUrl = receivedCallbackUrl;
    }

    public void clearState() {
        this.oauthState = null;
    }
}

