/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import org.apache.shindig.gadgets.parse.AbstractParsingTestBase;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractParserAndSerializerTest
extends AbstractParsingTestBase {
    protected GadgetHtmlParser parser;

    protected abstract GadgetHtmlParser makeParser();

    @Before
    public void setUp() throws Exception {
        this.parser = this.makeParser();
    }

    @Test
    public void docWithDoctype() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/test.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/test-expected.html");
        this.parseAndCompareBalanced(content, expected, this.parser);
    }

    @Test
    public void docNoDoctype() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/test-fulldocnodoctype.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/test-fulldocnodoctype-expected.html");
        Assert.assertNull((Object)this.parser.parseDom(content).getDoctype());
        this.parseAndCompareBalanced(content, expected, this.parser);
    }

    @Test
    public void docStartsWithHeader() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/test-startswithcomment.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/test-startswithcomment-expected.html");
        this.parseAndCompareBalanced(content, expected, this.parser);
    }

    @Test
    public void notADocument() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/test-fragment.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/test-fragment-expected.html");
        this.parseAndCompareBalanced(content, expected, this.parser);
    }

    @Test
    public void notADocument2() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/test-fragment2.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/test-fragment2-expected.html");
        this.parseAndCompareBalanced(content, expected, this.parser);
    }

    @Test
    public void noBody() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/test-headnobody.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/test-headnobody-expected.html");
        this.parseAndCompareBalanced(content, expected, this.parser);
    }

    @Test
    public void ampersand() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/test-with-ampersands.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/test-with-ampersands-expected.html");
        this.parseAndCompareBalanced(content, expected, this.parser);
    }

    @Test
    public void textBeforeScript() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/test-text-before-script.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/test-text-before-script-expected.html");
        this.parseAndCompareBalanced(content, expected, this.parser);
    }
}

