/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.nekohtml;

import org.apache.shindig.gadgets.parse.AbstractParserAndSerializerTest;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSimplifiedHtmlParser;
import org.junit.Assert;
import org.junit.Test;

public class NekoParserAndSerializeTest
extends AbstractParserAndSerializerTest {
    protected GadgetHtmlParser makeParser() {
        return new NekoSimplifiedHtmlParser(new ParseModule.DOMImplementationProvider().get());
    }

    @Test
    public void scriptPushedToBody() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-leadingscript.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-leadingscript-expected.html");
        this.parseAndCompareBalanced(content, expected, this.parser);
    }

    @Test
    public void notADocument() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-fragment.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-fragment-expected.html");
        this.parseAndCompareBalanced(content, expected, this.parser);
    }

    @Test
    public void noBody() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-headnobody.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-headnobody-expected.html");
        this.parseAndCompareBalanced(content, expected, this.parser);
    }

    @Test
    public void docNoDoctype() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/test-fulldocnodoctype.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-fulldocnodoctype-expected.html");
        Assert.assertNull((Object)this.parser.parseDom(content).getDoctype());
        this.parseAndCompareBalanced(content, expected, this.parser);
    }

    @Test
    public void textBeforeScript() throws Exception {
    }
}

