/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.junit.Assert;
import org.junit.Test;

public class ContentRewriterFeatureTestCase
extends BaseRewriterTestCase {
    @Test
    public void testContainerDefaultIncludeAll() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithoutRewrite(), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig(".*", "", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testContainerDefaultIncludeNone() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithoutRewrite(), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", ".*", "0", "embed,img,script,link,style", false, false));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testContainerDefaultExcludeOverridesInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithoutRewrite(), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig(".*", ".*", "0", "embed,img,script,link,style", false, false));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecExcludeOverridesContainerDefaultInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithRewrite("", ".*", "0", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig(".*", "", "0", "embed,img,script,link,style", false, false));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecExcludeOnlyOverridesContainerDefaultInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithRewrite(null, ".*", null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig(".*", "", "0", "embed,img,script,link,style", false, false));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecExcludeOverridesContainerDefaultExclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithRewrite(".*", "", "0", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", ".*", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testExcludeOverridesInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "test", "0", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testIncludeOnlyMatch() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "0", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://testx.test.com"));
    }

    @Test
    public void testTagRewrite() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "0", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "", "0", "embed,img,script,link,style", false, false));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("IFRAME"));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteTag("img"));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteTag("ScripT"));
    }

    @Test
    public void testOverrideTagRewrite() throws Exception {
        HashSet newTags = Sets.newHashSet((Object[])new String[]{"iframe"});
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "0", newTags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteTag("IFRAME"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("img"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("ScripT"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("link"));
    }

    @Test
    public void testExpiresTimeParse() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "12345", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "", "0", "embed,img,script,link,style", false, false));
        Assert.assertNotNull((Object)this.defaultRewriterFeature.getExpires());
        Assert.assertNotNull((Object)(this.defaultRewriterFeature.getExpires() == 12345 ? 1 : 0));
    }

    @Test
    public void testExpiresHTTPParse() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "htTp ", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "", "12345", "embed,img,script,link,style", false, false));
        Assert.assertEquals((Object)ContentRewriterFeature.EXPIRES_DEFAULT, (Object)this.defaultRewriterFeature.getExpires());
    }

    @Test
    public void testExpiresInvalidParse() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "junk", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "", "12345", "embed,img,script,link,style", false, false));
        Assert.assertNotNull((Object)this.defaultRewriterFeature.getExpires());
        Assert.assertNotNull((Object)(this.defaultRewriterFeature.getExpires() == 12345 ? 1 : 0));
    }

    @Test
    public void testSpecEmptyContainerWithExclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithRewrite(null, null, null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig(".*", "test", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.foobar.com"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecExcludeOnlyOverridesContainerWithExclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithRewrite(null, "", null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig(".*", "test", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.foobar.com"));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecEmptyDoesNotOverridesContainerDefaultNoInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithRewrite(null, null, null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "test", "0", "embed,img,script,link,style", false, false));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.foobar.com"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecIncludeOnlyOverridesContainerDefaultNoInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCase.createSpecWithRewrite(".*", null, null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "test", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.foobar.com"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSplitJsSupported() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.DefaultConfig("", "test", "0", "embed,img,script,link,style", false, true);
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isSplitJsEnabled());
    }

    @Test
    public void testSplitJsNotSupported() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.DefaultConfig("", "test", "0", "embed,img,script,link,style", false, false);
        Assert.assertFalse((boolean)this.defaultRewriterFeature.isSplitJsEnabled());
    }
}

