/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.DomWalkerTestBase;
import org.apache.shindig.gadgets.rewrite.StyleAdjacencyVisitor;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class StyleAdjacencyVisitorTest
extends DomWalkerTestBase {
    @Test
    public void visitStyle() throws Exception {
        Element node = this.elem("style", new String[0]);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_TREE, (Object)this.visit(node));
    }

    @Test
    public void visitLinkWithRel() throws Exception {
        Element node = this.elem("link", "rel", "stylesheet");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_TREE, (Object)this.visit(node));
    }

    @Test
    public void visitLinkWithType() throws Exception {
        Element node = this.elem("link", "type", "text/css");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_TREE, (Object)this.visit(node));
    }

    @Test
    public void visitStyleCaseInsensitive() throws Exception {
        Element node = this.elem("sTYlE", new String[0]);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_TREE, (Object)this.visit(node));
    }

    @Test
    public void visitLinkCaseInsensitive() throws Exception {
        Element node = this.elem("lINK", "REL", "stYlEsheet");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_TREE, (Object)this.visit(node));
        node = this.elem("LINk", "tyPe", "text/csS");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_TREE, (Object)this.visit(node));
    }

    @Test
    public void visitStyleWithAttribs() throws Exception {
        Element node = this.elem("style", "foo", "bar");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_TREE, (Object)this.visit(node));
    }

    @Test
    public void bypassUnknownElement() throws Exception {
        Element node = this.elem("div", new String[0]);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.visit(node));
    }

    @Test
    public void bypassLinkWithoutAttribs() throws Exception {
        Element node = this.elem("link", new String[0]);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.visit(node));
    }

    @Test
    public void bypassLinkWithWrongAttribs() throws Exception {
        Element node = this.elem("link", "type", "somecss");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.visit(node));
    }

    @Test
    public void bypassText() throws Exception {
        Text node = this.doc.createTextNode("text");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.visit(node));
    }

    @Test
    public void bypassComment() throws Exception {
        Comment node = this.doc.createComment("comment");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.visit(node));
    }

    @Test
    public void reshuffleSingleNodeInHead() throws Exception {
        Element style = this.elem("style", new String[0]);
        Element html = this.htmlDoc(new Node[]{this.elem("script", new String[0]), this.doc.createTextNode("foo"), style, this.doc.createComment("comment")}, new Node[0]);
        Assert.assertTrue((boolean)this.revisit(style));
        Assert.assertEquals((long)2L, (long)html.getChildNodes().getLength());
        Node head = html.getFirstChild();
        Assert.assertEquals((Object)"head", (Object)head.getNodeName());
        Node body = html.getLastChild();
        Assert.assertEquals((Object)"body", (Object)body.getNodeName());
        Assert.assertEquals((long)4L, (long)head.getChildNodes().getLength());
        Assert.assertSame((Object)style, (Object)head.getChildNodes().item(0));
    }

    @Test
    public void reshuffleSingleNodeFromBody() throws Exception {
        Element style = this.elem("style", new String[0]);
        Element html = this.htmlDoc(new Node[]{this.elem("foo", new String[0])}, this.elem("script", new String[0]), this.doc.createTextNode("foo"), style, this.doc.createComment("comment"));
        Assert.assertTrue((boolean)this.revisit(style));
        Assert.assertEquals((long)2L, (long)html.getChildNodes().getLength());
        Node head = html.getFirstChild();
        Assert.assertEquals((Object)"head", (Object)head.getNodeName());
        Node body = html.getLastChild();
        Assert.assertEquals((Object)"body", (Object)body.getNodeName());
        Assert.assertEquals((long)2L, (long)head.getChildNodes().getLength());
        Assert.assertSame((Object)style, (Object)head.getChildNodes().item(0));
        Assert.assertEquals((long)3L, (long)body.getChildNodes().getLength());
    }

    @Test
    public void reshuffleMultipleStyleNodesWithNoChildernInHead() throws Exception {
        Element style1 = this.elem("style", new String[0]);
        Element style2 = this.elem("style", new String[0]);
        Element style3 = this.elem("style", new String[0]);
        Element html = this.htmlDoc(new Node[0], this.elem("script", new String[0]), style1, this.elem("foo", new String[0]), this.doc.createTextNode("text1"), style2, this.doc.createComment("comment"), this.elem("div", new String[0]), style3);
        Assert.assertTrue((boolean)this.revisit(style1, style2, style3));
        Assert.assertEquals((long)2L, (long)html.getChildNodes().getLength());
        Node head = html.getFirstChild();
        Assert.assertEquals((Object)"head", (Object)head.getNodeName());
        Node body = html.getLastChild();
        Assert.assertEquals((Object)"body", (Object)body.getNodeName());
        Assert.assertEquals((long)3L, (long)head.getChildNodes().getLength());
        Assert.assertSame((Object)style1, (Object)head.getChildNodes().item(0));
        Assert.assertSame((Object)style2, (Object)head.getChildNodes().item(1));
        Assert.assertSame((Object)style3, (Object)head.getChildNodes().item(2));
        Assert.assertEquals((long)5L, (long)body.getChildNodes().getLength());
    }

    @Test
    public void reshuffleMultipleStyleNodes() throws Exception {
        Element style1 = this.elem("style", new String[0]);
        Element style2 = this.elem("style", new String[0]);
        Element style3 = this.elem("style", new String[0]);
        Element html = this.htmlDoc(new Node[]{this.elem("script", new String[0]), style1, this.elem("foo", new String[0])}, this.doc.createTextNode("text1"), style2, this.doc.createComment("comment"), this.elem("div", new String[0]), style3);
        Assert.assertTrue((boolean)this.revisit(style1, style2, style3));
        Assert.assertEquals((long)2L, (long)html.getChildNodes().getLength());
        Node head = html.getFirstChild();
        Assert.assertEquals((Object)"head", (Object)head.getNodeName());
        Node body = html.getLastChild();
        Assert.assertEquals((Object)"body", (Object)body.getNodeName());
        Assert.assertEquals((long)5L, (long)head.getChildNodes().getLength());
        Assert.assertSame((Object)style1, (Object)head.getChildNodes().item(0));
        Assert.assertSame((Object)style2, (Object)head.getChildNodes().item(1));
        Assert.assertSame((Object)style3, (Object)head.getChildNodes().item(2));
        Assert.assertEquals((long)3L, (long)body.getChildNodes().getLength());
    }

    @Test
    public void reshuffleMultipleLinkNodes() throws Exception {
        Element link1 = this.elem("link", "rel", "stylesheet");
        Element link2 = this.elem("link", "rel", "stylesheet");
        Element link3 = this.elem("link", "rel", "stylesheet");
        Element html = this.htmlDoc(new Node[]{link1, this.elem("script", new String[0]), this.elem("foo", new String[0])}, this.doc.createTextNode("text1"), link2, this.doc.createComment("comment"), this.elem("div", new String[0]), link3);
        Assert.assertTrue((boolean)this.revisit(link1, link2, link3));
        Assert.assertEquals((long)2L, (long)html.getChildNodes().getLength());
        Node head = html.getFirstChild();
        Assert.assertEquals((Object)"head", (Object)head.getNodeName());
        Node body = html.getLastChild();
        Assert.assertEquals((Object)"body", (Object)body.getNodeName());
        Assert.assertEquals((long)5L, (long)head.getChildNodes().getLength());
        Assert.assertSame((Object)link1, (Object)head.getChildNodes().item(0));
        Assert.assertSame((Object)link2, (Object)head.getChildNodes().item(1));
        Assert.assertSame((Object)link3, (Object)head.getChildNodes().item(2));
        Assert.assertEquals((long)3L, (long)body.getChildNodes().getLength());
    }

    @Test
    public void reshuffleMultiMatchedNodes() throws Exception {
        Element style1 = this.elem("style", new String[0]);
        Element style2 = this.elem("style", new String[0]);
        Element link1 = this.elem("link", "rel", "stylesheet");
        Element link2 = this.elem("link", "type", "text/css");
        Element div = this.elem("div", new String[0]);
        div.appendChild(style2);
        Element html = this.htmlDoc(new Node[]{this.elem("base", new String[0]), this.elem("script", new String[0]), this.elem("script", new String[0]), style1, this.doc.createComment("comment"), link1}, this.elem("div", new String[0]), div, link2, this.doc.createTextNode("text"));
        Assert.assertTrue((boolean)this.revisit(style1, link1, style2, link2));
        Assert.assertEquals((long)2L, (long)html.getChildNodes().getLength());
        Node head = html.getFirstChild();
        Assert.assertEquals((Object)"head", (Object)head.getNodeName());
        Node body = html.getLastChild();
        Assert.assertEquals((Object)"body", (Object)body.getNodeName());
        Assert.assertEquals((long)8L, (long)head.getChildNodes().getLength());
        Assert.assertSame((Object)style1, (Object)head.getChildNodes().item(0));
        Assert.assertSame((Object)link1, (Object)head.getChildNodes().item(1));
        Assert.assertSame((Object)style2, (Object)head.getChildNodes().item(2));
        Assert.assertSame((Object)link2, (Object)head.getChildNodes().item(3));
        Assert.assertEquals((long)0L, (long)div.getChildNodes().getLength());
        Assert.assertEquals((long)3L, (long)body.getChildNodes().getLength());
    }

    @Test
    public void avoidReshufflingInHeadlessDocument() throws Exception {
        Element style = this.elem("style", new String[0]);
        Element html = this.elem("html", new String[0]);
        Element body = this.elem("body", new String[0]);
        body.appendChild(style);
        html.appendChild(body);
        this.doc.appendChild(html);
        Assert.assertFalse((boolean)this.revisit(style));
        Assert.assertEquals((long)1L, (long)html.getChildNodes().getLength());
        Assert.assertSame((Object)body, (Object)html.getFirstChild());
    }

    @Test
    public void singleStyleNodeInHead() throws Exception {
        Element style = this.elem("style", "type", "text/css");
        Element head = this.elem("head", new String[0]);
        head.appendChild(style);
        Element html = this.elem("html", new String[0]);
        html.appendChild(head);
        html.appendChild(this.elem("body", new String[0]));
        this.doc.appendChild(html);
        Assert.assertTrue((boolean)this.revisit(style));
        Assert.assertEquals((long)2L, (long)html.getChildNodes().getLength());
        Assert.assertSame((Object)head, (Object)html.getFirstChild());
    }

    private DomWalker.Visitor.VisitStatus visit(Node node) throws Exception {
        return new StyleAdjacencyVisitor().visit(this.gadget(), node);
    }

    private boolean revisit(Node ... nodes) throws Exception {
        return new StyleAdjacencyVisitor().revisit(this.gadget(), (List)ImmutableList.copyOf((Object[])nodes));
    }
}

