/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.AbstractContainerConfig;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.DefaultGuiceModule;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.oauth.OAuthModule;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.caja.CajaHtmlParser;
import org.apache.shindig.gadgets.parse.caja.CajaHtmlSerializer;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.CssResponseRewriter;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.DomWalkerTestBase;
import org.apache.shindig.gadgets.rewrite.StyleTagProxyEmbeddedUrlsVisitor;
import org.apache.shindig.gadgets.uri.DefaultProxyUriManager;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class StyleTagProxyEmbeddedUrlsVisitorTest
extends DomWalkerTestBase {
    protected static final String MOCK_CONTAINER = "mock";
    private Injector injector;
    private CajaHtmlParser htmlParser;
    private CajaHtmlSerializer serializer;
    private ProxyUriManager proxyUriManager;
    private static final String ORIGINAL = "<html><head><style>@import url(/1.css);P {color:blue;}P {color:red;}A {background: url(/2.jpg);}</style></head><body><a href=\"hello\">Hello</a></body></html>";
    private static final String EXPECTED = "<html><head><style>@import url('//localhost:8080/gadgets/proxy?container=default&gadget=http%3A%2F%2F1.com%2F&debug=0&nocache=0&url=http%3A%2F%2F1.com%2F1.css');\nP {color:blue;}P {color:red;}A {background: url('//localhost:8080/gadgets/proxy?container=default&gadget=http%3A%2F%2F1.com%2F&debug=0&nocache=0&url=http%3A%2F%2F1.com%2F2.jpg');}</style></head><body><a href=\"hello\">Hello</a>\n</body></html>";

    @Before
    public void setUp() {
        super.setUp();
        this.injector = Guice.createInjector((Module[])new Module[]{new PropertiesModule(), new DefaultGuiceModule(), new OAuthModule()});
        ParseModule.DOMImplementationProvider domImpl = new ParseModule.DOMImplementationProvider();
        this.htmlParser = new CajaHtmlParser(domImpl.get());
        this.serializer = new CajaHtmlSerializer();
        FakeContainerConfig config = new FakeContainerConfig((ContainerConfig)this.injector.getInstance(ContainerConfig.class));
        this.proxyUriManager = new DefaultProxyUriManager((ContainerConfig)config, null);
    }

    @Test
    public void testImportsAndBackgroundUrlsInStyleTagDefaultContainer() throws Exception {
        this.testImportsAndBackgroundUrlsInStyleTag(ORIGINAL, EXPECTED, "default");
    }

    @Test
    public void testImportsAndBackgroundUrlsInStyleTagMockContainer() throws Exception {
        this.testImportsAndBackgroundUrlsInStyleTag(ORIGINAL, EXPECTED.replace("localhost:8080/gadgets/proxy?container=default", "www.mock.com/gadgets/proxy?container=mock"), MOCK_CONTAINER);
    }

    private void testImportsAndBackgroundUrlsInStyleTag(String html, String expected, String container) throws Exception {
        Document doc = this.htmlParser.parseDom(html);
        ContentRewriterFeature.Config config = (ContentRewriterFeature.Config)this.injector.getInstance(ContentRewriterFeature.DefaultConfig.class);
        EasyMock.replay((Object[])new Object[0]);
        StyleTagProxyEmbeddedUrlsVisitor visitor = new StyleTagProxyEmbeddedUrlsVisitor(config, this.proxyUriManager, (CssResponseRewriter)this.injector.getInstance(CssResponseRewriter.class));
        Gadget gadget = DomWalker.makeGadget((HttpRequest)new HttpRequest(Uri.parse((String)"http://1.com/")).setContainer(container));
        NodeList list = doc.getElementsByTagName("style");
        visitor.revisit(gadget, (List)ImmutableList.of((Object)list.item(0)));
        EasyMock.verify((Object[])new Object[0]);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)this.serializer.serialize(doc)));
    }

    private static class FakeContainerConfig
    extends AbstractContainerConfig {
        private Map<String, Map<String, Object>> containers = new HashMap<String, Map<String, Object>>();

        private FakeContainerConfig(ContainerConfig defaultContainerConfig) {
            this.containers.put("default", defaultContainerConfig.getProperties("default"));
            this.containers.put(StyleTagProxyEmbeddedUrlsVisitorTest.MOCK_CONTAINER, (Map<String, Object>)ImmutableMap.builder().put((Object)"gadgets.uri.proxy.host", (Object)"www.mock.com").build());
        }

        public Object getProperty(String container, String name) {
            Map<String, Object> data = this.containers.get(container);
            if (!data.containsKey(name)) {
                data = this.containers.get("default");
            }
            return data.get(name);
        }
    }
}

