/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.image.BaseOptimizerTest;
import org.apache.shindig.gadgets.rewrite.image.JPEGOptimizer;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;
import org.junit.Test;

public class JPEGOptimizerTest
extends BaseOptimizerTest {
    @Test
    public void testSmallJPEGToPNG() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/small.jpg", "image/jpeg");
        HttpResponse rewritten = this.rewrite(resp);
        JPEGOptimizerTest.assertEquals((Object)"image/png", (Object)rewritten.getHeader("Content-Type"));
        JPEGOptimizerTest.assertTrue((rewritten.getContentLength() * 100 / resp.getContentLength() < 70 ? 1 : 0) != 0);
    }

    @Test
    public void testLargeJPEG() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/large.jpg", "image/jpeg");
        HttpResponse rewritten = this.rewrite(resp);
        JPEGOptimizerTest.assertEquals((Object)"image/jpeg", (Object)resp.getHeader("Content-Type"));
        JPEGOptimizerTest.assertTrue((rewritten.getContentLength() <= resp.getContentLength() ? 1 : 0) != 0);
    }

    @Test(expected=Throwable.class)
    public void testBadImage() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/bad.jpg", "image/jpeg");
        this.rewrite(resp);
    }

    @Test(expected=Throwable.class)
    public void xtestBadICC1() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/badicc.jpg", "image/jpeg");
        this.rewrite(resp);
    }

    @Test(expected=Throwable.class)
    public void testBadICC2() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/badicc2.jpg", "image/jpeg");
        this.rewrite(resp);
    }

    @Test(expected=Throwable.class)
    public void testBadICC3() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/badicc3.jpg", "image/jpeg");
        this.rewrite(resp);
    }

    @Test
    public void testBadICC4() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/badicc4.jpg", "image/jpeg");
        try {
            this.rewrite(resp);
            JPEGOptimizerTest.fail((String)"Should have failed with OutOfMemory exception");
        }
        catch (OutOfMemoryError oome) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testBadICC5() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/2ndjpgbad.jpg", "image/jpeg");
        this.rewrite(resp);
    }

    HttpResponse rewrite(HttpResponse original) throws IOException, ImageReadException {
        HttpResponseBuilder builder = new HttpResponseBuilder(original);
        new JPEGOptimizer(new OptimizerConfig(), builder).rewrite(JPEGOptimizer.readJpeg((InputStream)original.getResponse()));
        return builder.create();
    }
}

