/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.image.BaseOptimizerTest;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;
import org.apache.shindig.gadgets.rewrite.image.PNGOptimizer;
import org.junit.Test;

public class PNGOptimizerTest
extends BaseOptimizerTest {
    @Test
    public void testRewriteInefficientPNG() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/inefficient.png", "image/png");
        HttpResponse httpResponse = this.rewrite(resp);
        PNGOptimizerTest.assertTrue((httpResponse.getContentLength() <= resp.getContentLength() ? 1 : 0) != 0);
        PNGOptimizerTest.assertEquals((Object)"image/png", (Object)httpResponse.getHeader("Content-Type"));
    }

    @Test
    public void testStripAlpha() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/rgbawithnoalpha.png", "image/png");
        HttpResponse httpResponse = this.rewrite(resp);
        PNGOptimizerTest.assertTrue((httpResponse.getContentLength() <= resp.getContentLength() ? 1 : 0) != 0);
        PNGOptimizerTest.assertEquals((Object)"image/png", (Object)httpResponse.getHeader("Content-Type"));
    }

    @Test(expected=IOException.class)
    public void testEvil() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/evil.png", "image/png");
        this.rewrite(resp);
        PNGOptimizerTest.fail((String)"Should have failed to read image");
    }

    HttpResponse rewrite(HttpResponse original) throws IOException, ImageReadException {
        HttpResponseBuilder builder = new HttpResponseBuilder(original);
        new PNGOptimizer(new OptimizerConfig(), builder).rewrite(Sanselan.getBufferedImage((InputStream)original.getResponse()));
        return builder.create();
    }
}

