/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.servlet.FakeIframeUriManager;
import org.apache.shindig.gadgets.servlet.FakeProcessor;
import org.apache.shindig.gadgets.servlet.GadgetsHandlerApi;
import org.apache.shindig.gadgets.servlet.GadgetsHandlerService;
import org.apache.shindig.gadgets.uri.IframeUriManager;
import org.apache.shindig.protocol.conversion.BeanDelegator;
import org.apache.shindig.protocol.conversion.BeanFilter;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetHandlerServiceTest
extends EasyMockTestCase {
    private static final String TOKEN = "<token data>";
    private static final String OWNER = "<owner>";
    private static final String VIEWER = "<viewer>";
    private static final String CONTAINER = "container";
    private final BeanDelegator delegator = new BeanDelegator(GadgetsHandlerService.apiClasses, GadgetsHandlerService.enumConversionMap);
    private final FakeProcessor processor = new FakeProcessor();
    private final FakeIframeUriManager urlGenerator = new FakeIframeUriManager();
    private FakeSecurityTokenCodec tokenCodec;
    private GadgetsHandlerService gadgetHandler;

    @Before
    public void setUp() {
        this.tokenCodec = new FakeSecurityTokenCodec();
        this.gadgetHandler = new GadgetsHandlerService((Processor)this.processor, (IframeUriManager)this.urlGenerator, (SecurityTokenCodec)this.tokenCodec, new BeanFilter());
    }

    @Test
    public void testHandlerDataDelegation() throws Exception {
        this.delegator.validate();
    }

    @Test
    public void testGetMetadata() throws Exception {
        GadgetsHandlerApi.MetadataRequest request = this.createMetadataRequest(FakeProcessor.SPEC_URL, CONTAINER, "view", this.createTokenData(null, null), (List<String>)ImmutableList.of((Object)"*"));
        this.replay();
        GadgetsHandlerApi.MetadataResponse response = this.gadgetHandler.getMetadata(request);
        GadgetHandlerServiceTest.assertEquals((Object)FakeIframeUriManager.DEFAULT_IFRAME_URI.toString(), (Object)response.getIframeUrl());
        GadgetHandlerServiceTest.assertEquals((long)1L, (long)response.getViews().size());
        GadgetHandlerServiceTest.assertTrue((boolean)((GadgetsHandlerApi.View)response.getViews().get("default")).getContent().contains("Hello, world"));
        GadgetHandlerServiceTest.assertEquals((Object)"JSON-TEST", (Object)response.getModulePrefs().getTitle());
        GadgetHandlerServiceTest.assertEquals((Object)"http://example.org/foo", (Object)((GadgetsHandlerApi.LinkSpec)response.getModulePrefs().getLinks().get("rel")).getHref().toString());
        GadgetHandlerServiceTest.assertEquals((Object)"rel", (Object)((GadgetsHandlerApi.LinkSpec)response.getModulePrefs().getLinks().get("rel")).getRel());
        GadgetHandlerServiceTest.assertEquals((long)1L, (long)response.getUserPrefs().size());
        GadgetHandlerServiceTest.assertEquals((Object)"up_one", (Object)((GadgetsHandlerApi.UserPref)response.getUserPrefs().get("up_one")).getDisplayName());
        GadgetHandlerServiceTest.assertEquals((long)4L, (long)((GadgetsHandlerApi.UserPref)response.getUserPrefs().get("up_one")).getEnumValues().size());
        this.verify();
    }

    @Test
    public void testGetMetadataOnlyView() throws Exception {
        GadgetsHandlerApi.MetadataRequest request = this.createMetadataRequest(FakeProcessor.SPEC_URL, CONTAINER, null, this.createTokenData(null, null), (List<String>)ImmutableList.of((Object)"views.*"));
        this.replay();
        GadgetsHandlerApi.MetadataResponse response = this.gadgetHandler.getMetadata(request);
        GadgetHandlerServiceTest.assertNull((Object)response.getIframeUrl());
        GadgetHandlerServiceTest.assertNull((Object)response.getUserPrefs());
        GadgetHandlerServiceTest.assertNull((Object)response.getModulePrefs());
        GadgetHandlerServiceTest.assertEquals((Object)FakeProcessor.SPEC_URL, (Object)response.getUrl());
        GadgetHandlerServiceTest.assertEquals((long)1L, (long)response.getViews().size());
        GadgetHandlerServiceTest.assertTrue((boolean)((GadgetsHandlerApi.View)response.getViews().get("default")).getContent().contains("Hello, world"));
        this.verify();
    }

    @Test(expected=ProcessingException.class)
    public void testGetMetadataNoContainer() throws Exception {
        GadgetsHandlerApi.MetadataRequest request = this.createMetadataRequest(FakeProcessor.SPEC_URL, null, null, this.createTokenData(null, null), (List<String>)ImmutableList.of((Object)"*"));
        this.replay();
        GadgetsHandlerApi.MetadataResponse response = this.gadgetHandler.getMetadata(request);
    }

    @Test(expected=ProcessingException.class)
    public void testGetMetadataNoUrl() throws Exception {
        GadgetsHandlerApi.MetadataRequest request = this.createMetadataRequest(null, CONTAINER, null, this.createTokenData(null, null), (List<String>)ImmutableList.of((Object)"*"));
        this.replay();
        GadgetsHandlerApi.MetadataResponse response = this.gadgetHandler.getMetadata(request);
    }

    @Test(expected=ProcessingException.class)
    public void testGetMetadataNoFields() throws Exception {
        GadgetsHandlerApi.MetadataRequest request = this.createMetadataRequest(FakeProcessor.SPEC_URL, CONTAINER, null, this.createTokenData(null, null), null);
        this.replay();
        GadgetsHandlerApi.MetadataResponse response = this.gadgetHandler.getMetadata(request);
    }

    @Test(expected=ProcessingException.class)
    public void testGetMetadataBadGadget() throws Exception {
        GadgetsHandlerApi.MetadataRequest request = this.createMetadataRequest(Uri.parse((String)"unknown"), CONTAINER, null, this.createTokenData(null, null), null);
        this.replay();
        GadgetsHandlerApi.MetadataResponse response = this.gadgetHandler.getMetadata(request);
    }

    @Test
    public void testGetMetadataNoToken() throws Exception {
        GadgetsHandlerApi.MetadataRequest request = this.createMetadataRequest(FakeProcessor.SPEC_URL, CONTAINER, "view", null, (List<String>)ImmutableList.of((Object)"*"));
        this.replay();
        GadgetsHandlerApi.MetadataResponse response = this.gadgetHandler.getMetadata(request);
        GadgetHandlerServiceTest.assertEquals((Object)FakeIframeUriManager.DEFAULT_IFRAME_URI.toString(), (Object)response.getIframeUrl());
        this.verify();
    }

    @Test
    public void testGetToken() throws Exception {
        GadgetsHandlerApi.TokenRequest request = this.createTokenRequest(FakeProcessor.SPEC_URL, CONTAINER, this.createTokenData(OWNER, VIEWER), (List<String>)ImmutableList.of((Object)"*"));
        this.replay();
        this.tokenCodec.encodedToken = TOKEN;
        GadgetsHandlerApi.TokenResponse response = this.gadgetHandler.getToken(request);
        GadgetHandlerServiceTest.assertEquals((Object)TOKEN, (Object)response.getToken());
        GadgetHandlerServiceTest.assertEquals((Object)OWNER, (Object)this.tokenCodec.tokenData.getOwnerId());
        GadgetHandlerServiceTest.assertEquals((Object)VIEWER, (Object)this.tokenCodec.tokenData.getViewerId());
        GadgetHandlerServiceTest.assertEquals((Object)CONTAINER, (Object)this.tokenCodec.tokenData.getContainer());
        this.verify();
    }

    @Test(expected=ProcessingException.class)
    public void testGetTokenNoContainer() throws Exception {
        GadgetsHandlerApi.TokenRequest request = this.createTokenRequest(FakeProcessor.SPEC_URL, null, this.createTokenData(OWNER, VIEWER), (List<String>)ImmutableList.of((Object)"*"));
        this.replay();
        GadgetsHandlerApi.TokenResponse response = this.gadgetHandler.getToken(request);
    }

    @Test(expected=ProcessingException.class)
    public void testGetTokenNoUrl() throws Exception {
        GadgetsHandlerApi.TokenRequest request = this.createTokenRequest(null, CONTAINER, this.createTokenData(OWNER, VIEWER), (List<String>)ImmutableList.of((Object)"*"));
        this.replay();
        GadgetsHandlerApi.TokenResponse response = this.gadgetHandler.getToken(request);
    }

    @Test(expected=ProcessingException.class)
    public void testGetTokenNoFields() throws Exception {
        GadgetsHandlerApi.TokenRequest request = this.createTokenRequest(FakeProcessor.SPEC_URL, CONTAINER, this.createTokenData(OWNER, VIEWER), null);
        this.replay();
        GadgetsHandlerApi.TokenResponse response = this.gadgetHandler.getToken(request);
    }

    @Test(expected=SecurityTokenException.class)
    public void testGetTokenException() throws Exception {
        GadgetsHandlerApi.TokenRequest request = this.createTokenRequest(FakeProcessor.SPEC_URL, CONTAINER, this.createTokenData(OWNER, VIEWER), (List<String>)ImmutableList.of((Object)"*"));
        this.replay();
        this.tokenCodec.exc = new SecurityTokenException("bad data");
        GadgetsHandlerApi.TokenResponse response = this.gadgetHandler.getToken(request);
    }

    @Test
    public void testGetTokenNoToken() throws Exception {
        GadgetsHandlerApi.TokenRequest request = this.createTokenRequest(FakeProcessor.SPEC_URL, CONTAINER, null, (List<String>)ImmutableList.of((Object)"*"));
        this.replay();
        this.tokenCodec.encodedToken = TOKEN;
        GadgetsHandlerApi.TokenResponse response = this.gadgetHandler.getToken(request);
        GadgetHandlerServiceTest.assertEquals((Object)TOKEN, (Object)response.getToken());
        GadgetHandlerServiceTest.assertNull((String)CONTAINER, (Object)this.tokenCodec.tokenData);
        this.verify();
    }

    private GadgetsHandlerApi.TokenData createTokenData(String ownerId, String viewerId) {
        GadgetsHandlerApi.TokenData token = (GadgetsHandlerApi.TokenData)this.mock(GadgetsHandlerApi.TokenData.class);
        if (ownerId != null) {
            EasyMock.expect((Object)token.getOwnerId()).andReturn((Object)ownerId).once();
        }
        if (viewerId != null) {
            EasyMock.expect((Object)token.getViewerId()).andReturn((Object)viewerId).once();
        }
        return token;
    }

    private GadgetsHandlerApi.MetadataRequest createMetadataRequest(Uri url, String container, String view, GadgetsHandlerApi.TokenData token, List<String> fields) {
        GadgetsHandlerApi.MetadataRequest request = (GadgetsHandlerApi.MetadataRequest)this.mock(GadgetsHandlerApi.MetadataRequest.class);
        EasyMock.expect((Object)request.getFields()).andReturn(fields).anyTimes();
        EasyMock.expect((Object)request.getView()).andReturn((Object)view).once();
        EasyMock.expect((Object)request.getUrl()).andReturn((Object)url).anyTimes();
        EasyMock.expect((Object)request.getContainer()).andReturn((Object)container).anyTimes();
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token).once();
        return request;
    }

    private GadgetsHandlerApi.TokenRequest createTokenRequest(Uri url, String container, GadgetsHandlerApi.TokenData token, List<String> fields) {
        GadgetsHandlerApi.TokenRequest request = (GadgetsHandlerApi.TokenRequest)this.mock(GadgetsHandlerApi.TokenRequest.class);
        EasyMock.expect((Object)request.getFields()).andReturn(fields).anyTimes();
        EasyMock.expect((Object)request.getUrl()).andReturn((Object)url).anyTimes();
        EasyMock.expect((Object)request.getContainer()).andReturn((Object)container).anyTimes();
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token).once();
        return request;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FakeSecurityTokenCodec
    implements SecurityTokenCodec {
        public SecurityTokenException exc = null;
        public SecurityToken tokenData = null;
        public String encodedToken = null;

        private FakeSecurityTokenCodec() {
        }

        public String encodeToken(SecurityToken token) throws SecurityTokenException {
            this.tokenData = token;
            if (this.exc != null) {
                throw this.exc;
            }
            return this.encodedToken;
        }

        public SecurityToken createToken(Map<String, String> tokenParameters) throws SecurityTokenException {
            if (this.exc != null) {
                throw this.exc;
            }
            return this.tokenData;
        }
    }
}

