/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.gadgets.templates.DefaultTemplateProcessor;
import org.apache.shindig.gadgets.templates.TagRegistry;
import org.apache.shindig.gadgets.templates.TemplateContext;
import org.apache.shindig.gadgets.templates.TemplateLibrary;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.TemplateResource;
import org.apache.shindig.gadgets.templates.XmlTemplateLibrary;
import org.apache.shindig.gadgets.templates.tags.TagHandler;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlTemplateLibraryTest {
    public static final String LIB_MARKUP = "<Templates xmlns:my='#my'>  <Namespace prefix='my' url='#my'/>  <JavaScript>libscript</JavaScript>  <JavaScript>libscript2</JavaScript>  <Style>libstyle</Style>  <Style>libstyle2</Style>  <Template tag='my:Flat'>Flat tag</Template>  <TemplateDef tag='my:Def'>    <Template>Def tag</Template>    <JavaScript>tagscript</JavaScript>    <Style>tagstyle</Style>  </TemplateDef></Templates>";
    private static TemplateLibrary lib;
    private static Element doc;

    @BeforeClass
    public static void createDefaultLibrary() throws Exception {
        doc = XmlUtil.parse((String)LIB_MARKUP);
        lib = new XmlTemplateLibrary(Uri.parse((String)"http://example.com/my"), doc, LIB_MARKUP);
    }

    @Test
    public void testTemplateElement() throws Exception {
        TagRegistry registry = lib.getTagRegistry();
        Assert.assertNotNull((Object)registry.getHandlerFor(new TagRegistry.NSName("#my", "Flat")));
    }

    @Test
    public void testTemplateDefElement() throws Exception {
        TagRegistry registry = lib.getTagRegistry();
        Assert.assertNotNull((Object)registry.getHandlerFor(new TagRegistry.NSName("#my", "Def")));
    }

    @Test
    public void testMissingElements() {
        TagRegistry registry = lib.getTagRegistry();
        Assert.assertNull((Object)registry.getHandlerFor(new TagRegistry.NSName("#my", "Foo")));
        Assert.assertNull((Object)registry.getHandlerFor(new TagRegistry.NSName("my", "Flat")));
    }

    @Test
    public void testAddedResources() {
        final TemplateContext context = new TemplateContext(null, (Map)ImmutableMap.of());
        DefaultTemplateProcessor processor = new DefaultTemplateProcessor(Expressions.forTesting()){

            public TemplateContext getTemplateContext() {
                return context;
            }
        };
        TagHandler handlerWithResources = lib.getTagRegistry().getHandlerFor(new TagRegistry.NSName("#my", "Def"));
        TagHandler handlerWithNoResources = lib.getTagRegistry().getHandlerFor(new TagRegistry.NSName("#my", "Flat"));
        DocumentFragment result = doc.getOwnerDocument().createDocumentFragment();
        Element tag = doc.getOwnerDocument().createElement("test");
        handlerWithNoResources.process((Node)result, tag, (TemplateProcessor)processor);
        Assert.assertEquals((Object)"<STYLE>libstyle\nlibstyle2</STYLE><JAVASCRIPT>libscript\nlibscript2</JAVASCRIPT>", (Object)this.serializeResources(context));
        handlerWithResources.process((Node)result, tag, (TemplateProcessor)processor);
        Assert.assertEquals((Object)"<STYLE>libstyle\nlibstyle2</STYLE><JAVASCRIPT>libscript\nlibscript2</JAVASCRIPT><JAVASCRIPT>tagscript</JAVASCRIPT><STYLE>tagstyle</STYLE>", (Object)this.serializeResources(context));
        handlerWithResources.process((Node)result, tag, (TemplateProcessor)processor);
        Assert.assertEquals((Object)"<STYLE>libstyle\nlibstyle2</STYLE><JAVASCRIPT>libscript\nlibscript2</JAVASCRIPT><JAVASCRIPT>tagscript</JAVASCRIPT><STYLE>tagstyle</STYLE>", (Object)this.serializeResources(context));
    }

    private String serializeResources(TemplateContext context) {
        StringBuilder builder = new StringBuilder();
        for (TemplateResource resource : context.getResources()) {
            builder.append(resource);
        }
        return builder.toString();
    }

    @Test
    public void testSerialize() {
        Assert.assertEquals((Object)LIB_MARKUP, (Object)lib.serialize());
    }
}

