/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates.tags;

import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.tags.AbstractTagHandler;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AbstractTagHandlerTest {
    private DOMImplementation documentProvider;
    private Document document;
    private AbstractTagHandler handler;
    private TemplateProcessor templateProcessor;

    @Before
    public void setUp() throws Exception {
        this.documentProvider = new ParseModule.DOMImplementationProvider().get();
        this.document = this.documentProvider.createDocument(null, null, null);
        this.handler = new AbstractTagHandler(null, null){

            public void process(Node result, Element tag, TemplateProcessor processor) {
            }
        };
        this.templateProcessor = (TemplateProcessor)EasyMock.createMock(TemplateProcessor.class);
    }

    @Test
    public void getValueFromTag() {
        Element element = this.document.createElement("test");
        element.setAttribute("key", "expression");
        EasyMock.expect((Object)this.templateProcessor.evaluate((String)EasyMock.eq((Object)"expression"), (Class)EasyMock.eq(String.class), (Object)((String)EasyMock.isNull()))).andReturn((Object)"evaluated");
        EasyMock.replay((Object[])new Object[]{this.templateProcessor});
        Assert.assertEquals((Object)"evaluated", (Object)this.handler.getValueFromTag(element, "key", this.templateProcessor, String.class));
        EasyMock.verify((Object[])new Object[]{this.templateProcessor});
    }

    @Test
    public void getValueFromTagNoAttribute() {
        Element element = this.document.createElement("test");
        EasyMock.replay((Object[])new Object[]{this.templateProcessor});
        Assert.assertNull((Object)this.handler.getValueFromTag(element, "notthere", this.templateProcessor, String.class));
        EasyMock.verify((Object[])new Object[]{this.templateProcessor});
    }
}

