/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates.tags;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.el.ELResolver;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.expressions.RootELResolver;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.DefaultHtmlSerializer;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.SocialDataTags;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSimplifiedHtmlParser;
import org.apache.shindig.gadgets.templates.DefaultTemplateProcessor;
import org.apache.shindig.gadgets.templates.TagRegistry;
import org.apache.shindig.gadgets.templates.TemplateContext;
import org.apache.shindig.gadgets.templates.tags.CompositeTagRegistry;
import org.apache.shindig.gadgets.templates.tags.DefaultTagRegistry;
import org.apache.shindig.gadgets.templates.tags.RenderTagHandler;
import org.apache.shindig.gadgets.templates.tags.TemplateBasedTagHandler;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RenderTagHandlerTest {
    private Expressions expressions;
    private TemplateContext context;
    private DefaultTemplateProcessor processor;
    private Map<String, JSONObject> variables;
    private ELResolver resolver;
    private TagRegistry registry;
    private NekoSimplifiedHtmlParser parser;
    private static final String TEST_NS = "http://example.com";

    @Before
    public void setUp() throws Exception {
        this.expressions = Expressions.forTesting();
        this.variables = Maps.newHashMap();
        ImmutableSet handlers = ImmutableSet.of((Object)new RenderTagHandler());
        this.registry = new DefaultTagRegistry((Set)handlers);
        this.processor = new DefaultTemplateProcessor(this.expressions);
        this.resolver = new RootELResolver();
        this.parser = new NekoSimplifiedHtmlParser(new ParseModule.DOMImplementationProvider().get());
        Gadget gadget = new Gadget();
        gadget.setContext(new GadgetContext());
        this.context = new TemplateContext(gadget, this.variables);
        this.addVariable("foo", new JSONObject("{ title: 'bar' }"));
    }

    @Test
    public void renderAllChildren() throws Exception {
        this.runTest("Bar", "[<os:Render/>]", "<foo:Bar>Hello</foo:Bar>", "[Hello]");
    }

    @Test
    public void renderSingleChildren() throws Exception {
        this.runTest("Panel", "<os:Render content='header'/> <os:Render content='footer'/>", "<foo:Panel><footer>Second</footer><header>First</header></foo:Panel>", "First Second");
    }

    private void runTest(String tagName, String tagMarkup, String templateMarkup, String expectedResult) throws GadgetException, IOException {
        Element templateDef = this.parseTemplate(templateMarkup);
        Element tagInstance = this.parseTemplate(tagMarkup);
        templateDef.getOwnerDocument().adoptNode(tagInstance);
        TemplateBasedTagHandler tagHandler = new TemplateBasedTagHandler(tagInstance, TEST_NS, tagName);
        CompositeTagRegistry reg = new CompositeTagRegistry((Collection)ImmutableList.of((Object)this.registry, (Object)new DefaultTagRegistry((Set)ImmutableSet.of((Object)tagHandler))));
        DocumentFragment result = this.processor.processTemplate(templateDef, this.context, this.resolver, (TagRegistry)reg);
        String output = this.serialize(result);
        Assert.assertEquals((Object)expectedResult, (Object)output);
    }

    private Element parseTemplate(String markup) throws GadgetException {
        String content = "<script type=\"text/os-template\" xmlns:foo=\"http://example.com\" xmlns:os=\"http://ns.opensocial.org/2008/markup\">" + markup + "</script>";
        Document document = this.parser.parseDom(content);
        return (Element)SocialDataTags.getTags((Document)document, (String)"OSTemplate").get(0);
    }

    private String serialize(Node node) throws IOException {
        StringBuilder sb = new StringBuilder();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            new DefaultHtmlSerializer().serialize(child, (Appendable)sb);
        }
        return sb.toString();
    }

    private void addVariable(String key, JSONObject value) {
        this.variables.put(key, value);
    }
}

