/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.AbstractContainerConfig;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.uri.DefaultAccelUriManager;
import org.apache.shindig.gadgets.uri.DefaultProxyUriManager;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultAccelUriManagerTest {
    DefaultAccelUriManager uriManager;

    @Before
    public void setUp() throws Exception {
        FakeContainerConfig config = new FakeContainerConfig();
        this.uriManager = new DefaultAccelUriManager((ContainerConfig)config, (ProxyUriManager)new DefaultProxyUriManager((ContainerConfig)config, null));
    }

    @Test
    public void testParseAndNormalizeNonAccelUri() throws Exception {
        Uri uri = Uri.parse((String)"http://www.example.org/index.html");
        HttpRequest req = new HttpRequest(uri);
        Assert.assertEquals((Object)Uri.parse((String)"//apache.org/gadgets/proxy?container=default&gadget=http%3A%2F%2Fwww.example.org%2Findex.html&debug=0&nocache=0&refresh=0&url=http%3A%2F%2Fwww.example.org%2Findex.html"), (Object)this.uriManager.parseAndNormalize(req));
        uri = Uri.parse((String)"http://www.example.org/index.html");
        req = new HttpRequest(uri);
        req.setContainer("accel");
        Assert.assertEquals((Object)Uri.parse((String)"//apache.org/gadgets/accel?container=accel&gadget=http%3A%2F%2Fwww.example.org%2Findex.html&debug=0&nocache=0&refresh=0&url=http%3A%2F%2Fwww.example.org%2Findex.html"), (Object)this.uriManager.parseAndNormalize(req));
    }

    @Test
    public void testParseAndNormalizeAccelUri() throws Exception {
        Uri uri = Uri.parse((String)"http://apache.org/gadgets/accel?container=accel&gadget=http%3A%2F%2Fwww.1.com%2Fa.html&url=http%3A%2F%2Fwww.example.org%2Findex.html");
        HttpRequest req = new HttpRequest(uri);
        Assert.assertEquals((Object)Uri.parse((String)"//apache.org/gadgets/accel?container=accel&gadget=http%3A%2F%2Fwww.1.com%2Fa.html&debug=0&nocache=0&refresh=0&url=http%3A%2F%2Fwww.example.org%2Findex.html"), (Object)this.uriManager.parseAndNormalize(req));
    }

    @Test
    public void testLooksLikeAccelUri() throws Exception {
        Uri uri = Uri.parse((String)"http://apache.org/gadgets/accel?container=accel&gadget=http%3A%2F%2Fwww.1.com%2Fa.html&url=http%3A%2F%2Fwww.example.org%2Findex.html");
        Assert.assertTrue((boolean)this.uriManager.looksLikeAccelUri(uri));
        uri = Uri.parse((String)"http://www.example.org/index.html");
        Assert.assertFalse((boolean)this.uriManager.looksLikeAccelUri(uri));
    }

    private static class FakeContainerConfig
    extends AbstractContainerConfig {
        protected final Map<String, Object> defaultConfig = ImmutableMap.builder().put((Object)"gadgets.uri.proxy.host", (Object)"apache.org").put((Object)"gadgets.uri.proxy.path", (Object)"/gadgets/proxy").build();
        protected final Map<String, Object> accelConfig = ImmutableMap.builder().put((Object)"gadgets.uri.proxy.host", (Object)"apache.org").put((Object)"gadgets.uri.proxy.path", (Object)"/gadgets/accel").build();
        protected final Map<String, Map<String, Object>> data = ImmutableMap.builder().put((Object)"default", this.defaultConfig).put((Object)"accel", this.accelConfig).build();

        private FakeContainerConfig() {
        }

        public Object getProperty(String container, String name) {
            return this.data.get(container) != null ? this.data.get(container).get(name) : null;
        }
    }
}

