/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.uri.DefaultProxyUriManager;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriManagerTestBase;
import org.apache.shindig.gadgets.uri.UriStatus;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProxyUriManagerTest
extends UriManagerTestBase {
    private static final Uri RESOURCE_1 = Uri.parse((String)"http://example.com/one.dat?param=value");
    private static final Uri RESOURCE_2 = Uri.parse((String)"http://gadgets.com/two.dat");
    private static final Uri RESOURCE_3 = Uri.parse((String)"http://foobar.com/three.dat");

    @Test
    public void basicProxyQueryStyle() throws Exception {
        this.checkQueryStyle(false, false, null);
    }

    @Test
    public void altParamsProxyQueryStyle() throws Exception {
        this.checkQueryStyle(true, true, "version");
    }

    private void checkQueryStyle(boolean debug, boolean noCache, String version) throws Exception {
        String host = "host.com";
        String path = "/proxy/path";
        ImmutableList resources = ImmutableList.of((Object)RESOURCE_1);
        List<Uri> uris = this.makeAndGet(host, path, debug, noCache, (List<Uri>)resources, version);
        Assert.assertEquals((long)1L, (long)uris.size());
        this.verifyQueryUri(RESOURCE_1, uris.get(0), debug, noCache, version, host, path);
    }

    @Test
    public void refreshVerifyBasic() throws Exception {
        this.verifyRefresh(false, false, "version", 20);
    }

    @Test
    public void refreshVerifyNoCache() throws Exception {
        this.verifyRefresh(false, true, "version", 20);
    }

    @Test
    public void refreshVerifyNoRefresh() throws Exception {
        this.verifyRefresh(false, false, "version", null);
    }

    public void verifyRefresh(boolean debug, boolean noCache, String version, Integer refresh) throws Exception {
        String host = "host.com";
        String path = "/proxy/path";
        ProxyUriManager.Versioner versioner = this.makeVersioner(null, version);
        DefaultProxyUriManager manager = this.makeManager(host, path, versioner);
        LinkedList proxyUris = Lists.newLinkedList();
        proxyUris.add(new ProxyUriManager.ProxyUri(refresh, debug, noCache, "container", SPEC_URI.toString(), RESOURCE_1));
        List uris = manager.make((List)proxyUris, null);
        Assert.assertEquals((long)1L, (long)uris.size());
        this.verifyQueryUriWithRefresh(RESOURCE_1, (Uri)uris.get(0), debug, noCache, version, refresh, host, path);
    }

    @Test
    public void verifyAddedParamsQuery() throws Exception {
        String host = "host.com";
        String path = "/proxy/path";
        ProxyUriManager.Versioner versioner = this.makeVersioner(null, "version1", "version2");
        DefaultProxyUriManager manager = this.makeManager(host, path, versioner);
        LinkedList proxyUris = Lists.newLinkedList();
        ProxyUriManager.ProxyUri pUri = new ProxyUriManager.ProxyUri(null, false, true, "container", SPEC_URI.toString(), RESOURCE_1);
        pUri.setResize(Integer.valueOf(100), Integer.valueOf(10), Integer.valueOf(90), true);
        proxyUris.add(pUri);
        pUri = new ProxyUriManager.ProxyUri(null, false, true, "container", SPEC_URI.toString(), RESOURCE_2);
        pUri.setResize(null, Integer.valueOf(10), null, false);
        proxyUris.add(pUri);
        List uris = manager.make((List)proxyUris, null);
        Assert.assertEquals((long)2L, (long)uris.size());
        this.verifyQueryUriWithRefresh(RESOURCE_1, (Uri)uris.get(0), false, true, "version1", null, host, path);
        Assert.assertEquals((Object)"100", (Object)((Uri)uris.get(0)).getQueryParameter("resize_w"));
        Assert.assertEquals((Object)"10", (Object)((Uri)uris.get(0)).getQueryParameter("resize_h"));
        Assert.assertEquals((Object)"90", (Object)((Uri)uris.get(0)).getQueryParameter("resize_q"));
        Assert.assertEquals((Object)"1", (Object)((Uri)uris.get(0)).getQueryParameter("no_expand"));
        Assert.assertEquals(null, (Object)((Uri)uris.get(1)).getQueryParameter("resize_w"));
        Assert.assertEquals((Object)"10", (Object)((Uri)uris.get(1)).getQueryParameter("resize_h"));
        Assert.assertEquals(null, (Object)((Uri)uris.get(1)).getQueryParameter("resize_q"));
        Assert.assertEquals(null, (Object)((Uri)uris.get(1)).getQueryParameter("no_expand"));
    }

    @Test
    public void verifyAddedParamsChained() throws Exception {
        String host = "host.com";
        String path = "/proxy/%chained_params%/path";
        ProxyUriManager.Versioner versioner = this.makeVersioner(null, "version");
        DefaultProxyUriManager manager = this.makeManager(host, path, versioner);
        LinkedList proxyUris = Lists.newLinkedList();
        ProxyUriManager.ProxyUri pUri = new ProxyUriManager.ProxyUri(null, false, true, "container", SPEC_URI.toString(), RESOURCE_1);
        pUri.setResize(Integer.valueOf(100), Integer.valueOf(10), Integer.valueOf(90), true);
        proxyUris.add(pUri);
        List uris = manager.make((List)proxyUris, null);
        Assert.assertEquals((long)1L, (long)uris.size());
        this.verifyChainedUri(RESOURCE_1, (Uri)uris.get(0), false, true, null, false, host, path);
        Assert.assertEquals((Object)"/proxy/container=container&gadget=http%3A%2F%2Fexample.com%2Fgadget.xml&debug=0&nocache=1&v=version&resize_h=10&resize_w=100&resize_q=90&no_expand=1/path/http://example.com/one.dat", (Object)((Uri)uris.get(0)).getPath());
    }

    @Test
    public void testFallbackUrl() throws Exception {
        ProxyUriManager.ProxyUri uri = new ProxyUriManager.ProxyUri(null, false, false, "open", "http://example.com/gadget", Uri.parse((String)"http://example.com/resource"));
        uri.setFallbackUrl("http://example.com/fallback");
        Assert.assertEquals((Object)"http://example.com/fallback", (Object)uri.getFallbackUri().toString());
    }

    @Test(expected=GadgetException.class)
    public void testBadFallbackUrl() throws Exception {
        ProxyUriManager.ProxyUri uri = new ProxyUriManager.ProxyUri(null, false, false, "open", "http://example.com/gadget", Uri.parse((String)"http://example.com/resource"));
        uri.setFallbackUrl("bad url");
        uri.getFallbackUri();
    }

    @Test
    public void basicProxyChainedStyle() throws Exception {
        this.checkChainedStyle(false, false, null);
    }

    @Test
    public void altParamsProxyChainedStyle() throws Exception {
        this.checkChainedStyle(true, true, "version");
    }

    private void checkChainedStyle(boolean debug, boolean noCache, String version) throws Exception {
        String host = "host.com";
        String path = "/proxy/%chained_params%/path";
        ImmutableList resources = ImmutableList.of((Object)RESOURCE_1);
        List<Uri> uris = this.makeAndGet(host, path, debug, noCache, (List<Uri>)resources, version);
        Assert.assertEquals((long)1L, (long)uris.size());
        this.verifyChainedUri(RESOURCE_1, uris.get(0), debug, noCache, version, false, host, path);
    }

    @Test
    public void basicProxyChainedStyleEndOfPath() throws Exception {
        this.checkChainedStyleEndOfPath(false, false, null);
    }

    @Test
    public void altParamsProxyChainedStyleEndOfPath() throws Exception {
        this.checkChainedStyleEndOfPath(true, true, "version");
    }

    private void checkChainedStyleEndOfPath(boolean debug, boolean noCache, String version) throws Exception {
        String host = "host.com";
        String path = "/proxy/%chained_params%";
        ImmutableList resources = ImmutableList.of((Object)RESOURCE_1);
        List<Uri> uris = this.makeAndGet(host, path, debug, noCache, (List<Uri>)resources, version);
        Assert.assertEquals((long)1L, (long)uris.size());
        this.verifyChainedUri(RESOURCE_1, uris.get(0), debug, noCache, version, true, host, path);
    }

    @Test
    public void batchedProxyQueryStyle() throws Exception {
        String host = "host.com";
        String path = "/proxy/path";
        ImmutableList resources = ImmutableList.of((Object)RESOURCE_1, (Object)RESOURCE_2, (Object)RESOURCE_3);
        String[] versions = new String[]{"v1", "v2", "v3"};
        List<Uri> uris = this.makeAndGet(host, path, true, true, (List<Uri>)resources, versions);
        Assert.assertEquals((long)3L, (long)uris.size());
        for (int i = 0; i < 3; ++i) {
            this.verifyQueryUri((Uri)resources.get(i), uris.get(i), true, true, versions[i], host, path);
        }
    }

    @Test
    public void batchedProxyChainedStyle() throws Exception {
        String host = "host.com";
        String path = "/proxy/%chained_params%/path";
        ImmutableList resources = ImmutableList.of((Object)RESOURCE_1, (Object)RESOURCE_2, (Object)RESOURCE_3);
        String[] versions = new String[]{"v1", "v2", "v3"};
        List<Uri> uris = this.makeAndGet(host, path, true, true, (List<Uri>)resources, versions);
        Assert.assertEquals((long)3L, (long)uris.size());
        for (int i = 0; i < 3; ++i) {
            this.verifyChainedUri((Uri)resources.get(i), uris.get(i), true, true, versions[i], false, host, path);
        }
    }

    @Test
    public void batchedProxyChainedStyleNoVerisons() throws Exception {
        String host = "host.com";
        String path = "/proxy/%chained_params%/path";
        ImmutableList resources = ImmutableList.of((Object)RESOURCE_1, (Object)RESOURCE_2, (Object)RESOURCE_3);
        List<Uri> uris = this.makeAndGet(host, path, true, true, (List<Uri>)resources, new String[0]);
        Assert.assertEquals((long)3L, (long)uris.size());
        for (int i = 0; i < 3; ++i) {
            this.verifyChainedUri((Uri)resources.get(i), uris.get(i), true, true, null, false, host, path);
        }
    }

    @Test
    public void validateQueryStyleUnversioned() throws Exception {
        this.checkValidate("/proxy/path", UriStatus.VALID_UNVERSIONED, null);
    }

    @Test
    public void validateChainedStyleUnversioned() throws Exception {
        this.checkValidate("/proxy/%chained_params%/path", UriStatus.VALID_UNVERSIONED, null);
    }

    @Test
    public void validateQueryStyleVersioned() throws Exception {
        this.checkValidate("/proxy/path", UriStatus.VALID_VERSIONED, "version");
    }

    @Test
    public void validateChainedStyleVersioned() throws Exception {
        this.checkValidate("/proxy/%chained_params%/path", UriStatus.VALID_VERSIONED, "version");
    }

    private void checkValidate(String path, UriStatus status, String version) throws Exception {
        String host = "host.com";
        ProxyUriManager.Versioner versioner = this.makeVersioner(version == null ? null : status, version);
        DefaultProxyUriManager manager = this.makeManager(host, path, versioner);
        Gadget gadget = this.mockGadget(false, false);
        ImmutableList resources = ImmutableList.of((Object)RESOURCE_1);
        List uris = manager.make(ProxyUriManager.ProxyUri.fromList((Gadget)gadget, (List)resources), Integer.valueOf(123));
        Assert.assertEquals((long)1L, (long)uris.size());
        ProxyUriManager.ProxyUri proxyUri = manager.process((Uri)uris.get(0));
        Assert.assertEquals((Object)RESOURCE_1, (Object)proxyUri.getResource());
        Assert.assertEquals((Object)"container", (Object)proxyUri.getContainer());
        Assert.assertEquals((Object)SPEC_URI.toString(), (Object)proxyUri.getGadget());
        Assert.assertEquals((long)123L, (long)proxyUri.getRefresh().intValue());
        Assert.assertEquals((Object)status, (Object)proxyUri.getStatus());
        Assert.assertEquals((Object)false, (Object)proxyUri.isDebug());
        Assert.assertEquals((Object)false, (Object)proxyUri.isNoCache());
    }

    @Test
    public void containerFallsBackToSynd() throws Exception {
        String host = "host.com";
        String path = "/path";
        DefaultProxyUriManager manager = this.makeManager(host, path, null);
        UriBuilder uriBuilder = new UriBuilder();
        uriBuilder.setScheme("http").setAuthority(host).setPath(path);
        uriBuilder.addQueryParameter(UriCommon.Param.URL.getKey(), RESOURCE_1.toString());
        uriBuilder.addQueryParameter("synd", "container");
        uriBuilder.addQueryParameter(UriCommon.Param.GADGET.getKey(), SPEC_URI.toString());
        uriBuilder.addQueryParameter(UriCommon.Param.REFRESH.getKey(), "321");
        ProxyUriManager.ProxyUri proxyUri = manager.process(uriBuilder.toUri());
        Assert.assertEquals((Object)RESOURCE_1, (Object)proxyUri.getResource());
        Assert.assertEquals((Object)"container", (Object)proxyUri.getContainer());
        Assert.assertEquals((Object)SPEC_URI.toString(), (Object)proxyUri.getGadget());
        Assert.assertEquals((long)321L, (long)proxyUri.getRefresh().intValue());
        Assert.assertEquals((Object)false, (Object)proxyUri.isDebug());
        Assert.assertEquals((Object)false, (Object)proxyUri.isNoCache());
    }

    @Test(expected=GadgetException.class)
    public void mismatchedHostStrict() throws Exception {
        String host = "host.com";
        String path = "/proxy/path";
        DefaultProxyUriManager manager = this.makeManager("foo" + host, path, null);
        manager.setUseStrictParsing(true);
        Uri testUri = new UriBuilder().setAuthority(host).setPath(path).addQueryParameter(UriCommon.Param.URL.getKey(), "http://foo.com").toUri();
        manager.process(testUri);
    }

    @Test
    public void mismatchedHostNonStrict() throws Exception {
        String host = "host.com";
        String path = "/proxy/path";
        DefaultProxyUriManager manager = this.makeManager("foo" + host, path, null);
        Uri testUri = new UriBuilder().setAuthority(host).setPath(path).addQueryParameter(UriCommon.Param.URL.getKey(), "http://foo.com").addQueryParameter(UriCommon.Param.CONTAINER.getKey(), "container").toUri();
        manager.process(testUri);
    }

    @Test(expected=GadgetException.class)
    public void missingContainerParamQuery() throws Exception {
        String host = "host.com";
        String path = "/proxy/path";
        DefaultProxyUriManager manager = this.makeManager(host, path, null);
        Uri testUri = new UriBuilder().setAuthority(host).setPath(path).addQueryParameter(UriCommon.Param.URL.getKey(), "http://foo.com").toUri();
        manager.process(testUri);
    }

    @Test(expected=GadgetException.class)
    public void missingContainerParamChained() throws Exception {
        String host = "host.com";
        String path = "/proxy/%chained_params%/path";
        DefaultProxyUriManager manager = this.makeManager(host, path, null);
        Uri testUri = new UriBuilder().setAuthority(host).setPath("/proxy/refresh=123/path/http://foo.com").toUri();
        manager.process(testUri);
    }

    @Test(expected=GadgetException.class)
    public void missingUrlQuery() throws Exception {
        String host = "host.com";
        String path = "/proxy/path";
        DefaultProxyUriManager manager = this.makeManager(host, path, null);
        Uri testUri = new UriBuilder().setAuthority(host).setPath(path).addQueryParameter(UriCommon.Param.CONTAINER.getKey(), "container").toUri();
        manager.process(testUri);
    }

    @Test(expected=GadgetException.class)
    public void missingUrlChained() throws Exception {
        String host = "host.com";
        String path = "/proxy/%chained_params%/path";
        DefaultProxyUriManager manager = this.makeManager(host, path, null);
        Uri testUri = new UriBuilder().setAuthority(host).setPath("/proxy/container=container/path/").toUri();
        manager.process(testUri);
    }

    @Test(expected=GadgetException.class)
    public void invalidUrlParamQuery() throws Exception {
        String host = "host.com";
        String path = "/proxy/path";
        DefaultProxyUriManager manager = this.makeManager(host, path, null);
        Uri testUri = new UriBuilder().setAuthority(host).setPath(path).addQueryParameter(UriCommon.Param.CONTAINER.getKey(), "container").addQueryParameter(UriCommon.Param.URL.getKey(), "!^!").toUri();
        manager.process(testUri);
    }

    @Test
    public void testHtmlTagContext() throws Exception {
        String host = "host.com";
        String path = "/proxy/path";
        DefaultProxyUriManager manager = this.makeManager(host, path, null);
        Uri testUri = new UriBuilder().setAuthority(host).setPath(path).addQueryParameter(UriCommon.Param.CONTAINER.getKey(), "container").addQueryParameter(UriCommon.Param.URL.getKey(), "http://www.example.org/").addQueryParameter(UriCommon.Param.HTML_TAG_CONTEXT.getKey(), "htmlTag").toUri();
        ProxyUriManager.ProxyUri proxyUri = manager.process(testUri);
        Assert.assertEquals((Object)"htmlTag", (Object)proxyUri.getHtmlTagContext());
        Uri targetUri = Uri.parse((String)"http://www.example2.org/");
        HttpRequest req = proxyUri.makeHttpRequest(targetUri);
        Assert.assertEquals((Object)"htmlTag", (Object)req.getParam(UriCommon.Param.HTML_TAG_CONTEXT.getKey()));
        UriBuilder builder = proxyUri.makeQueryParams(Integer.valueOf(1), "2");
        Assert.assertEquals((Object)"htmlTag", (Object)builder.getQueryParameter(UriCommon.Param.HTML_TAG_CONTEXT.getKey()));
    }

    private List<Uri> makeAndGet(String host, String path, boolean debug, boolean noCache, List<Uri> resources, String ... version) {
        return this.makeAndGetWithRefresh(host, path, debug, noCache, resources, 123, version);
    }

    private List<Uri> makeAndGetWithRefresh(String host, String path, boolean debug, boolean noCache, List<Uri> resources, Integer refresh, String ... version) {
        ProxyUriManager.Versioner versioner = this.makeVersioner(null, version);
        DefaultProxyUriManager manager = this.makeManager(host, path, versioner);
        Gadget gadget = this.mockGadget(debug, noCache);
        return manager.make(ProxyUriManager.ProxyUri.fromList((Gadget)gadget, resources), refresh);
    }

    private void verifyQueryUri(Uri orig, Uri uri, boolean debug, boolean noCache, String version, String host, String path) throws Exception {
        this.verifyQueryUriWithRefresh(orig, uri, debug, noCache, version, 123, host, path);
    }

    private void verifyQueryUriWithRefresh(Uri orig, Uri uri, boolean debug, boolean noCache, String version, Integer refresh, String host, String path) throws Exception {
        DefaultProxyUriManager manager = this.makeManager(host, path, null);
        ProxyUriManager.ProxyUri proxyUri = manager.process(uri);
        Assert.assertEquals((Object)orig, (Object)proxyUri.getResource());
        Assert.assertEquals((Object)debug, (Object)proxyUri.isDebug());
        Assert.assertEquals((Object)noCache, (Object)proxyUri.isNoCache());
        Assert.assertEquals((Object)(noCache ? Integer.valueOf(0) : refresh), (Object)proxyUri.getRefresh());
        Assert.assertEquals((Object)"container", (Object)proxyUri.getContainer());
        Assert.assertEquals((Object)SPEC_URI.toString(), (Object)proxyUri.getGadget());
        Assert.assertEquals((Object)(noCache || refresh == null ? null : refresh.toString()), (Object)uri.getQueryParameter(UriCommon.Param.REFRESH.getKey()));
        if (version != null) {
            Assert.assertEquals((Object)version, (Object)uri.getQueryParameter(UriCommon.Param.VERSION.getKey()));
        }
    }

    private void verifyChainedUri(Uri orig, Uri uri, boolean debug, boolean noCache, String version, boolean endOfPath, String host, String path) throws Exception {
        DefaultProxyUriManager manager = this.makeManager(host, path, null);
        ProxyUriManager.ProxyUri proxyUri = manager.process(uri);
        Assert.assertEquals((Object)orig, (Object)proxyUri.getResource());
        Assert.assertEquals((Object)debug, (Object)proxyUri.isDebug());
        Assert.assertEquals((Object)noCache, (Object)proxyUri.isNoCache());
        Assert.assertEquals((long)(noCache ? 0L : 123L), (long)proxyUri.getRefresh().intValue());
        Assert.assertEquals((Object)"container", (Object)proxyUri.getContainer());
        Assert.assertEquals((Object)SPEC_URI.toString(), (Object)proxyUri.getGadget());
        String uriStr = uri.toString();
        Assert.assertTrue((boolean)uriStr.endsWith(orig.toString()));
        int proxyEnd = uriStr.indexOf("/proxy/") + "/proxy/".length();
        String paramsUri = uriStr.substring(proxyEnd, endOfPath ? uriStr.indexOf(47, proxyEnd) : uriStr.indexOf("/path"));
        uri = new UriBuilder().setQuery(paramsUri).toUri();
        Assert.assertEquals((Object)(noCache ? null : "123"), (Object)uri.getQueryParameter(UriCommon.Param.REFRESH.getKey()));
        if (version != null) {
            Assert.assertEquals((Object)version, (Object)uri.getQueryParameter(UriCommon.Param.VERSION.getKey()));
        }
    }

    @Test
    public void testProxyGadgetsChainDecode() throws Exception {
        String host = "host.com";
        String path = "/proxy/%chained_params%";
        DefaultProxyUriManager uriManager = this.makeManager(host, path, null);
        Uri uri = Uri.parse((String)"http://host.com/gadgets/proxy/refresh%3d55%26container%3dcontainer/http://www.cnn.com/news?refresh=45");
        ProxyUriManager.ProxyUri pUri = uriManager.process(uri);
        Assert.assertEquals((Object)new Integer(55), (Object)pUri.getRefresh());
        Assert.assertEquals((Object)"http://www.cnn.com/news?refresh=45", (Object)pUri.getResource().toString());
        Assert.assertEquals((Object)"container", (Object)pUri.getContainer());
    }

    @Test
    public void testProxyGadgetsChainDecodeGif() throws Exception {
        String host = "host.com";
        String path = "/proxy/%chained_params%";
        DefaultProxyUriManager uriManager = this.makeManager(host, path, null);
        Uri uri = Uri.parse((String)"http://host.com/gadgets/proxy/container%3dcontainer%26gadget%3dhttp%3A%2F%2Fwww.orkut.com%2Fcss%2Fgen%2Fbase054.css.int%26debug%3d0%26nocache%3d0/http://www.orkut.com/img/castro/i%5freply.gif");
        ProxyUriManager.ProxyUri pUri = uriManager.process(uri);
        Assert.assertEquals((Object)false, (Object)pUri.isDebug());
        Assert.assertEquals((Object)"http://www.orkut.com/img/castro/i%5freply.gif", (Object)pUri.getResource().toString());
        Assert.assertEquals((Object)"container", (Object)pUri.getContainer());
        Assert.assertEquals((Object)"http://www.orkut.com/css/gen/base054.css.int", (Object)pUri.getGadget());
    }

    @Test
    public void testProxyGadgetsChainGif() throws Exception {
        String host = "host.com";
        String path = "/proxy/%chained_params%";
        DefaultProxyUriManager uriManager = this.makeManager(host, path, null);
        Uri uri = Uri.parse((String)"http://host.com/gadgets/proxy/container=container&gadget=http%3A%2F%2Fwww.orkut.com%2Fcss%2Fgen%2Fbase054.css.int&debug=0&nocache=0/http://www.orkut.com/img/castro/i_reply.gif");
        ProxyUriManager.ProxyUri pUri = uriManager.process(uri);
        Assert.assertEquals((Object)false, (Object)pUri.isDebug());
        Assert.assertEquals((Object)"http://www.orkut.com/img/castro/i_reply.gif", (Object)pUri.getResource().toString());
        Assert.assertEquals((Object)"container", (Object)pUri.getContainer());
        Assert.assertEquals((Object)"http://www.orkut.com/css/gen/base054.css.int", (Object)pUri.getGadget());
    }

    private DefaultProxyUriManager makeManager(String host, String path, ProxyUriManager.Versioner versioner) {
        ContainerConfig config = (ContainerConfig)EasyMock.createMock(ContainerConfig.class);
        EasyMock.expect((Object)config.getString("container", "gadgets.uri.proxy.host")).andReturn((Object)host).anyTimes();
        EasyMock.expect((Object)config.getString("container", "gadgets.uri.proxy.path")).andReturn((Object)path).anyTimes();
        EasyMock.replay((Object[])new Object[]{config});
        return new DefaultProxyUriManager(config, versioner);
    }

    private ProxyUriManager.Versioner makeVersioner(UriStatus status, String ... versions) {
        ProxyUriManager.Versioner versioner = (ProxyUriManager.Versioner)EasyMock.createMock(ProxyUriManager.Versioner.class);
        if (versions.length > 0) {
            EasyMock.expect((Object)versioner.version((List)EasyMock.isA(List.class), (String)EasyMock.eq((Object)"container"))).andReturn((Object)Lists.newArrayList((Object[])versions)).anyTimes();
        } else {
            EasyMock.expect((Object)versioner.version((List)EasyMock.isA(List.class), (String)EasyMock.eq((Object)"container"))).andReturn(null).anyTimes();
        }
        EasyMock.expect((Object)versioner.validate((Uri)EasyMock.isA(Uri.class), (String)EasyMock.eq((Object)"container"), (String)EasyMock.isA(String.class))).andReturn((Object)status).anyTimes();
        EasyMock.replay((Object[])new Object[]{versioner});
        return versioner;
    }
}

