/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PassthruManager
implements ProxyUriManager {
    private UriStatus expectStatus = UriStatus.VALID_VERSIONED;
    private boolean doProxy = false;
    private String proxyHost = null;
    private String proxyPath = null;

    public PassthruManager() {
    }

    public PassthruManager(String proxyHost, String proxyPath) {
        this.proxyHost = proxyHost;
        this.proxyPath = proxyPath;
        this.doProxy = true;
    }

    public List<Uri> make(List<ProxyUriManager.ProxyUri> resource, Integer forcedRefresh) {
        ArrayList ctx = Lists.newArrayListWithCapacity((int)resource.size());
        for (ProxyUriManager.ProxyUri res : resource) {
            ctx.add(this.getUri(res.getResource()));
        }
        return ImmutableList.copyOf((Collection)ctx);
    }

    private Uri getUri(Uri src) {
        if (!this.doProxy) {
            return src;
        }
        return new UriBuilder().setScheme("http").setAuthority(this.proxyHost).setPath(this.proxyPath).addQueryParameter(UriCommon.Param.URL.getKey(), src.toString()).toUri();
    }

    public ProxyUriManager.ProxyUri process(Uri uri) throws GadgetException {
        String proxied = uri.getQueryParameter(UriCommon.Param.URL.getKey());
        ProxyUriManager.ProxyUri proxyUri = new ProxyUriManager.ProxyUri(this.expectStatus, proxied != null ? Uri.parse((String)proxied) : null, uri);
        proxyUri.setHtmlTagContext(uri.getQueryParameter(UriCommon.Param.HTML_TAG_CONTEXT.getKey()));
        return proxyUri;
    }

    public void expectStatus(UriStatus status) {
        this.expectStatus = status;
    }
}

