/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.features;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.Pair;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.features.FeatureParser;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.features.FeatureResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class FeatureRegistry {
    public static final String RESOURCE_SCHEME = "res";
    public static final String FILE_SCHEME = "file";
    private static final Logger LOG = Logger.getLogger("org.apache.shindig.gadgets");
    private final Map<FeatureCacheKey, List<FeatureResource>> cache = new MapMaker().makeMap();
    private final FeatureParser parser = new FeatureParser();
    private final FeatureResourceLoader resourceLoader;
    private final ImmutableMap<String, FeatureNode> featureMap;

    @Inject
    public FeatureRegistry(FeatureResourceLoader resourceLoader, @Named(value="org.apache.shindig.features") List<String> features) throws GadgetException {
        this.resourceLoader = resourceLoader;
        this.featureMap = this.register(features);
        this.connectDependencyGraph();
        this.cache.clear();
    }

    protected ImmutableMap<String, FeatureNode> register(List<String> resourceList) throws GadgetException {
        HashMap featureMapBuilder = Maps.newHashMap();
        try {
            for (String location : resourceList) {
                Uri uriLoc = FeatureRegistry.getComponentUri(location);
                if (uriLoc.getScheme() != null && uriLoc.getScheme().equals(RESOURCE_SCHEME)) {
                    ArrayList resources = Lists.newArrayList();
                    location = uriLoc.getPath();
                    if (location.startsWith("/")) {
                        location = location.substring(1);
                    }
                    LOG.info("Loading resources from: " + uriLoc.toString());
                    if (location.endsWith(".txt")) {
                        for (String resource : this.getResourceContent(location).split("[\r\n]+")) {
                            if ((resource = resource.trim()).length() <= 0 || resource.charAt(0) == '#') continue;
                            resource = FeatureRegistry.getComponentUri(resource.trim()).getPath();
                            resources.add(resource);
                        }
                    } else {
                        resources.add(location);
                    }
                    this.loadResources(resources, featureMapBuilder);
                    continue;
                }
                LOG.info("Loading files from: " + location);
                this.loadFile(new File(uriLoc.getPath()), featureMapBuilder);
            }
            return ImmutableMap.copyOf((Map)featureMapBuilder);
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PATH, (Throwable)e);
        }
    }

    public List<FeatureResource> getFeatureResources(GadgetContext ctx, Collection<String> needed, List<String> unsupported, boolean transitive) {
        boolean useCache = transitive && !ctx.getIgnoreCache();
        FeatureCacheKey cacheKey = new FeatureCacheKey(needed, ctx, unsupported != null);
        if (useCache && this.cache.containsKey(cacheKey)) {
            return this.cache.get(cacheKey);
        }
        List<FeatureNode> featureNodes = null;
        featureNodes = transitive ? this.getTransitiveDeps(needed, unsupported) : this.getRequestedNodes(needed, unsupported);
        String targetBundleType = ctx.getRenderingContext() == RenderingContext.CONTAINER ? "container" : "gadget";
        ImmutableList.Builder resourcesBuilder = new ImmutableList.Builder();
        for (FeatureNode entry : featureNodes) {
            boolean specificContainerMatched = false;
            LinkedList noContainerBundles = Lists.newLinkedList();
            for (FeatureBundle bundle : entry.getBundles()) {
                if (!bundle.getType().equals(targetBundleType)) continue;
                String containerAttrib = bundle.getAttribs().get("container");
                if (containerAttrib != null) {
                    if (!this.containerMatch(containerAttrib, ctx.getContainer())) continue;
                    resourcesBuilder.addAll(bundle.getResources());
                    specificContainerMatched = true;
                    continue;
                }
                noContainerBundles.add(bundle);
            }
            if (specificContainerMatched) continue;
            for (FeatureBundle bundle : noContainerBundles) {
                resourcesBuilder.addAll(bundle.getResources());
            }
        }
        ImmutableList resources = resourcesBuilder.build();
        if (useCache && (unsupported == null || unsupported.isEmpty())) {
            this.cache.put(cacheKey, (List<FeatureResource>)resources);
        }
        return resources;
    }

    public List<FeatureResource> getFeatureResources(GadgetContext ctx, Collection<String> needed, List<String> unsupported) {
        return this.getFeatureResources(ctx, needed, unsupported, true);
    }

    public List<FeatureResource> getAllFeatures() {
        return this.getFeatureResources(new GadgetContext(), (Collection<String>)this.featureMap.keySet(), null);
    }

    public List<String> getFeatures(Collection<String> needed) {
        List<FeatureNode> fullTree = this.getTransitiveDeps(needed, Lists.newLinkedList());
        LinkedList allFeatures = Lists.newLinkedList();
        for (FeatureNode node : fullTree) {
            allFeatures.add(node.name);
        }
        return allFeatures;
    }

    public Set<String> getAllFeatureNames() {
        return this.featureMap.keySet();
    }

    String getResourceContent(String resource) throws IOException {
        return ResourceLoader.getContent((String)resource);
    }

    static Uri getComponentUri(String str) {
        Uri uri = null;
        uri = str.startsWith("res://") ? new UriBuilder().setScheme(RESOURCE_SCHEME).setPath(str.substring(6)).toUri() : Uri.parse((String)str);
        return uri;
    }

    private List<FeatureNode> getTransitiveDeps(Collection<String> needed, List<String> unsupported) {
        final List<FeatureNode> requested = this.getRequestedNodes(needed, unsupported);
        Comparator<FeatureNode> nodeDepthComparator = new Comparator<FeatureNode>(){

            @Override
            public int compare(FeatureNode one, FeatureNode two) {
                if (one.nodeDepth > two.nodeDepth || one.nodeDepth == two.nodeDepth && requested.indexOf(one) < requested.indexOf(two)) {
                    return -1;
                }
                return 1;
            }
        };
        Collections.sort(requested, nodeDepthComparator);
        HashSet alreadySeen = Sets.newHashSet();
        LinkedList fullDeps = Lists.newLinkedList();
        for (FeatureNode requestedFeature : requested) {
            for (FeatureNode toAdd : requestedFeature.getTransitiveDeps()) {
                if (alreadySeen.contains(toAdd.name)) continue;
                alreadySeen.add(toAdd.name);
                fullDeps.add(toAdd);
            }
        }
        return fullDeps;
    }

    private List<FeatureNode> getRequestedNodes(Collection<String> needed, List<String> unsupported) {
        ArrayList requested = Lists.newArrayList();
        for (String featureName : needed) {
            if (this.featureMap.containsKey((Object)featureName)) {
                requested.add(this.featureMap.get((Object)featureName));
                continue;
            }
            if (unsupported == null) continue;
            unsupported.add(featureName);
        }
        return requested;
    }

    private boolean containerMatch(String containerAttrib, String container) {
        for (String attr : StringUtils.split((String)containerAttrib, (char)',')) {
            if (!attr.trim().equals(container)) continue;
            return true;
        }
        return false;
    }

    private void connectDependencyGraph() throws GadgetException {
        LinkedList problems = Lists.newLinkedList();
        LinkedList theFeatures = Lists.newLinkedList();
        for (Map.Entry featureEntry : this.featureMap.entrySet()) {
            String name = (String)featureEntry.getKey();
            FeatureNode feature = (FeatureNode)featureEntry.getValue();
            for (String rawDep : feature.getRawDeps()) {
                if (!this.featureMap.containsKey((Object)rawDep)) {
                    problems.add("Feature [" + name + "] has dependency on unknown feature: " + rawDep);
                    continue;
                }
                feature.addDep((FeatureNode)this.featureMap.get((Object)rawDep));
                theFeatures.add(feature);
            }
        }
        for (FeatureNode feature : theFeatures) {
            try {
                feature.completeNodeGraph();
            }
            catch (GadgetException e) {
                problems.add(e.getMessage());
            }
        }
        if (!problems.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Problems found processing features:\n");
            Joiner.on((char)'\n').appendTo(sb, (Iterable)problems);
            throw new GadgetException(GadgetException.Code.INVALID_CONFIG, sb.toString());
        }
    }

    private void loadResources(List<String> resources, Map<String, FeatureNode> featureMapBuilder) throws GadgetException {
        try {
            for (String resource : resources) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Processing resource: " + resource);
                }
                String content = this.getResourceContent(resource);
                Uri parent = new UriBuilder().setScheme(RESOURCE_SCHEME).setPath(resource).toUri();
                this.loadFeature(parent, content, featureMapBuilder);
            }
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PATH, (Throwable)e);
        }
    }

    private void loadFile(File file, Map<String, FeatureNode> featureMapBuilder) throws GadgetException, IOException {
        File[] toLoad;
        File[] fileArray;
        if (!file.exists() || !file.canRead()) {
            throw new GadgetException(GadgetException.Code.INVALID_CONFIG, "Feature file '" + file.getPath() + "' doesn't exist or can't be read");
        }
        if (file.isDirectory()) {
            fileArray = file.listFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        for (File featureFile : toLoad = fileArray) {
            if (featureFile.isDirectory()) {
                this.loadFile(featureFile, featureMapBuilder);
                continue;
            }
            if (featureFile.getName().toLowerCase(Locale.ENGLISH).endsWith(".xml")) {
                String content = ResourceLoader.getContent((File)featureFile);
                Uri parent = Uri.fromJavaUri((URI)featureFile.toURI());
                this.loadFeature(parent, content, featureMapBuilder);
                continue;
            }
            if (!LOG.isLoggable(Level.FINEST)) continue;
            LOG.finest(featureFile.getAbsolutePath() + " doesn't seem to be an XML file.");
        }
    }

    protected void loadFeature(Uri parent, String xml, Map<String, FeatureNode> featureMapBuilder) throws GadgetException {
        FeatureParser.ParsedFeature parsed = this.parser.parse(parent, xml);
        if (featureMapBuilder.containsKey(parsed.getName()) && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Overriding feature: " + parsed.getName() + " with def at: " + parent);
        }
        ArrayList bundles = Lists.newArrayList();
        for (FeatureParser.ParsedFeature.Bundle parsedBundle : parsed.getBundles()) {
            ArrayList resources = Lists.newArrayList();
            for (FeatureParser.ParsedFeature.Resource parsedResource : parsedBundle.getResources()) {
                if (parsedResource.getSource() == null) {
                    resources.add(new InlineFeatureResource(parsedResource.getContent()));
                    continue;
                }
                resources.add(this.resourceLoader.load(parsedResource.getSource(), this.getResourceAttribs(parsedBundle.getAttribs(), parsedResource.getAttribs())));
            }
            bundles.add(new FeatureBundle(parsedBundle.getType(), parsedBundle.getAttribs(), resources));
        }
        featureMapBuilder.put(parsed.getName(), new FeatureNode(parsed.getName(), bundles, parsed.getDeps()));
    }

    private Map<String, String> getResourceAttribs(Map<String, String> bundleAttribs, Map<String, String> resourceAttribs) {
        return ImmutableMap.builder().putAll(bundleAttribs).putAll(resourceAttribs).build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FeatureCacheKey {
        private final Collection<String> needed;
        private final RenderingContext rCtx;
        private final String container;
        private final boolean useUnsupported;

        private FeatureCacheKey(Collection<String> needed, GadgetContext ctx, boolean useUnsupported) {
            this.needed = needed;
            this.rCtx = ctx.getRenderingContext();
            this.container = ctx.getContainer();
            this.useUnsupported = useUnsupported;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof FeatureCacheKey)) {
                return false;
            }
            FeatureCacheKey otherKey = (FeatureCacheKey)other;
            return otherKey.needed.equals(this.needed) && otherKey.rCtx == this.rCtx && otherKey.container.equals(this.container) && otherKey.useUnsupported == this.useUnsupported;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.needed, this.rCtx, this.container, this.useUnsupported});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FeatureNode {
        private final String name;
        private final List<FeatureBundle> bundles;
        private final List<String> requestedDeps;
        private final List<FeatureNode> depList;
        private List<FeatureNode> transitiveDeps;
        private boolean calculatedDepsStale;
        private int nodeDepth = 0;

        private FeatureNode(String name, List<FeatureBundle> bundles, List<String> rawDeps) {
            this.name = name;
            this.bundles = ImmutableList.copyOf(bundles);
            this.requestedDeps = ImmutableList.copyOf(rawDeps);
            this.depList = Lists.newLinkedList();
            this.transitiveDeps = Lists.newArrayList((Object[])new FeatureNode[]{this});
            this.calculatedDepsStale = false;
        }

        public List<FeatureBundle> getBundles() {
            return this.bundles;
        }

        public List<String> getRawDeps() {
            return this.requestedDeps;
        }

        public void addDep(FeatureNode dep) {
            this.depList.add(dep);
            this.calculatedDepsStale = true;
        }

        private List<FeatureNode> getDepList() {
            ArrayList revOrderDeps = Lists.newArrayList(this.depList);
            Collections.reverse(revOrderDeps);
            return ImmutableList.copyOf((Collection)revOrderDeps);
        }

        public void completeNodeGraph() throws GadgetException {
            if (!this.calculatedDepsStale) {
                return;
            }
            this.nodeDepth = 0;
            this.transitiveDeps = Lists.newLinkedList();
            this.transitiveDeps.add(this);
            LinkedList toTraverse = Lists.newLinkedList();
            toTraverse.add(Pair.of((Object)this, (Object)Pair.of((Object)0, (Object)"")));
            while (!toTraverse.isEmpty()) {
                Pair next = (Pair)toTraverse.poll();
                String debug = (String)((Pair)next.two).two + ((Integer)((Pair)next.two).one > 0 ? " -> " : "") + ((FeatureNode)next.one).name;
                if (next.one == this && (Integer)((Pair)next.two).one != 0) {
                    throw new GadgetException(GadgetException.Code.INVALID_CONFIG, "Feature dep loop detected: " + debug);
                }
                this.transitiveDeps.add((FeatureNode)next.one);
                this.nodeDepth = Math.max(this.nodeDepth, (Integer)((Pair)next.two).one);
                for (FeatureNode nextDep : ((FeatureNode)next.one).getDepList()) {
                    toTraverse.add(Pair.of((Object)nextDep, (Object)Pair.of((Object)((Integer)((Pair)next.two).one + 1), (Object)debug)));
                }
            }
            Collections.reverse(this.transitiveDeps);
            this.calculatedDepsStale = false;
        }

        public List<FeatureNode> getTransitiveDeps() {
            return this.transitiveDeps;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FeatureBundle {
        private final String type;
        private final Map<String, String> attribs;
        private final List<FeatureResource> resources;

        private FeatureBundle(String type, Map<String, String> attribs, List<FeatureResource> resources) {
            this.type = type;
            this.attribs = ImmutableMap.copyOf(attribs);
            this.resources = ImmutableList.copyOf(resources);
        }

        public String getType() {
            return this.type;
        }

        public Map<String, String> getAttribs() {
            return this.attribs;
        }

        public List<FeatureResource> getResources() {
            return this.resources;
        }
    }

    private static final class InlineFeatureResource
    extends FeatureResource.Default {
        private final String content;

        private InlineFeatureResource(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public String getDebugContent() {
            return this.content;
        }
    }
}

