/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.opensocial.GadgetRewriteException;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.plugin.PluginCompiler;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.reporting.SnippetProducer;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.apache.shindig.gadgets.parse.HtmlSerializer;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CajaContentRewriter
implements GadgetRewriter {
    public static final String CAJOLED_DOCUMENTS = "cajoledDocuments";
    private static final Logger LOG = Logger.getLogger(CajaContentRewriter.class.getName());
    private final Cache<String, Element> cajoledCache;
    private final RequestPipeline requestPipeline;
    private final HtmlSerializer htmlSerializer;

    @Inject
    public CajaContentRewriter(CacheProvider cacheProvider, RequestPipeline requestPipeline, HtmlSerializer htmlSerializer) {
        this.cajoledCache = cacheProvider.createCache(CAJOLED_DOCUMENTS);
        LOG.info("Cajoled cache created" + this.cajoledCache);
        this.requestPipeline = requestPipeline;
        this.htmlSerializer = htmlSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewrite(Gadget gadget, MutableContent mc) {
        block10: {
            Element cajoledOutput;
            if (!this.cajaEnabled(gadget)) {
                return;
            }
            GadgetContext gadgetContext = gadget.getContext();
            boolean debug = gadgetContext.getDebug();
            Document doc = mc.getDocument();
            String docContent = HtmlSerialization.serialize(doc);
            String cacheKey = HashUtil.checksum((byte[])docContent.getBytes());
            DocumentFragment root = doc.createDocumentFragment();
            root.appendChild(doc.getDocumentElement());
            Node cajoledData = null;
            if (this.cajoledCache != null && !debug && (cajoledOutput = (Element)this.cajoledCache.getElement((Object)cacheKey)) != null) {
                cajoledData = doc.adoptNode(cajoledOutput);
                this.createContainerFor(doc, cajoledData);
                mc.documentChanged();
            }
            if (cajoledData == null) {
                UriFetcher fetcher = this.makeFetcher(gadget);
                UriPolicy policy = this.makePolicy(gadget);
                URI javaGadgetUri = gadgetContext.getUrl().toJavaUri();
                SimpleMessageQueue mq = new SimpleMessageQueue();
                MessageContext context = new MessageContext();
                PluginMeta meta = new PluginMeta(fetcher, policy);
                PluginCompiler compiler = this.makePluginCompiler(meta, (MessageQueue)mq);
                compiler.setMessageContext(context);
                InputSource is = new InputSource(javaGadgetUri);
                boolean safe = false;
                compiler.addInput((ParseTreeNode)new Dom((Node)root), javaGadgetUri);
                try {
                    if (!compiler.run()) {
                        throw new GadgetRewriteException("Gadget has compile errors");
                    }
                    StringBuilder scriptBody = new StringBuilder();
                    CajoledModule cajoled = compiler.getJavascript();
                    JsPrettyPrinter tc = debug ? new JsPrettyPrinter(new Concatenator(scriptBody)) : new JsMinimalPrinter(new Concatenator(scriptBody));
                    cajoled.render(new RenderContext((TokenConsumer)tc).withAsciiOnly(true).withEmbeddable(true));
                    tc.noMoreTokens();
                    Node html = compiler.getStaticHtml();
                    Element script = doc.createElementNS("http://www.w3.org/1999/xhtml", "script");
                    script.setAttributeNS("http://www.w3.org/1999/xhtml", "type", "text/javascript");
                    script.appendChild(doc.createTextNode(scriptBody.toString()));
                    Element cajoledOutput2 = doc.createElement("div");
                    cajoledOutput2.setAttribute("id", "cajoled-output");
                    cajoledOutput2.setAttribute("classes", "g___");
                    cajoledOutput2.setAttribute("style", "position: relative;");
                    cajoledOutput2.appendChild(doc.adoptNode(html));
                    cajoledOutput2.appendChild(this.tameCajaClientApi(doc));
                    cajoledOutput2.appendChild(doc.adoptNode(script));
                    Element messagesNode = this.formatErrors(doc, is, docContent, (MessageQueue)mq, false);
                    cajoledOutput2.appendChild(messagesNode);
                    if (this.cajoledCache != null && !debug) {
                        this.cajoledCache.addElement((Object)cacheKey, (Object)cajoledOutput2);
                    }
                    safe = true;
                    cajoledData = cajoledOutput2;
                    this.createContainerFor(doc, cajoledData);
                    mc.documentChanged();
                    safe = true;
                    HtmlSerialization.attach(doc, this.htmlSerializer, null);
                }
                catch (GadgetRewriteException e) {
                    this.createContainerFor(doc, this.formatErrors(doc, is, docContent, (MessageQueue)mq, true));
                    this.logException((Exception)((Object)e), (MessageQueue)mq);
                    safe = true;
                }
                finally {
                    if (safe) break block10;
                    mc.setContent("");
                    return;
                }
            }
        }
    }

    private boolean cajaEnabled(Gadget gadget) {
        return gadget.getAllFeatures().contains("caja") || "1".equals(gadget.getContext().getParameter("caja"));
    }

    private UriFetcher makeFetcher(Gadget gadget) {
        final Uri gadgetUri = gadget.getContext().getUrl();
        final String container = gadget.getContext().getContainer();
        return new UriFetcher(){

            public FetchedData fetch(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
                LOG.info("Retrieving " + ref.toString());
                Uri resourceUri = gadgetUri.resolve(Uri.fromJavaUri((URI)ref.getUri()));
                HttpRequest request = new HttpRequest(resourceUri).setContainer(container).setGadget(gadgetUri);
                try {
                    HttpResponse response = CajaContentRewriter.this.requestPipeline.execute(request);
                    byte[] responseBytes = IOUtils.toByteArray((InputStream)response.getResponse());
                    return FetchedData.fromBytes((byte[])responseBytes, (String)mimeType, (String)response.getEncoding(), (InputSource)new InputSource(ref.getUri()));
                }
                catch (GadgetException e) {
                    LOG.info("Failed to retrieve: " + ref.toString());
                    return null;
                }
                catch (IOException e) {
                    LOG.info("Failed to read: " + ref.toString());
                    return null;
                }
            }
        };
    }

    private UriPolicy makePolicy(Gadget gadget) {
        final Uri gadgetUri = gadget.getContext().getUrl();
        return new UriPolicy(){

            public String rewriteUri(ExternalReference ref, UriPolicy.UriEffect effect, UriPolicy.LoaderType loader, Map<String, ?> hints) {
                URI uri = ref.getUri();
                if (uri.getScheme().equalsIgnoreCase("https") || uri.getScheme().equalsIgnoreCase("http")) {
                    return gadgetUri.resolve(Uri.fromJavaUri((URI)uri)).toString();
                }
                return null;
            }
        };
    }

    private void createContainerFor(Document doc, Node el) {
        Element docEl = doc.createElement("html");
        Element head = doc.createElement("head");
        Element body = doc.createElement("body");
        doc.appendChild(docEl);
        docEl.appendChild(head);
        docEl.appendChild(body);
        body.appendChild(el);
    }

    private Element formatErrors(Document doc, InputSource is, CharSequence orig, MessageQueue mq, boolean visible) {
        MessageContext mc = new MessageContext();
        HashMap originalSrc = Maps.newHashMap();
        originalSrc.put(is, orig);
        mc.addInputSource(is);
        SnippetProducer sp = new SnippetProducer((Map)originalSrc, mc);
        Element errElement = doc.createElement("ul");
        errElement.setAttribute("class", "gadgets-messages");
        if (!visible) {
            errElement.setAttribute("style", "display: none");
        }
        for (Message msg : mq.getMessages()) {
            if (MessageLevel.LINT.compareTo((Enum)msg.getMessageLevel()) > 0) continue;
            String snippet = sp.getSnippet(msg);
            String messageText = msg.getMessageLevel().name() + ' ' + CajaContentRewriter.html(msg.format(mc)) + ':' + snippet;
            Element li = doc.createElement("li");
            li.appendChild(doc.createTextNode(messageText));
            errElement.appendChild(li);
        }
        return errElement;
    }

    private static String html(CharSequence s) {
        StringBuilder sb = new StringBuilder();
        Escaping.escapeXml((CharSequence)s, (boolean)false, (StringBuilder)sb);
        return sb.toString();
    }

    private Element tameCajaClientApi(Document doc) {
        Element scriptElement = doc.createElement("script");
        scriptElement.setAttribute("type", "text/javascript");
        scriptElement.appendChild(doc.createTextNode("caja___.enable()"));
        return scriptElement;
    }

    private void logException(Exception cause, MessageQueue mq) {
        StringBuilder errbuilder = new StringBuilder();
        MessageContext mc = new MessageContext();
        if (cause != null) {
            errbuilder.append(cause).append('\n');
        }
        for (Message m : mq.getMessages()) {
            errbuilder.append(m.format(mc)).append('\n');
        }
        LOG.info("Unable to cajole gadget: " + errbuilder);
    }

    protected PluginCompiler makePluginCompiler(PluginMeta meta, MessageQueue mq) {
        PluginCompiler compiler = new PluginCompiler(BuildInfo.getInstance(), meta, mq);
        return compiler;
    }
}

