/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.servlet.MakeRequestHandler;

public class MakeRequestServlet
extends InjectedServlet {
    private static final long serialVersionUID = -8298705081500283786L;
    private transient MakeRequestHandler makeRequestHandler;

    @Inject
    public void setMakeRequestHandler(MakeRequestHandler makeRequestHandler) {
        this.checkInitialized();
        this.makeRequestHandler = makeRequestHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.makeRequestHandler.fetch(request, response);
        }
        catch (GadgetException e) {
            int responseCode = 500;
            if (e.getCode() != GadgetException.Code.INTERNAL_SERVER_ERROR) {
                responseCode = 400;
            }
            response.sendError(responseCode, e.getMessage() != null ? e.getMessage() : "");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }
}

