/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.easymock.EasyMock;
import org.junit.Test;

public class GadgetTest
extends EasyMockTestCase {
    private static final String SPEC_URL = "http://example.org/gadget.xml";
    private static final String SPEC_XML = "<Module><ModulePrefs title='title'>  <Preload href='http://example.org/foo'/>  <Locale>    <msg name='name'>VALUE</msg>  </Locale></ModulePrefs><Content type='html'>DEFAULT VIEW</Content><Content view='one' type='html'>VIEW ONE</Content><Content view='two' type='html'>VIEW TWO</Content></Module>";
    private final DummyContext context = new DummyContext();

    @Test
    public void getLocale() throws Exception {
        Gadget gadget = new Gadget().setContext((GadgetContext)this.context).setSpec(new GadgetSpec(Uri.parse((String)SPEC_URL), SPEC_XML));
        LocaleSpec localeSpec = gadget.getLocale();
        GadgetTest.assertEquals((Object)"VALUE", localeSpec.getMessageBundle().getMessages().get("name"));
    }

    @Test
    public void testGetFeatures() throws Exception {
        String xml = "<Module><ModulePrefs title=\"hello\"><Require feature=\"required1\"/></ModulePrefs><Content type=\"html\"/></Module>";
        FeatureRegistry registry = (FeatureRegistry)this.mock(FeatureRegistry.class, true);
        Gadget gadget = new Gadget().setContext((GadgetContext)this.context).setGadgetFeatureRegistry(registry).setSpec(new GadgetSpec(Uri.parse((String)SPEC_URL), xml));
        ArrayList needed = Lists.newArrayList(gadget.getSpec().getModulePrefs().getFeatures().keySet());
        ArrayList returned = Lists.newArrayList();
        EasyMock.expect((Object)registry.getFeatures((Collection)EasyMock.eq((Object)needed))).andReturn((Object)returned).anyTimes();
        this.replay();
        List requiredFeatures1 = gadget.getAllFeatures();
        GadgetTest.assertEquals((Object)returned, (Object)requiredFeatures1);
        List requiredFeatures2 = gadget.getAllFeatures();
        GadgetTest.assertSame((Object)returned, (Object)requiredFeatures2);
        this.verify();
    }

    private static class DummyContext
    extends GadgetContext {
        public String view = super.getView();
        public String container = super.getContainer();

        protected DummyContext() {
        }

        public String getView() {
            return this.view;
        }

        public String getContainer() {
            return this.container;
        }
    }
}

