/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.http.CacheKeyBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CacheKeyBuilderTest
extends Assert {
    private CacheKeyBuilder builder;

    @Before
    public void setUp() {
        this.builder = new CacheKeyBuilder().setLegacyParam(0, (Object)Uri.parse((String)"http://example.com")).setLegacyParam(1, (Object)AuthType.SIGNED);
    }

    @Test
    public void testBuilder() {
        CacheKeyBuilderTest.assertEquals((Object)"http://example.com:signed:0:0:0:0:0:0:0", (Object)this.builder.build());
    }

    @Test
    public void testOwner() {
        this.builder.setLegacyParam(2, (Object)"owner");
        CacheKeyBuilderTest.assertEquals((Object)"http://example.com:signed:owner:0:0:0:0:0:0", (Object)this.builder.build());
    }

    @Test
    public void testViewer() {
        this.builder.setLegacyParam(3, (Object)"viewer");
        CacheKeyBuilderTest.assertEquals((Object)"http://example.com:signed:0:viewer:0:0:0:0:0", (Object)this.builder.build());
    }

    @Test
    public void testTokenOwner() {
        this.builder.setLegacyParam(4, (Object)"token");
        CacheKeyBuilderTest.assertEquals((Object)"http://example.com:signed:0:0:token:0:0:0:0", (Object)this.builder.build());
    }

    @Test
    public void testAppUrl() {
        this.builder.setLegacyParam(5, (Object)"appurl");
        CacheKeyBuilderTest.assertEquals((Object)"http://example.com:signed:0:0:0:appurl:0:0:0", (Object)this.builder.build());
    }

    @Test
    public void testInstanceId() {
        this.builder.setLegacyParam(6, (Object)"id");
        CacheKeyBuilderTest.assertEquals((Object)"http://example.com:signed:0:0:0:0:id:0:0", (Object)this.builder.build());
    }

    @Test
    public void testServiceName() {
        this.builder.setLegacyParam(7, (Object)"srv");
        CacheKeyBuilderTest.assertEquals((Object)"http://example.com:signed:0:0:0:0:0:srv:0", (Object)this.builder.build());
    }

    @Test
    public void testTokenName() {
        this.builder.setLegacyParam(8, (Object)"token");
        CacheKeyBuilderTest.assertEquals((Object)"http://example.com:signed:0:0:0:0:0:0:token", (Object)this.builder.build());
    }

    @Test
    public void testParam() {
        this.builder.setParam("rh", (Object)1);
        CacheKeyBuilderTest.assertEquals((Object)"http://example.com:signed:0:0:0:0:0:0:0:rh=1", (Object)this.builder.build());
    }

    @Test
    public void testResizeParams() {
        this.builder.setParam("rh", (Object)1);
        this.builder.setParam("rq", (Object)2);
        this.builder.setParam("rw", (Object)3);
        CacheKeyBuilderTest.assertEquals((Object)"http://example.com:signed:0:0:0:0:0:0:0:rh=1:rq=2:rw=3", (Object)this.builder.build());
    }
}

