/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.junit.Assert;
import org.junit.Test;

public class HttpResponseBuilderTest {
    @Test
    public void copyConstructor() {
        HttpResponseBuilder builder = new HttpResponseBuilder().setHttpStatusCode(404).setMetadata("foo", "bar").addHeader("Foo-bar", "baz");
        HttpResponseBuilder builder2 = new HttpResponseBuilder(builder);
        Assert.assertEquals((Object)builder.create(), (Object)builder2.create());
    }

    @Test
    public void addHeader() {
        HttpResponseBuilder builder = new HttpResponseBuilder().addHeader("Foo-bar", "baz");
        Assert.assertEquals((Object)"baz", builder.getHeaders().get((Object)"Foo-bar").iterator().next());
    }

    @Test
    public void addHeadersMap() {
        ImmutableMap headers = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"blah", (Object)"blah");
        HttpResponseBuilder builder = new HttpResponseBuilder().addHeaders((Map)headers);
        Assert.assertEquals(Arrays.asList("bar"), (Object)Lists.newArrayList((Iterable)builder.getHeaders().get((Object)"foo")));
        Assert.assertEquals(Arrays.asList("blah"), (Object)Lists.newArrayList((Iterable)builder.getHeaders().get((Object)"blah")));
    }

    @Test
    public void addAllHeaders() {
        HashMap headers = Maps.newHashMap();
        ArrayList foo = Lists.newArrayList((Object[])new String[]{"bar", "blah"});
        ArrayList bar = Lists.newArrayList((Object[])new String[]{"baz"});
        headers.put("foo", foo);
        headers.put("bar", bar);
        HttpResponseBuilder builder = new HttpResponseBuilder().addAllHeaders((Map)headers);
        Assert.assertTrue((boolean)builder.getHeaders().get((Object)"foo").containsAll(foo));
        Assert.assertTrue((boolean)builder.getHeaders().get((Object)"bar").containsAll(bar));
    }

    @Test
    public void setExpirationTime() {
        HttpResponseBuilder builder = new HttpResponseBuilder().addHeader("Pragma", "no-cache").addHeader("Cache-Control", "public,max-age=100").setExpirationTime(100L);
        Multimap headers = builder.getHeaders();
        Assert.assertTrue((String)"No Expires header added.", (boolean)headers.containsKey((Object)"Expires"));
        Assert.assertFalse((String)"Pragma header not removed", (boolean)headers.containsKey((Object)"Pragma"));
        Assert.assertFalse((String)"Cache-Control header not removed", (boolean)headers.containsKey((Object)"Cache-Control"));
    }

    @Test
    public void setCacheTtl() {
        HttpResponseBuilder builder = new HttpResponseBuilder().addHeader("Pragma", "no-cache").addHeader("Expires", "some time stamp normally goes here").addHeader("Cache-Control", "no-cache").setCacheTtl(100);
        Multimap headers = builder.getHeaders();
        Assert.assertFalse((String)"Expires header not removed.", (boolean)headers.containsKey((Object)"Expires"));
        Assert.assertFalse((String)"Pragma header not removed", (boolean)headers.containsKey((Object)"Pragma"));
        Assert.assertEquals((Object)"public,max-age=100", headers.get((Object)"Cache-Control").iterator().next());
    }

    @Test
    public void setStrictNoCache() {
        HttpResponseBuilder builder = new HttpResponseBuilder().addHeader("Cache-Control", "public,max-age=100").addHeader("Expires", "some time stamp normally goes here").setStrictNoCache();
        Multimap headers = builder.getHeaders();
        Assert.assertFalse((String)"Expires header not removed.", (boolean)headers.containsKey((Object)"Expires"));
        Assert.assertEquals((Object)"no-cache", headers.get((Object)"Cache-Control").iterator().next());
        Assert.assertEquals((Object)"no-cache", headers.get((Object)"Pragma").iterator().next());
    }

    @Test
    public void setEncoding() {
        HttpResponseBuilder builder = new HttpResponseBuilder().addHeader("Content-Type", "text/html; charset=Big5").setEncoding(Charsets.UTF_8);
        Multimap headers = builder.getHeaders();
        Assert.assertEquals((Object)"text/html; charset=UTF-8", headers.get((Object)"Content-Type").iterator().next());
    }

    @Test
    public void setEncodingEmpty() {
        HttpResponseBuilder builder = new HttpResponseBuilder().addHeader("Content-Type", "text/html").setEncoding(Charsets.UTF_8);
        Multimap headers = builder.getHeaders();
        Assert.assertEquals((Object)"text/html; charset=UTF-8", headers.get((Object)"Content-Type").iterator().next());
    }

    @Test
    public void setResponseString() {
        HttpResponse resp = new HttpResponseBuilder().setResponseString("foo").create();
        Assert.assertEquals((Object)"foo", (Object)resp.getResponseAsString());
    }

    @Test
    public void setResponseStringWithContentType() {
        HttpResponse resp = new HttpResponseBuilder().addHeader("Content-Type", "text/html").setResponseString("foo").create();
        Multimap headers = resp.getHeaders();
        Assert.assertEquals((Object)"text/html; charset=UTF-8", headers.get((Object)"Content-Type").iterator().next());
        Assert.assertEquals((Object)"foo", (Object)resp.getResponseAsString());
    }

    @Test
    public void setResponse() {
        byte[] someData = "some data".getBytes();
        HttpResponse resp = new HttpResponseBuilder().setResponse(someData).create();
        Assert.assertNotSame((Object)someData, (Object)resp.getResponseAsBytes());
        Assert.assertArrayEquals((byte[])someData, (byte[])resp.getResponseAsBytes());
    }

    @Test
    public void setResponseNoCopy() {
        byte[] someData = "some data".getBytes();
        HttpResponse resp = new HttpResponseBuilder().setResponseNoCopy(someData).create();
        Assert.assertSame((Object)someData, (Object)resp.getResponseAsBytes());
    }

    @Test
    public void headerOrdering() {
        ImmutableList soupList = ImmutableList.of((Object)"Tomato", (Object)"Potato", (Object)"Lentil", (Object)"Onion");
        HttpResponseBuilder b = new HttpResponseBuilder();
        for (String soup : soupList) {
            b.addHeader("Soup", soup);
        }
        HttpResponse resp = b.create();
        Assert.assertEquals((Object)Joiner.on((String)",").join((Iterable)resp.getHeaders("Soup")), (Object)Joiner.on((String)",").join((Iterable)soupList));
    }

    @Test
    public void noModsReturnsSameResponse() {
        HttpResponseBuilder builder = new HttpResponseBuilder();
        builder.setHttpStatusCode(502);
        builder.setResponseString("foo");
        HttpResponse response = builder.create();
        Assert.assertSame((Object)response, (Object)builder.create());
    }

    @Test
    public void noModsReturnsSameResponseBuilderCtor() {
        HttpResponseBuilder builder = new HttpResponseBuilder();
        builder.setHttpStatusCode(200);
        HttpResponseBuilder nextBuilder = new HttpResponseBuilder(builder);
        Assert.assertSame((Object)builder.create(), (Object)nextBuilder.create());
    }

    @Test
    public void noModsReturnsSameResponseBaseCtor() {
        HttpResponse response = new HttpResponse("foo");
        HttpResponseBuilder builder = new HttpResponseBuilder(response);
        Assert.assertSame((Object)response, (Object)builder.create());
        builder.setHttpStatusCode(502);
        HttpResponse newResponse = builder.create();
        Assert.assertNotSame((Object)response, (Object)newResponse);
        Assert.assertSame((Object)newResponse, (Object)builder.create());
    }
}

