/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.HttpResponseMetadataHelper;
import org.junit.Assert;
import org.junit.Test;

public class HttpResponseMetadataHelperTest {
    @Test
    public void testUpdateMetadata() {
        HttpResponse local = new HttpResponseBuilder().setResponseString("data1").create();
        HttpResponse compiled = HttpResponseMetadataHelper.updateMetadata((HttpResponse)local, (Map)ImmutableMap.of((Object)"K", (Object)"V"));
        Assert.assertEquals((long)1L, (long)compiled.getMetadata().size());
        Assert.assertEquals((Object)"V", compiled.getMetadata().get("K"));
        HttpResponse compiled2 = HttpResponseMetadataHelper.updateMetadata((HttpResponse)compiled, (Map)ImmutableMap.of((Object)"K2", (Object)"V2"));
        Assert.assertEquals((long)2L, (long)compiled2.getMetadata().size());
        Assert.assertEquals((Object)"V2", compiled2.getMetadata().get("K2"));
        HttpResponse compiled3 = HttpResponseMetadataHelper.updateMetadata((HttpResponse)compiled2, (Map)ImmutableMap.of((Object)"K", (Object)"V3"));
        Assert.assertEquals((long)2L, (long)compiled3.getMetadata().size());
        Assert.assertEquals((Object)"V3", compiled3.getMetadata().get("K"));
    }

    @Test
    public void testHashCodeSimple() {
        HttpResponse local = new HttpResponseBuilder().setResponseString("data1").create();
        this.verifyHash(local, 1, "h7cg7f1lrrf74jul5h8k6vvlvk");
    }

    @Test
    public void testHashCodeExtraMeta() {
        HttpResponse local = new HttpResponseBuilder().setResponseString("data1").setMetadata((Map)ImmutableMap.of((Object)"K", (Object)"V")).setHeader("X-data", "no data").create();
        this.verifyHash(local, 2, "h7cg7f1lrrf74jul5h8k6vvlvk");
    }

    @Test
    public void testHashCodeError() {
        this.verifyHash(HttpResponse.error(), 1, "qgeopmcf02p09qc016cepu22fo");
    }

    @Test
    public void testHashCodeEmpty() {
        HttpResponse local = new HttpResponseBuilder().setHttpStatusCode(200).create();
        this.verifyHash(local, 1, "qgeopmcf02p09qc016cepu22fo");
    }

    private void verifyHash(HttpResponse resp, int metadataSize, String hash) {
        HttpResponseMetadataHelper metdataHelper = new HttpResponseMetadataHelper();
        HttpResponse compiled = HttpResponseMetadataHelper.updateHash((HttpResponse)resp, (HttpResponseMetadataHelper)metdataHelper);
        Assert.assertEquals((long)metadataSize, (long)compiled.getMetadata().size());
        Assert.assertEquals((Object)hash, compiled.getMetadata().get("DataHash"));
    }
}

