/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.gadgets.parse.AbstractParsingTestBase;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.apache.shindig.gadgets.parse.SocialDataTags;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSocialMarkupHtmlParserTest
extends AbstractParsingTestBase {
    private GadgetHtmlParser parser;
    private Document document;

    protected abstract GadgetHtmlParser makeParser();

    @Before
    public void setUp() throws Exception {
        this.parser = this.makeParser();
        String content = this.loadFile("org/apache/shindig/gadgets/parse/test-socialmarkup.html");
        this.document = this.parser.parseDom(content);
    }

    @Test
    public void testSocialData() {
        List scripts = SocialDataTags.getTags((Document)this.document, (String)"OSData");
        Assert.assertEquals((long)1L, (long)scripts.size());
        NodeList viewerRequests = ((Element)scripts.get(0)).getElementsByTagNameNS("http://ns.opensocial.org/2008/markup", "ViewerRequest");
        Assert.assertEquals((long)1L, (long)viewerRequests.getLength());
        Element viewerRequest = (Element)viewerRequests.item(0);
        Assert.assertEquals((Object)"viewer", (Object)viewerRequest.getAttribute("key"));
        this.assertEmpty(viewerRequest);
    }

    @Test
    public void testSocialTemplate() {
        List scripts = SocialDataTags.getTags((Document)this.document, (String)"OSTemplate");
        Assert.assertEquals((long)1L, (long)scripts.size());
        Assert.assertEquals((Object)"template-id", (Object)((Element)scripts.get(0)).getAttribute("id"));
        Assert.assertEquals((Object)"template-name", (Object)((Element)scripts.get(0)).getAttribute("name"));
        Assert.assertEquals((Object)"template-tag", (Object)((Element)scripts.get(0)).getAttribute("tag"));
        NodeList boldElements = ((Element)scripts.get(0)).getElementsByTagName("b");
        Assert.assertEquals((long)1L, (long)boldElements.getLength());
        Element boldElement = (Element)boldElements.item(0);
        Assert.assertEquals((Object)"Some ${viewer} content", (Object)boldElement.getTextContent());
        NodeList osHtmlElements = ((Element)scripts.get(0)).getElementsByTagNameNS("http://ns.opensocial.org/2008/markup", "Html");
        Assert.assertEquals((long)1L, (long)osHtmlElements.getLength());
    }

    @Test
    public void testSocialTemplateSerialization() {
        String content = HtmlSerialization.serialize((Document)this.document);
        Assert.assertTrue((String)"Empty elements not preserved as XML inside template", (boolean)content.contains("<img/>"));
    }

    @Test
    public void testJavascript() {
        List scripts = SocialDataTags.getTags((Document)this.document, (String)"script");
        Iterator scriptIt = scripts.iterator();
        while (scriptIt.hasNext()) {
            if (!SocialDataTags.isOpenSocialScript((Element)((Element)scriptIt.next()))) continue;
            scriptIt.remove();
        }
        Assert.assertEquals((long)1L, (long)scripts.size());
        NodeList boldElements = ((Element)scripts.get(0)).getElementsByTagName("b");
        Assert.assertEquals((long)0L, (long)boldElements.getLength());
        String scriptContent = ((Element)scripts.get(0)).getTextContent().trim();
        Assert.assertEquals((Object)"<b>Some ${viewer} content</b>", (Object)scriptContent);
    }

    @Test
    public void testPlainContent() {
        NodeList spanElements = this.document.getElementsByTagName("span");
        Assert.assertEquals((long)1L, (long)spanElements.getLength());
        Assert.assertEquals((Object)"Some content", (Object)spanElements.item(0).getTextContent());
    }

    @Test
    public void testCommentOrdering() {
        NodeList divElements = this.document.getElementsByTagName("div");
        Assert.assertEquals((long)1L, (long)divElements.getLength());
        NodeList children = divElements.item(0).getChildNodes();
        Assert.assertEquals((long)3L, (long)children.getLength());
        Assert.assertEquals((long)8L, (long)children.item(0).getNodeType());
        Assert.assertEquals((long)3L, (long)children.item(1).getNodeType());
        Assert.assertEquals((long)8L, (long)children.item(2).getNodeType());
    }

    @Test
    public void testInvalid() throws Exception {
        String content = "<html><div id=\"div_super\" class=\"div_super\" valign:\"middle\"></div></html>";
        Document doc = this.parser.parseDom(content);
        Node body = doc.getElementsByTagName("body").item(0);
        Assert.assertTrue((boolean)body.getTextContent().contains("INVALID_CHARACTER_ERR"));
        Assert.assertTrue((boolean)body.getTextContent().contains("Around ...<div id=\"div_super\" class=\"div_super\"..."));
        Assert.assertTrue((boolean)HtmlSerialization.serialize((Document)doc).contains("INVALID_CHARACTER_ERR"));
    }

    private void assertEmpty(Node n) {
        if (n.getChildNodes().getLength() != 0) {
            Assert.assertTrue((StringUtils.isEmpty((String)n.getTextContent()) || StringUtils.isWhitespace((String)n.getTextContent()) ? 1 : 0) != 0);
        }
    }
}

