/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import com.google.caja.parser.css.CssTree;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.AbstractContainerConfig;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.parse.caja.CajaCssParser;
import org.apache.shindig.gadgets.parse.caja.CajaCssSanitizer;
import org.apache.shindig.gadgets.render.SanitizingProxyUriManager;
import org.apache.shindig.gadgets.uri.DefaultProxyUriManager;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.junit.Before;
import org.junit.Test;

public class CajaCssSanitizerTest
extends EasyMockTestCase {
    private CajaCssParser parser;
    private CajaCssSanitizer sanitizer;
    private final Uri DUMMY = Uri.parse((String)"http://www.example.org/base");
    private SanitizingProxyUriManager importRewriter;
    private SanitizingProxyUriManager imageRewriter;
    private GadgetContext gadgetContext;
    public static final String MOCK_CONTAINER = "mockContainer";

    @Before
    public void setUp() throws Exception {
        this.parser = new CajaCssParser();
        this.sanitizer = new CajaCssSanitizer(this.parser);
        FakeContainerConfig config = new FakeContainerConfig();
        DefaultProxyUriManager proxyUriManager = new DefaultProxyUriManager((ContainerConfig)config, null);
        this.importRewriter = new SanitizingProxyUriManager((ProxyUriManager)proxyUriManager, "text/css");
        this.imageRewriter = new SanitizingProxyUriManager((ProxyUriManager)proxyUriManager, "image/*");
        this.gadgetContext = new GadgetContext(){

            public String getContainer() {
                return CajaCssSanitizerTest.MOCK_CONTAINER;
            }
        };
    }

    @Test
    public void testPreserveSafe() throws Exception {
        String css = ".xyz { font: bold;} A { color: #7f7f7f}";
        CssTree.StyleSheet styleSheet = this.parser.parseDom(css);
        this.sanitizer.sanitize((CssTree)styleSheet, this.DUMMY, this.gadgetContext, (ProxyUriManager)this.importRewriter, (ProxyUriManager)this.imageRewriter);
        this.assertStyleEquals(css, styleSheet);
    }

    @Test
    public void testSanitizeFunctionCall() throws Exception {
        String css = ".xyz { font : iamevil(bold); }";
        CssTree.StyleSheet styleSheet = this.parser.parseDom(css);
        this.sanitizer.sanitize((CssTree)styleSheet, this.DUMMY, this.gadgetContext, (ProxyUriManager)this.importRewriter, (ProxyUriManager)this.imageRewriter);
        this.assertStyleEquals(".xyz {}", styleSheet);
    }

    @Test
    public void testSanitizeUnsafeProperties() throws Exception {
        String css = ".xyz { behavior: url('xyz.htc'); -moz-binding:url(\"http://ha.ckers.org/xssmoz.xml#xss\") }";
        CssTree.StyleSheet styleSheet = this.parser.parseDom(css);
        this.sanitizer.sanitize((CssTree)styleSheet, this.DUMMY, this.gadgetContext, (ProxyUriManager)this.importRewriter, (ProxyUriManager)this.imageRewriter);
        this.assertStyleEquals(".xyz {}", styleSheet);
    }

    @Test
    public void testSanitizeScriptUrls() throws Exception {
        String css = ".xyz { background: url('javascript:doevill'); background : url(vbscript:moreevil); }";
        CssTree.StyleSheet styleSheet = this.parser.parseDom(css);
        this.sanitizer.sanitize((CssTree)styleSheet, this.DUMMY, this.gadgetContext, (ProxyUriManager)this.importRewriter, (ProxyUriManager)this.imageRewriter);
        this.assertStyleEquals(".xyz {}", styleSheet);
    }

    @Test
    public void testProxyUrls() throws Exception {
        String css = ".xyz { background: url('http://www.example.org/img.gif');}";
        CssTree.StyleSheet styleSheet = this.parser.parseDom(css);
        this.sanitizer.sanitize((CssTree)styleSheet, this.DUMMY, this.gadgetContext, (ProxyUriManager)this.importRewriter, (ProxyUriManager)this.imageRewriter);
        this.assertStyleEquals(".xyz { background: url('//www.mock.com/dir/proxy?container=mockContainer&gadget=http%3A%2F%2Fwww.example.org%2Fbase&debug=0&nocache=0&url=http%3A%2F%2Fwww.example.org%2Fimg.gif&sanitize=1&rewriteMime=image%2F%2a');}", styleSheet);
    }

    @Test
    public void testUrlEscapingMockContainer() throws Exception {
        String css = ".xyz { background: url('http://www.example.org/img.gif');}";
        CssTree.StyleSheet styleSheet = this.parser.parseDom(css);
        this.sanitizer.sanitize((CssTree)styleSheet, this.DUMMY, this.gadgetContext, (ProxyUriManager)this.importRewriter, (ProxyUriManager)this.imageRewriter);
        CajaCssSanitizerTest.assertEquals((Object)".xyz{background:url('//www.mock.com/dir/proxy?container=mockContainer&gadget=http%3A%2F%2Fwww.example.org%2Fbase&debug=0&nocache=0&url=http%3A%2F%2Fwww.example.org%2Fimg.gif&sanitize=1&rewriteMime=image%2F%2a');}", (Object)this.parser.serialize(styleSheet).replaceAll("\\s", ""));
    }

    @Test
    public void testUrlEscapingDefaultContainer() throws Exception {
        String css = ".xyz { background: url('http://www.example.org/img.gif');}";
        CssTree.StyleSheet styleSheet = this.parser.parseDom(css);
        GadgetContext gadgetContext = new GadgetContext(){

            public String getContainer() {
                return "default";
            }
        };
        this.sanitizer.sanitize((CssTree)styleSheet, this.DUMMY, gadgetContext, (ProxyUriManager)this.importRewriter, (ProxyUriManager)this.imageRewriter);
        CajaCssSanitizerTest.assertEquals((Object)".xyz{background:url('//www.test.com/dir/proxy?container=default&gadget=http%3A%2F%2Fwww.example.org%2Fbase&debug=0&nocache=0&url=http%3A%2F%2Fwww.example.org%2Fimg.gif&sanitize=1&rewriteMime=image%2F%2a');}", (Object)this.parser.serialize(styleSheet).replaceAll("\\s", ""));
    }

    public void assertStyleEquals(String expected, CssTree.StyleSheet styleSheet) throws Exception {
        CajaCssSanitizerTest.assertEquals((Object)this.parser.serialize(this.parser.parseDom(expected)), (Object)this.parser.serialize(styleSheet));
    }

    private static class FakeContainerConfig
    extends AbstractContainerConfig {
        private Map<String, Map<String, Object>> containers = new HashMap<String, Map<String, Object>>();

        private FakeContainerConfig() {
            this.containers.put("default", (Map<String, Object>)ImmutableMap.builder().put((Object)"gadgets.uri.proxy.host", (Object)"www.test.com").put((Object)"gadgets.uri.proxy.path", (Object)"/dir/proxy").build());
            this.containers.put(CajaCssSanitizerTest.MOCK_CONTAINER, (Map<String, Object>)ImmutableMap.builder().put((Object)"gadgets.uri.proxy.host", (Object)"www.mock.com").build());
        }

        public Object getProperty(String container, String name) {
            Map<String, Object> data = this.containers.get(container);
            if (!data.containsKey(name)) {
                data = this.containers.get("default");
            }
            return data.get(name);
        }
    }
}

