/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.process;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.config.JsonContainerConfig;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetBlacklist;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.variables.VariableSubstituter;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessorTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/gadget.xml");
    private static final Uri TYPE_URL_HREF = Uri.parse((String)"http://example.org/gadget.php");
    private static final String BASIC_HTML_CONTENT = "Hello, World!";
    protected static final String GADGET = "<Module> <ModulePrefs title='foo'/> <Content view='html' type='html'>Hello, World!</Content> <Content view='url' type='url' href='" + TYPE_URL_HREF + "'/>" + " <Content view='alias' type='html'>" + "Hello, World!" + "</Content>" + "</Module>";
    private final FakeGadgetSpecFactory gadgetSpecFactory = new FakeGadgetSpecFactory();
    private final FakeVariableSubstituter substituter = new FakeVariableSubstituter();
    private final FakeBlacklist blacklist = new FakeBlacklist();
    private ContainerConfig containerConfig;
    private Processor processor;

    @Before
    public void setUp() throws Exception {
        JSONObject config = new JSONObject("{default:{'gadgets.features':{views:{aliased: {aliases: ['some-alias', 'alias']}}}}}");
        this.containerConfig = new JsonContainerConfig(config, Expressions.forTesting());
        this.processor = new Processor((GadgetSpecFactory)this.gadgetSpecFactory, (VariableSubstituter)this.substituter, this.containerConfig, (GadgetBlacklist)this.blacklist, null);
    }

    private GadgetContext makeContext(final String view, final Uri specUrl) {
        return new GadgetContext(){

            public Uri getUrl() {
                if (specUrl == null) {
                    return null;
                }
                return specUrl;
            }

            public String getView() {
                return view;
            }
        };
    }

    private GadgetContext makeContext(String view) {
        return this.makeContext(view, SPEC_URL);
    }

    @Test
    public void normalProcessing() throws Exception {
        Gadget gadget = this.processor.process(this.makeContext("html"));
        Assert.assertEquals((Object)BASIC_HTML_CONTENT, (Object)gadget.getCurrentView().getContent());
    }

    @Test(expected=ProcessingException.class)
    public void handlesGadgetExceptionGracefully() throws Exception {
        this.gadgetSpecFactory.exception = new GadgetException(GadgetException.Code.INVALID_PATH);
        this.processor.process(this.makeContext("url"));
    }

    @Test
    public void doViewAliasing() throws Exception {
        Gadget gadget = this.processor.process(this.makeContext("aliased"));
        Assert.assertEquals((Object)BASIC_HTML_CONTENT, (Object)gadget.getCurrentView().getContent());
    }

    @Test
    public void noSupportedViewHasNoCurrentView() throws Exception {
        Gadget gadget = this.processor.process(this.makeContext("not-real-view"));
        Assert.assertNull((Object)gadget.getCurrentView());
    }

    @Test
    public void substitutionsPerformedTypeHtml() throws Exception {
        this.processor.process(this.makeContext("html"));
        Assert.assertTrue((String)"Substitutions not performed", (boolean)this.substituter.wasSubstituted);
    }

    @Test
    public void substitutionsPerformedTypeUrl() throws Exception {
        this.processor.process(this.makeContext("url"));
        Assert.assertTrue((String)"Substitutions not performed", (boolean)this.substituter.wasSubstituted);
    }

    @Test
    public void blacklistChecked() throws Exception {
        this.processor.process(this.makeContext("url"));
        Assert.assertTrue((String)"Blacklist not checked", (boolean)this.blacklist.wasChecked);
    }

    @Test
    public void blacklistedGadgetThrows() throws Exception {
        this.blacklist.isBlacklisted = true;
        try {
            this.processor.process(this.makeContext("html"));
            Assert.fail((String)"expected ProcessingException");
        }
        catch (ProcessingException e) {
            Assert.assertEquals((long)403L, (long)e.getHttpStatusCode());
        }
    }

    @Test
    public void nullUrlThrows() throws Exception {
        try {
            this.processor.process(this.makeContext("html", null));
            Assert.fail((String)"expected ProcessingException");
        }
        catch (ProcessingException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpStatusCode());
        }
    }

    @Test
    public void nonHttpOrHttpsThrows() throws Exception {
        try {
            this.processor.process(this.makeContext("html", Uri.parse((String)"file://foo")));
            Assert.fail((String)"expected ProcessingException");
        }
        catch (ProcessingException e) {
            Assert.assertEquals((long)403L, (long)e.getHttpStatusCode());
        }
    }

    private static class FakeVariableSubstituter
    extends VariableSubstituter {
        protected boolean wasSubstituted;

        protected FakeVariableSubstituter() {
            super((List)Lists.newArrayList());
        }

        public GadgetSpec substitute(GadgetContext context, GadgetSpec spec) {
            this.wasSubstituted = true;
            return spec;
        }
    }

    private static class FakeGadgetSpecFactory
    implements GadgetSpecFactory {
        protected GadgetException exception;

        protected FakeGadgetSpecFactory() {
        }

        public GadgetSpec getGadgetSpec(GadgetContext context) throws GadgetException {
            if (this.exception != null) {
                throw this.exception;
            }
            return new GadgetSpec(context.getUrl(), GADGET);
        }
    }

    private static class FakeBlacklist
    implements GadgetBlacklist {
        protected boolean wasChecked;
        protected boolean isBlacklisted;

        protected FakeBlacklist() {
        }

        public boolean isBlacklisted(Uri gadgetUri) {
            this.wasChecked = true;
            return this.isBlacklisted;
        }
    }
}

