/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.shindig.gadgets.http.BasicHttpFetcher;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.render.DefaultRpcServiceLookup;
import org.apache.shindig.gadgets.render.DefaultServiceFetcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRpcServiceLookupTest
extends Assert {
    private DefaultRpcServiceLookup svcLookup;
    private String socialEndpoint;
    private String host;

    @Before
    public void setUp() throws Exception {
        this.svcLookup = new DefaultRpcServiceLookup(new DefaultServiceFetcher(null, (HttpFetcher)new BasicHttpFetcher(null)), Long.valueOf(60L));
        this.socialEndpoint = "http://localhost:8080/social/rpc";
        this.host = "localhost:8080";
    }

    @Test
    public void testGetServicesForContainer_Empty() throws Exception {
        String container = "ig";
        Multimap services = this.svcLookup.getServicesFor(container, this.host);
        DefaultRpcServiceLookupTest.assertEquals((long)0L, (long)services.size());
    }

    @Test
    public void testGetServicesForContainer_Null() throws Exception {
        String container = null;
        Multimap services = this.svcLookup.getServicesFor(container, this.host);
        DefaultRpcServiceLookupTest.assertEquals((long)0L, (long)services.size());
    }

    @Test
    public void testGetServicesForContainer_OneContainerOneService() throws Exception {
        ImmutableSet expectedServiceMethods = ImmutableSet.of((Object)"system.listMethods");
        LinkedHashMultimap expectedServices = LinkedHashMultimap.create();
        expectedServices.putAll((Object)this.socialEndpoint, (Iterable)expectedServiceMethods);
        String container = "ig";
        this.svcLookup.setServicesFor(container, (Multimap)expectedServices);
        Multimap actualServices = this.svcLookup.getServicesFor(container, this.host);
        DefaultRpcServiceLookupTest.assertEquals((long)1L, (long)actualServices.size());
        DefaultRpcServiceLookupTest.assertTrue((boolean)actualServices.containsKey((Object)this.socialEndpoint));
        Set actualServiceMethods = (Set)actualServices.get((Object)this.socialEndpoint);
        DefaultRpcServiceLookupTest.assertEquals((Object)expectedServiceMethods, (Object)actualServiceMethods);
    }

    @Test
    public void testGetServicesForContainer_OneContainerTwoServices() throws Exception {
        HashSet expectedServiceMethods = Sets.newHashSet((Object[])new String[]{"system.listMethods", "people.get", "people.update", "people.create", "people.delete"});
        LinkedHashMultimap expectedServices = LinkedHashMultimap.create();
        expectedServices.putAll((Object)this.socialEndpoint, (Iterable)expectedServiceMethods);
        String container = "ig";
        this.svcLookup.setServicesFor(container, (Multimap)expectedServices);
        this.assertServiceHasCorrectConfig(this.socialEndpoint, expectedServiceMethods, container, 1);
    }

    @Test
    public void testGetServiceForContainer_TwoContainersOneEndpoint() throws Exception {
        String socialEndpoint2 = "http://localhost:8080/api/rpc";
        HashSet expectedServiceMethods = Sets.newHashSet((Object[])new String[]{"system.listMethods", "people.get", "people.update", "people.create", "people.delete"});
        HashSet expectedServiceMethods2 = Sets.newHashSet((Object[])new String[]{"cache.invalidate"});
        LinkedHashMultimap expectedServices = LinkedHashMultimap.create();
        expectedServices.putAll((Object)this.socialEndpoint, (Iterable)expectedServiceMethods);
        LinkedHashMultimap expectedServices2 = LinkedHashMultimap.create();
        expectedServices2.putAll((Object)socialEndpoint2, (Iterable)expectedServiceMethods2);
        String container = "ig";
        String container2 = "gm";
        this.svcLookup.setServicesFor(container, (Multimap)expectedServices);
        this.svcLookup.setServicesFor(container2, (Multimap)expectedServices2);
        this.assertServiceHasCorrectConfig(this.socialEndpoint, expectedServiceMethods, container, 1);
        this.assertServiceHasCorrectConfig(socialEndpoint2, expectedServiceMethods2, container2, 1);
    }

    private void assertServiceHasCorrectConfig(String socialEndpoint, Set<String> expectedServiceMethods, String container, int expectedServiceCount) {
        Multimap actualServices = this.svcLookup.getServicesFor(container, this.host);
        DefaultRpcServiceLookupTest.assertEquals((long)expectedServiceCount, (long)actualServices.keySet().size());
        DefaultRpcServiceLookupTest.assertTrue((boolean)actualServices.containsKey((Object)socialEndpoint));
        Set actualServiceMethods = (Set)actualServices.get((Object)socialEndpoint);
        DefaultRpcServiceLookupTest.assertEquals(expectedServiceMethods, (Object)actualServiceMethods);
    }
}

