/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.PreloaderService;
import org.apache.shindig.gadgets.render.GadgetRewritersProvider;
import org.apache.shindig.gadgets.render.HtmlRenderer;
import org.apache.shindig.gadgets.render.ProxyRenderer;
import org.apache.shindig.gadgets.render.RenderingException;
import org.apache.shindig.gadgets.rewrite.CaptureRewriter;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HtmlRendererTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/gadget.xml");
    private static final String BASIC_HTML_CONTENT = "Hello, World!";
    private static final String PROXIED_HTML_CONTENT = "Hello, Universe!";
    private static final Uri PROXIED_HTML_HREF = Uri.parse((String)"http://example.org/proxied.php");
    private static final GadgetContext CONTEXT = new GadgetContext(){

        public SecurityToken getToken() {
            return new AnonymousSecurityToken();
        }
    };
    private final FakePreloaderService preloaderService = new FakePreloaderService();
    private final FakeProxyRenderer proxyRenderer = new FakeProxyRenderer();
    private final CaptureRewriter captureRewriter = new CaptureRewriter();
    private HtmlRenderer renderer;

    private Gadget makeGadget(String content) throws GadgetException {
        GadgetSpec spec = new GadgetSpec(SPEC_URL, "<Module><ModulePrefs title=''/><Content><![CDATA[" + content + "]]></Content></Module>");
        return new Gadget().setSpec(spec).setContext(CONTEXT).setCurrentView(spec.getView("default"));
    }

    private Gadget makeHrefGadget(String authz) throws Exception {
        Gadget gadget = this.makeGadget("");
        String doc = "<Content href='" + PROXIED_HTML_HREF + "' authz='" + authz + "'/>";
        View view = new View("proxied", Arrays.asList(XmlUtil.parse((String)doc)), SPEC_URL);
        gadget.setCurrentView(view);
        return gadget;
    }

    @Before
    public void setUp() throws Exception {
        this.renderer = new HtmlRenderer((PreloaderService)this.preloaderService, (ProxyRenderer)this.proxyRenderer, new GadgetRewritersProvider((List)ImmutableList.of((Object)this.captureRewriter)), null);
    }

    @Test
    public void renderPlainTypeHtml() throws Exception {
        String content = this.renderer.render(this.makeGadget(BASIC_HTML_CONTENT));
        Assert.assertEquals((Object)BASIC_HTML_CONTENT, (Object)content);
    }

    @Test
    public void renderProxied() throws Exception {
        String content = this.renderer.render(this.makeHrefGadget("none"));
        Assert.assertEquals((Object)PROXIED_HTML_CONTENT, (Object)content);
    }

    @Test
    public void doPreloading() throws Exception {
        this.renderer.render(this.makeGadget(BASIC_HTML_CONTENT));
        Assert.assertTrue((String)"Preloading not performed.", (boolean)this.preloaderService.wasPreloaded);
    }

    @Test
    public void doRewriting() throws Exception {
        this.renderer.render(this.makeGadget(BASIC_HTML_CONTENT));
        Assert.assertTrue((String)"Rewriting not performed.", (boolean)this.captureRewriter.viewWasRewritten());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FakePreloaderService
    implements PreloaderService {
        protected boolean wasPreloaded;
        protected Collection<PreloadedData> preloads;

        protected FakePreloaderService() {
        }

        public Collection<PreloadedData> preload(Gadget gadget) {
            this.wasPreloaded = true;
            return this.preloads;
        }

        public Collection<PreloadedData> preload(Collection<Callable<PreloadedData>> tasks) {
            this.wasPreloaded = true;
            return this.preloads;
        }
    }

    private static class FakeProxyRenderer
    extends ProxyRenderer {
        public FakeProxyRenderer() {
            super(null, null, null);
        }

        public String render(Gadget gadget) throws RenderingException, GadgetException {
            return HtmlRendererTest.PROXIED_HTML_CONTENT;
        }
    }
}

