/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.render.SanitizingProxyUriManager;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SanitizingProxyUriManagerTest {
    private ProxyUriManager uriManager;
    private Uri uri;
    private ProxyUriManager.ProxyUri proxyUri;

    @Before
    public void setUp() throws Exception {
        this.uriManager = (ProxyUriManager)EasyMock.createMock(ProxyUriManager.class);
        this.uri = new UriBuilder().setScheme("http").setAuthority("host.com").setPath("/path").toUri();
        this.proxyUri = (ProxyUriManager.ProxyUri)EasyMock.createMock(ProxyUriManager.ProxyUri.class);
    }

    @Test
    public void processPassesThrough() throws Exception {
        Capture uriCapture = new Capture();
        EasyMock.expect((Object)this.uriManager.process((Uri)EasyMock.capture((Capture)uriCapture))).andReturn((Object)this.proxyUri).once();
        EasyMock.replay((Object[])new Object[]{this.uriManager});
        SanitizingProxyUriManager rewriter = this.makeRewriter(null);
        ProxyUriManager.ProxyUri returned = rewriter.process(this.uri);
        EasyMock.verify((Object[])new Object[]{this.uriManager});
        Assert.assertSame((Object)this.uri, (Object)uriCapture.getValue());
        Assert.assertSame((Object)returned, (Object)this.proxyUri);
    }

    @Test
    public void makeSingleNoMime() throws Exception {
        Capture uriCapture = new Capture();
        Capture intCapture = new Capture();
        ArrayList input = Lists.newArrayList((Object[])new ProxyUriManager.ProxyUri[]{this.proxyUri});
        ArrayList output = Lists.newArrayList((Object[])new Uri[]{this.uri});
        Integer refresh = new Integer(0);
        EasyMock.expect((Object)this.uriManager.make((List)EasyMock.capture((Capture)uriCapture), Integer.valueOf(EasyMock.capture((Capture)intCapture)))).andReturn((Object)output).once();
        EasyMock.replay((Object[])new Object[]{this.uriManager});
        SanitizingProxyUriManager rewriter = this.makeRewriter(null);
        List returned = rewriter.make((List)input, refresh);
        EasyMock.verify((Object[])new Object[]{this.uriManager});
        Assert.assertSame((Object)uriCapture.getValue(), (Object)input);
        Assert.assertSame((Object)intCapture.getValue(), (Object)refresh);
        Assert.assertEquals((long)1L, (long)returned.size());
        Assert.assertEquals((Object)"1", (Object)((Uri)returned.get(0)).getQueryParameter(UriCommon.Param.SANITIZE.getKey()));
        Assert.assertNull((Object)((Uri)returned.get(0)).getQueryParameter(UriCommon.Param.REWRITE_MIME_TYPE.getKey()));
    }

    @Test
    public void makeSingleExpectedMime() throws Exception {
        Capture uriCapture = new Capture();
        Capture intCapture = new Capture();
        ArrayList input = Lists.newArrayList((Object[])new ProxyUriManager.ProxyUri[]{this.proxyUri});
        ArrayList output = Lists.newArrayList((Object[])new Uri[]{this.uri});
        Integer refresh = new Integer(0);
        String mime = "my/mime";
        EasyMock.expect((Object)this.uriManager.make((List)EasyMock.capture((Capture)uriCapture), Integer.valueOf(EasyMock.capture((Capture)intCapture)))).andReturn((Object)output).once();
        EasyMock.replay((Object[])new Object[]{this.uriManager});
        SanitizingProxyUriManager rewriter = this.makeRewriter(mime);
        List returned = rewriter.make((List)input, refresh);
        EasyMock.verify((Object[])new Object[]{this.uriManager});
        Assert.assertSame((Object)uriCapture.getValue(), (Object)input);
        Assert.assertSame((Object)intCapture.getValue(), (Object)refresh);
        Assert.assertEquals((long)1L, (long)returned.size());
        Assert.assertEquals((Object)"1", (Object)((Uri)returned.get(0)).getQueryParameter(UriCommon.Param.SANITIZE.getKey()));
        Assert.assertEquals((Object)mime, (Object)((Uri)returned.get(0)).getQueryParameter(UriCommon.Param.REWRITE_MIME_TYPE.getKey()));
    }

    @Test
    public void makeList() throws Exception {
        Capture uriCapture = new Capture();
        Capture intCapture = new Capture();
        ArrayList input = Lists.newArrayList((Object[])new ProxyUriManager.ProxyUri[]{this.proxyUri});
        Uri uri2 = new UriBuilder().toUri();
        ArrayList output = Lists.newArrayList((Object[])new Uri[]{this.uri, uri2});
        Integer refresh = new Integer(0);
        String mime = "my/mime";
        EasyMock.expect((Object)this.uriManager.make((List)EasyMock.capture((Capture)uriCapture), Integer.valueOf(EasyMock.capture((Capture)intCapture)))).andReturn((Object)output).once();
        EasyMock.replay((Object[])new Object[]{this.uriManager});
        SanitizingProxyUriManager rewriter = this.makeRewriter(mime);
        List returned = rewriter.make((List)input, refresh);
        EasyMock.verify((Object[])new Object[]{this.uriManager});
        Assert.assertSame((Object)uriCapture.getValue(), (Object)input);
        Assert.assertSame((Object)intCapture.getValue(), (Object)refresh);
        Assert.assertEquals((long)2L, (long)returned.size());
        Assert.assertEquals((Object)"1", (Object)((Uri)returned.get(0)).getQueryParameter(UriCommon.Param.SANITIZE.getKey()));
        Assert.assertEquals((Object)mime, (Object)((Uri)returned.get(0)).getQueryParameter(UriCommon.Param.REWRITE_MIME_TYPE.getKey()));
        Assert.assertEquals((Object)"1", (Object)((Uri)returned.get(1)).getQueryParameter(UriCommon.Param.SANITIZE.getKey()));
        Assert.assertEquals((Object)mime, (Object)((Uri)returned.get(1)).getQueryParameter(UriCommon.Param.REWRITE_MIME_TYPE.getKey()));
    }

    private SanitizingProxyUriManager makeRewriter(String mime) {
        return new SanitizingProxyUriManager(this.uriManager, mime);
    }
}

