/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.caja.CajaHtmlParser;
import org.apache.shindig.gadgets.rewrite.BaseTagRemoverRewriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseTagRemoverRewriterTest {
    BaseTagRemoverRewriter rewriter;
    CajaHtmlParser parser;
    ParseModule.DOMImplementationProvider domImpl;

    @Before
    public void setUp() {
        this.rewriter = new BaseTagRemoverRewriter();
        this.domImpl = new ParseModule.DOMImplementationProvider();
        this.parser = new CajaHtmlParser(this.domImpl.get());
    }

    @Test
    public void testRemoveBaseTag() throws Exception {
        String content = "<html><head><base href='http://www.ppq.com/'></head><body><img src='/img1.png'></body></html>";
        String expected = "<html><head></head><body><img src=\"/img1.png\"></body></html>";
        HttpRequest req = new HttpRequest(Uri.parse((String)"http://www.google.com/"));
        HttpResponse resp = new HttpResponseBuilder().setHttpStatusCode(200).setHeader("Content-Type", "text/html").setResponse(content.getBytes()).create();
        HttpResponseBuilder builder = new HttpResponseBuilder((GadgetHtmlParser)this.parser, resp);
        this.rewriter.rewrite(req, builder);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)builder.getContent()));
    }

    @Test
    public void testNoBaseTag() throws Exception {
        String content = "<html><head></head><body><img src='/img1.png'></body></html>";
        String expected = "<html><head></head><body><img src=\"/img1.png\"></body></html>";
        HttpRequest req = new HttpRequest(Uri.parse((String)"http://www.google.com/"));
        HttpResponse resp = new HttpResponseBuilder().setHttpStatusCode(200).setHeader("Content-Type", "text/html").setResponse(content.getBytes()).create();
        HttpResponseBuilder builder = new HttpResponseBuilder((GadgetHtmlParser)this.parser, resp);
        this.rewriter.rewrite(req, builder);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)builder.getContent()));
    }

    @Test
    public void testContentTypeString() throws Exception {
        String content = "Hello world. My name is gagan<html><head><base href='http://hello.com/'></head><body><img src='/img1.png'></body></html>";
        String expected = "Hello world. My name is gagan<html><head><base href='http://hello.com/'></head><body><img src='/img1.png'></body></html>";
        HttpRequest req = new HttpRequest(Uri.parse((String)"http://www.google.com/"));
        HttpResponse resp = new HttpResponseBuilder().setHttpStatusCode(200).setHeader("Content-Type", "text/plain").setResponse(content.getBytes()).create();
        HttpResponseBuilder builder = new HttpResponseBuilder((GadgetHtmlParser)this.parser, resp);
        this.rewriter.rewrite(req, builder);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)builder.getContent()));
    }

    @Test
    public void testContentTypeXml() throws Exception {
        String content = "Hello world. My name is gagan<html><head><base href='http://hello.com/'></head><body><img src='/img1.png'></body></html>";
        String expected = "Hello world. My name is gagan<html><head><base href='http://hello.com/'></head><body><img src='/img1.png'></body></html>";
        HttpRequest req = new HttpRequest(Uri.parse((String)"http://www.google.com/"));
        HttpResponse resp = new HttpResponseBuilder().setHttpStatusCode(200).setHeader("Content-Type", "text/xml").setResponse(content.getBytes()).create();
        HttpResponseBuilder builder = new HttpResponseBuilder((GadgetHtmlParser)this.parser, resp);
        this.rewriter.rewrite(req, builder);
        Assert.assertEquals((Object)StringUtils.deleteWhitespace((String)expected), (Object)StringUtils.deleteWhitespace((String)builder.getContent()));
    }
}

