/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Sets;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.junit.Assert;
import org.junit.Test;

public class ContentRewriterFeatureTestCaseOS9
extends BaseRewriterTestCase {
    @Test
    public void testSpecExcludeOverridesContainerDefaultInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewriteOS9(new String[]{""}, new String[]{"*"}, "0", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig(".*", "", "0", "embed,img,script,link,style", false, false));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecExcludeOverridesMultipleContainerDefaultInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewriteOS9(null, new String[]{"foo", "bar"}, "0", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig(".*", "", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.foo.com"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.bar.com"));
    }

    @Test
    public void testSpecExcludeOnlyOverridesContainerDefaultInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewriteOS9(null, new String[]{"*"}, null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig(".*", "", "0", "embed,img,script,link,style", false, false));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecExcludeOverridesContainerDefaultExclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewriteOS9(new String[]{"*"}, new String[]{""}, "0", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", ".*", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testExcludeOverridesInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewriteOS9(new String[]{"test.com"}, new String[]{"test"}, "0", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testIncludeOnlyMatch() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewriteOS9(new String[]{"test.com"}, new String[]{"testx"}, "0", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://testx.test.com"));
    }

    @Test
    public void testSpecEmptyContainerWithExclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewriteOS9(null, null, null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig(".*", "test", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.foobar.com"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecExcludeOnlyOverridesContainerWithExclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewriteOS9(null, new String[]{""}, null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig(".*", "test", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.foobar.com"));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecEmptyDoesNotOverridesContainerDefaultNoInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewriteOS9(null, null, null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "test", "0", "embed,img,script,link,style", false, false));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.foobar.com"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecIncludeOnlyOverridesContainerDefaultNoInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewriteOS9(new String[]{"*"}, null, null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "test", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.foobar.com"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecIncludeMultipleOnlyOverridesContainerDefaultNoInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewriteOS9(new String[]{"foo", "bar"}, null, null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "test", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.foo.com"));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.bar.com"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecIncludeMultipleOnlyOverridesContainerDefaultInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewriteOS9(new String[]{"foo", "bar"}, null, null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("*", "test", "0", "embed,img,script,link,style", false, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.foo.com"));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.bar.com"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecExcludeDisallowOverrideIncludeUrls() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewrite("norewrite", null, null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("^http://www.include.com", "def", "3600", "embed,img,script,link,style", true, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.include.com/abc"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.include.com/def"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.norewrite.com/abc"));
    }

    @Test
    public void testSpecExcludeOverrideExcludeUrls() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewrite(null, "abc", null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("^http://www.include.com", "def", "3600", "embed,img,script,link,style", true, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.include.com/abc"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.norewrite.com/abc"));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.include.com/def"));
    }

    @Test
    public void testSpecExcludeDisallowOverrideIncludeUrlOS9() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewriteOS9(new String[]{"abc"}, null, null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("^http://www.include.com", "", "3600", "embed,img,script,link,style", true, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.include.com/abc"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.norewrite.com/abc"));
    }

    @Test
    public void testSpecExcludeDisallowOverrideExcludeUrlOS9() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewriteOS9(null, new String[]{"def"}, null, null), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("^http://www.include.com", "", "3600", "embed,img,script,link,style", true, false));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.include.com/abc"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.include.com/def"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.norewrite.com/abc"));
    }

    @Test
    public void testSpecExcludeDisallowOverrideDefaultExpires() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewrite("test\\.com", "testx", "3000", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "", "", "embed,img,script,link,style", true, false));
        Assert.assertNotNull((Object)this.defaultRewriterFeature.getExpires());
        Assert.assertNotNull((Object)(this.defaultRewriterFeature.getExpires() == 3000 ? 1 : 0));
    }

    @Test
    public void testSpecExcludeDisallowOverrideExpiresGreater() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewrite("test\\.com", "testx", "8000", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "", "3000", "embed,img,script,link,style", true, false));
        Assert.assertNotNull((Object)this.defaultRewriterFeature.getExpires());
        Assert.assertNotNull((Object)(this.defaultRewriterFeature.getExpires() == 3000 ? 1 : 0));
    }

    @Test
    public void testSpecExcludeDisallowOverrideExpiresLesser() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewrite("test\\.com", "testx", "2000", this.tags), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "", "3000", "embed,img,script,link,style", true, false));
        Assert.assertNotNull((Object)this.defaultRewriterFeature.getExpires());
        Assert.assertNotNull((Object)(this.defaultRewriterFeature.getExpires() == 2000 ? 1 : 0));
    }

    @Test
    public void testSpecExcludeDisallowOverrideTagsSubset() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewrite("test\\.com", "testx", "0", Sets.newHashSet((Object[])new String[]{"img"})), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "", "0", "img,script", true, false));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("IFRAME"));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteTag("img"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("ScripT"));
    }

    @Test
    public void testSpecExcludeDisallowOverrideTagsSuperset() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature.Config(ContentRewriterFeatureTestCaseOS9.createSpecWithRewrite("test\\.com", "testx", "0", Sets.newHashSet((Object[])new String[]{"img", "script", "link"})), (ContentRewriterFeature.Config)new ContentRewriterFeature.DefaultConfig("", "", "0", "img,script", true, false));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("IFRAME"));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteTag("img"));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteTag("ScripT"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("link"));
    }
}

