/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.DomWalkerTestBase;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Node;

public class DomWalkerTest
extends DomWalkerTestBase {
    private Node root;
    private Node child1;
    private Node child2;
    private Node subchild1;
    private Node text1;
    private Node text2;

    @Before
    public void setUp() {
        super.setUp();
        this.root = this.doc.createElement("root");
        this.child1 = this.doc.createElement("child1");
        this.text1 = this.doc.createTextNode("text1");
        this.child1.appendChild(this.text1);
        this.root.appendChild(this.child1);
        this.child2 = this.doc.createElement("child2");
        this.subchild1 = this.doc.createElement("subchild1");
        this.text2 = this.doc.createTextNode("text2");
        this.subchild1.appendChild(this.text2);
        this.child2.appendChild(this.subchild1);
        this.root.appendChild(this.child2);
        this.doc.appendChild(this.root);
    }

    @Test
    public void allBypassDoesNothing() throws Exception {
        Gadget gadget = this.gadget();
        DomWalker.Visitor visitor = (DomWalker.Visitor)EasyMock.createMock(DomWalker.Visitor.class);
        EasyMock.expect((Object)visitor.visit(gadget, this.root)).andReturn((Object)DomWalker.Visitor.VisitStatus.BYPASS).once();
        EasyMock.expect((Object)visitor.visit(gadget, this.child1)).andReturn((Object)DomWalker.Visitor.VisitStatus.BYPASS).once();
        EasyMock.expect((Object)visitor.visit(gadget, this.child2)).andReturn((Object)DomWalker.Visitor.VisitStatus.BYPASS).once();
        EasyMock.expect((Object)visitor.visit(gadget, this.subchild1)).andReturn((Object)DomWalker.Visitor.VisitStatus.BYPASS).once();
        EasyMock.expect((Object)visitor.visit(gadget, this.text1)).andReturn((Object)DomWalker.Visitor.VisitStatus.BYPASS).once();
        EasyMock.expect((Object)visitor.visit(gadget, this.text2)).andReturn((Object)DomWalker.Visitor.VisitStatus.BYPASS).once();
        EasyMock.replay((Object[])new Object[]{visitor});
        MutableContent mc = this.getContent(0);
        DomWalker.Rewriter rewriter = this.getRewriter(visitor);
        rewriter.rewrite(gadget, mc);
        EasyMock.verify((Object[])new Object[]{mc});
    }

    @Test
    public void allMutateMutatesEveryTime() throws Exception {
        Gadget gadget = this.gadget();
        DomWalker.Visitor visitor = (DomWalker.Visitor)EasyMock.createMock(DomWalker.Visitor.class);
        EasyMock.expect((Object)visitor.visit(gadget, this.root)).andReturn((Object)DomWalker.Visitor.VisitStatus.MODIFY).once();
        EasyMock.expect((Object)visitor.visit(gadget, this.child1)).andReturn((Object)DomWalker.Visitor.VisitStatus.MODIFY).once();
        EasyMock.expect((Object)visitor.visit(gadget, this.child2)).andReturn((Object)DomWalker.Visitor.VisitStatus.MODIFY).once();
        EasyMock.expect((Object)visitor.visit(gadget, this.subchild1)).andReturn((Object)DomWalker.Visitor.VisitStatus.MODIFY).once();
        EasyMock.expect((Object)visitor.visit(gadget, this.text1)).andReturn((Object)DomWalker.Visitor.VisitStatus.MODIFY).once();
        EasyMock.expect((Object)visitor.visit(gadget, this.text2)).andReturn((Object)DomWalker.Visitor.VisitStatus.MODIFY).once();
        EasyMock.replay((Object[])new Object[]{visitor});
        MutableContent mc = this.getContent(6);
        DomWalker.Rewriter rewriter = this.getRewriter(visitor);
        rewriter.rewrite(gadget, mc);
        EasyMock.verify((Object[])new Object[]{mc});
    }

    @Test
    public void allReserveNodeReservesAll() throws Exception {
        Gadget gadget = this.gadget();
        DomWalker.Visitor visitor = (DomWalker.Visitor)EasyMock.createMock(DomWalker.Visitor.class);
        EasyMock.expect((Object)visitor.visit(gadget, this.root)).andReturn((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE).once();
        EasyMock.expect((Object)visitor.visit(gadget, this.child1)).andReturn((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE).once();
        EasyMock.expect((Object)visitor.visit(gadget, this.child2)).andReturn((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE).once();
        EasyMock.expect((Object)visitor.visit(gadget, this.subchild1)).andReturn((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE).once();
        EasyMock.expect((Object)visitor.visit(gadget, this.text1)).andReturn((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE).once();
        EasyMock.expect((Object)visitor.visit(gadget, this.text2)).andReturn((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE).once();
        ArrayList allReserved = Lists.newArrayList((Object[])new Node[]{this.root, this.child1, this.text1, this.child2, this.subchild1, this.text2});
        EasyMock.expect((Object)visitor.revisit(gadget, (List)allReserved)).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{visitor});
        MutableContent mc = this.getContent(1);
        DomWalker.Rewriter rewriter = this.getRewriter(visitor);
        rewriter.rewrite(gadget, mc);
        EasyMock.verify((Object[])new Object[]{mc});
    }

    @Test
    public void reserveRootPrecludesAllElse() throws Exception {
        Gadget gadget = this.gadget();
        DomWalker.Visitor visitor1 = (DomWalker.Visitor)EasyMock.createMock(DomWalker.Visitor.class);
        EasyMock.expect((Object)visitor1.visit(gadget, this.root)).andReturn((Object)DomWalker.Visitor.VisitStatus.RESERVE_TREE).once();
        ArrayList allReserved = Lists.newArrayList((Object[])new Node[]{this.root});
        EasyMock.expect((Object)visitor1.revisit(gadget, (List)allReserved)).andReturn((Object)true).once();
        DomWalker.Visitor visitor2 = (DomWalker.Visitor)EasyMock.createMock(DomWalker.Visitor.class);
        EasyMock.replay((Object[])new Object[]{visitor1, visitor2});
        MutableContent mc = this.getContent(1);
        DomWalker.Rewriter rewriter = this.getRewriter(visitor1, visitor2);
        rewriter.rewrite(gadget, mc);
        EasyMock.verify((Object[])new Object[]{mc});
    }

    @Test
    public void allMixedModes() throws Exception {
        Gadget gadget = this.gadget();
        DomWalker.Visitor visitor1 = (DomWalker.Visitor)EasyMock.createMock(DomWalker.Visitor.class);
        EasyMock.expect((Object)visitor1.visit(gadget, this.root)).andReturn((Object)DomWalker.Visitor.VisitStatus.BYPASS).once();
        EasyMock.expect((Object)visitor1.visit(gadget, this.child1)).andReturn((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE).once();
        EasyMock.expect((Object)visitor1.visit(gadget, this.text1)).andReturn((Object)DomWalker.Visitor.VisitStatus.BYPASS).once();
        EasyMock.expect((Object)visitor1.visit(gadget, this.child2)).andReturn((Object)DomWalker.Visitor.VisitStatus.BYPASS).once();
        EasyMock.expect((Object)visitor1.visit(gadget, this.subchild1)).andReturn((Object)DomWalker.Visitor.VisitStatus.BYPASS).once();
        ArrayList reserved1 = Lists.newArrayList((Object[])new Node[]{this.child1});
        EasyMock.expect((Object)visitor1.revisit(gadget, (List)reserved1)).andReturn((Object)false).once();
        DomWalker.Visitor visitor2 = (DomWalker.Visitor)EasyMock.createMock(DomWalker.Visitor.class);
        EasyMock.expect((Object)visitor2.visit(gadget, this.root)).andReturn((Object)DomWalker.Visitor.VisitStatus.BYPASS).once();
        EasyMock.expect((Object)visitor2.visit(gadget, this.text1)).andReturn((Object)DomWalker.Visitor.VisitStatus.BYPASS).once();
        EasyMock.expect((Object)visitor2.visit(gadget, this.child2)).andReturn((Object)DomWalker.Visitor.VisitStatus.BYPASS).once();
        EasyMock.expect((Object)visitor2.visit(gadget, this.subchild1)).andReturn((Object)DomWalker.Visitor.VisitStatus.RESERVE_TREE).once();
        ArrayList reserved2 = Lists.newArrayList((Object[])new Node[]{this.subchild1});
        EasyMock.expect((Object)visitor2.revisit(gadget, (List)reserved2)).andReturn((Object)true).once();
        DomWalker.Visitor visitor3 = (DomWalker.Visitor)EasyMock.createMock(DomWalker.Visitor.class);
        EasyMock.expect((Object)visitor3.visit(gadget, this.root)).andReturn((Object)DomWalker.Visitor.VisitStatus.BYPASS).once();
        EasyMock.expect((Object)visitor3.visit(gadget, this.text1)).andReturn((Object)DomWalker.Visitor.VisitStatus.BYPASS).once();
        EasyMock.expect((Object)visitor3.visit(gadget, this.child2)).andReturn((Object)DomWalker.Visitor.VisitStatus.MODIFY).once();
        EasyMock.replay((Object[])new Object[]{visitor1, visitor2, visitor3});
        MutableContent mc = this.getContent(2);
        DomWalker.Rewriter rewriter = this.getRewriter(visitor1, visitor2, visitor3);
        rewriter.rewrite(gadget, mc);
        EasyMock.verify((Object[])new Object[]{mc});
    }

    @Test
    public void rewriteThrowsRewritingExceptionIfGetDocumentIsNull() throws Exception {
        DomWalker.Visitor visitor1 = (DomWalker.Visitor)EasyMock.createMock(DomWalker.Visitor.class);
        DomWalker.Rewriter rewriter = this.getRewriter(visitor1);
        MutableContent mc = (MutableContent)EasyMock.createMock(MutableContent.class);
        EasyMock.expect((Object)mc.getDocument()).andReturn(null);
        EasyMock.expect((Object)mc.getContent()).andReturn((Object)"hello!");
        EasyMock.replay((Object[])new Object[]{mc});
        Gadget gadget = this.gadget();
        boolean exceptionCaught = false;
        try {
            rewriter.rewrite(gadget, mc);
        }
        catch (RewritingException e) {
            Assert.assertEquals((long)e.getHttpStatusCode(), (long)500L);
            exceptionCaught = true;
        }
        Assert.assertTrue((boolean)exceptionCaught);
    }

    private DomWalker.Rewriter getRewriter(DomWalker.Visitor ... visitors) {
        return new DomWalker.Rewriter((List)Lists.newArrayList((Object[])visitors));
    }

    private MutableContent getContent(int docChangedTimes) {
        MutableContent mc = (MutableContent)EasyMock.createMock(MutableContent.class);
        EasyMock.expect((Object)mc.getDocument()).andReturn((Object)this.doc).once();
        if (docChangedTimes > 0) {
            mc.documentChanged();
            EasyMock.expectLastCall().times(docChangedTimes);
        }
        EasyMock.replay((Object[])new Object[]{mc});
        return mc;
    }
}

