/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.DomWalkerTestBase;
import org.apache.shindig.gadgets.rewrite.ProxyingVisitor;
import org.apache.shindig.gadgets.rewrite.ResourceMutateVisitor;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProxyingVisitorTest
extends DomWalkerTestBase {
    private static final String URL_STRING = "http://www.foo.com/";
    private static final Map<String, String> ALL_RESOURCES = ResourceMutateVisitor.Tags.ALL_RESOURCES.getResourceTags();

    @Test
    public void imgVisitReserved() throws Exception {
        this.checkVisitReserved("img", true, new String[0]);
    }

    @Test
    public void inputVisitReserved() throws Exception {
        this.checkVisitReserved("input", true, new String[0]);
    }

    @Test
    public void bodyVisitReserved() throws Exception {
        this.checkVisitReserved("body", true, new String[0]);
    }

    @Test
    public void embedVisitReserved() throws Exception {
        this.checkVisitReserved("embed", false, new String[0]);
    }

    @Test
    public void csslinkVisitReserved() throws Exception {
        this.checkVisitReserved("link", true, "rel", "stylesheet", "type", "text/css");
    }

    @Test
    public void linkWithNoRelVisitReserved() throws Exception {
        this.checkVisitReserved("link", false, "type", "text/css");
    }

    @Test
    public void linkWithNoTypeVisitReserved() throws Exception {
        this.checkVisitReserved("link", false, "rel", "stylesheet");
    }

    @Test
    public void altlinkVisitReserved() throws Exception {
        this.checkVisitReserved("link", false, "rel", "alternate", "hreflang", "el");
    }

    @Test
    public void scriptVisitReserved() throws Exception {
        this.checkVisitReserved("script", true, new String[0]);
    }

    @Test
    public void objectVisitReserved() throws Exception {
        this.checkVisitReserved("object", false, new String[0]);
    }

    @Test
    public void otherVisitNotReserved() throws Exception {
        this.checkVisitReserved("other", false, new String[0]);
    }

    @Test
    public void imgWithEmptySrc() throws Exception {
        Element node = this.elem("img", "src", "");
        ContentRewriterFeature.Config config = (ContentRewriterFeature.Config)EasyMock.createMock(ContentRewriterFeature.Config.class);
        EasyMock.expect((Object)config.shouldRewriteURL("")).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)config.shouldRewriteTag("img")).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{config});
        ProxyingVisitor rewriter = new ProxyingVisitor(config, null, new ResourceMutateVisitor.Tags[]{ResourceMutateVisitor.Tags.SCRIPT, ResourceMutateVisitor.Tags.STYLESHEET, ResourceMutateVisitor.Tags.EMBEDDED_IMAGES});
        DomWalker.Visitor.VisitStatus status = rewriter.visit(null, (Node)node);
        EasyMock.verify((Object[])new Object[]{config});
        Assert.assertEquals((String)"Empty attribute should not be rewritten", (Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)status);
    }

    private void checkVisitReserved(String tag, boolean result, String ... attrs) throws Exception {
        tag = tag.toLowerCase();
        Assert.assertEquals((Object)result, (Object)this.getVisitReserved(tag, true, true, attrs));
        Assert.assertEquals((Object)result, (Object)this.getVisitReserved(tag.toUpperCase(), true, true, attrs));
        Assert.assertFalse((boolean)this.getVisitReserved(tag, false, true, attrs));
        Assert.assertFalse((boolean)this.getVisitReserved(tag, true, false, attrs));
        Assert.assertFalse((boolean)this.getVisitReserved(tag, false, false, attrs));
    }

    private boolean getVisitReserved(String tag, boolean resUrl, boolean resTag, String ... attrs) throws Exception {
        String attrName = ALL_RESOURCES.get(tag.toLowerCase());
        attrName = attrName != null ? attrName : "src";
        ArrayList attrsList = Lists.newArrayList((Object[])attrs);
        attrsList.add(0, attrName);
        attrsList.add(1, URL_STRING);
        attrs = attrsList.toArray(attrs);
        Element node = this.elem(tag, attrs);
        ContentRewriterFeature.Config config = (ContentRewriterFeature.Config)EasyMock.createMock(ContentRewriterFeature.Config.class);
        EasyMock.expect((Object)config.shouldRewriteURL(URL_STRING)).andReturn((Object)resUrl).anyTimes();
        EasyMock.expect((Object)config.shouldRewriteTag(tag.toLowerCase())).andReturn((Object)resTag).anyTimes();
        EasyMock.replay((Object[])new Object[]{config});
        ProxyingVisitor rewriter = new ProxyingVisitor(config, null, new ResourceMutateVisitor.Tags[]{ResourceMutateVisitor.Tags.SCRIPT, ResourceMutateVisitor.Tags.STYLESHEET, ResourceMutateVisitor.Tags.EMBEDDED_IMAGES});
        DomWalker.Visitor.VisitStatus status = rewriter.visit(null, (Node)node);
        EasyMock.verify((Object[])new Object[]{config});
        return status != DomWalker.Visitor.VisitStatus.BYPASS;
    }

    @Test
    public void revisitModifyValidSkipInvalid() throws Exception {
        String scriptSrc = "http://script.com/foo.js";
        String imgSrc = "http://script.com/foo.jpg";
        Element e1 = this.elem("script", "src", scriptSrc);
        Element e2 = this.elem("script", "src", "^!,,|BLARGH");
        Element e3 = this.elem("IMG", "src", imgSrc);
        Element e4 = this.elem("script", "src", " " + scriptSrc + " ");
        ImmutableList nodes = ImmutableList.of((Object)e1, (Object)e2, (Object)e3, (Object)e4);
        ProxyUriManager uriManager = (ProxyUriManager)EasyMock.createMock(ProxyUriManager.class);
        Uri rewrittenUri = Uri.parse((String)"http://bar.com/");
        ArrayList returned = Lists.newArrayList((Object[])new Uri[]{rewrittenUri, rewrittenUri, rewrittenUri});
        ContentRewriterFeature.Config config = (ContentRewriterFeature.Config)EasyMock.createMock(ContentRewriterFeature.Config.class);
        Integer expires = 3;
        EasyMock.expect((Object)config.getExpires()).andReturn((Object)expires).once();
        EasyMock.expect((Object)config);
        Capture cap = new Capture();
        Capture intCap = new Capture();
        EasyMock.expect((Object)uriManager.make((List)EasyMock.capture((Capture)cap), Integer.valueOf(EasyMock.capture((Capture)intCap)))).andReturn((Object)returned).once();
        EasyMock.replay((Object[])new Object[]{config, uriManager});
        Gadget gadget = this.gadget();
        ProxyingVisitor rewriter = new ProxyingVisitor(config, uriManager, new ResourceMutateVisitor.Tags[]{ResourceMutateVisitor.Tags.SCRIPT, ResourceMutateVisitor.Tags.STYLESHEET, ResourceMutateVisitor.Tags.EMBEDDED_IMAGES});
        Assert.assertTrue((boolean)rewriter.revisit(gadget, (List)nodes));
        EasyMock.verify((Object[])new Object[]{config, uriManager});
        Assert.assertEquals((long)3L, (long)((List)cap.getValue()).size());
        Assert.assertEquals((Object)Uri.parse((String)scriptSrc), (Object)((ProxyUriManager.ProxyUri)((List)cap.getValue()).get(0)).getResource());
        Assert.assertEquals((Object)Uri.parse((String)imgSrc), (Object)((ProxyUriManager.ProxyUri)((List)cap.getValue()).get(1)).getResource());
        Assert.assertEquals((Object)Uri.parse((String)scriptSrc), (Object)((ProxyUriManager.ProxyUri)((List)cap.getValue()).get(2)).getResource());
        Assert.assertSame((Object)expires, (Object)intCap.getValue());
        Assert.assertEquals((Object)rewrittenUri.toString(), (Object)e1.getAttribute("src"));
        Assert.assertEquals((Object)"^!,,|BLARGH", (Object)e2.getAttribute("src"));
        Assert.assertEquals((Object)rewrittenUri.toString(), (Object)e3.getAttribute("src"));
        Assert.assertEquals((Object)rewrittenUri.toString(), (Object)e4.getAttribute("src"));
        Assert.assertEquals((Object)"script", (Object)((ProxyUriManager.ProxyUri)((List)cap.getValue()).get(0)).getHtmlTagContext());
        Assert.assertEquals((Object)"img", (Object)((ProxyUriManager.ProxyUri)((List)cap.getValue()).get(1)).getHtmlTagContext());
        Assert.assertEquals((Object)"script", (Object)((ProxyUriManager.ProxyUri)((List)cap.getValue()).get(2)).getHtmlTagContext());
    }
}

