/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Provider;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.config.AbstractContainerConfig;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSimplifiedHtmlParser;
import org.apache.shindig.gadgets.render.FakeMessageBundleFactory;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.TemplateRewriter;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.templates.ContainerTagLibraryFactory;
import org.apache.shindig.gadgets.templates.DefaultTemplateProcessor;
import org.apache.shindig.gadgets.templates.TagRegistry;
import org.apache.shindig.gadgets.templates.TemplateLibrary;
import org.apache.shindig.gadgets.templates.TemplateLibraryFactory;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.XmlTemplateLibrary;
import org.apache.shindig.gadgets.templates.tags.AbstractTagHandler;
import org.apache.shindig.gadgets.templates.tags.DefaultTagRegistry;
import org.apache.shindig.gadgets.templates.tags.TagHandler;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TemplateRewriterTest {
    private GadgetSpec gadgetSpec;
    private Gadget gadget;
    private MutableContent content;
    private TemplateRewriter rewriter;
    private final Map<String, Object> config = Maps.newHashMap();
    private static final Uri GADGET_URI = Uri.parse((String)"http://example.org/gadget.php");
    private static final String CONTENT_PLAIN = "<script type='text/os-template'>Hello, ${user.name}</script>";
    private static final String CONTENT_WITH_MESSAGE = "<script type='text/os-template'>Hello, ${Msg.name}</script>";
    private static final String CONTENT_REQUIRE = "<script type='text/os-template' require='user'>Hello, ${user.name}</script>";
    private static final String CONTENT_REQUIRE_MISSING = "<script type='text/os-template' require='foo'>Hello, ${user.name}</script>";
    private static final String CONTENT_WITH_TAG = "<script type='text/os-template' xmlns:foo='#foo' tag='foo:Bar'>Hello, ${user.name}</script>";
    private static final String CONTENT_WITH_AUTO_UPDATE = "<script type='text/os-template' autoUpdate='true'>Hello, ${user.name}</script>";
    private static final String TEMPLATE_LIBRARY = "<Templates xmlns:my='#my'>  <Namespace prefix='my' url='#my'/>  <JavaScript>script</JavaScript>  <Style>style</Style>  <Template tag='my:Tag1'>external1</Template>  <Template tag='my:Tag2'>external2</Template>  <Template tag='my:Tag3'>external3</Template>  <Template tag='my:Tag4'>external4</Template></Templates>";
    private static final String TEMPLATE_LIBRARY_URI = "http://example.org/library.xml";
    private static final String CONTENT_WITH_TAG_FROM_LIBRARY = "<script type='text/os-template' xmlns:my='#my'><my:Tag4/></script>";
    private static final String CONTENT_TESTING_PRECEDENCE_RULES = "<script type='text/os-template' xmlns:my='#my' tag='my:Tag1'>inline1</script><script type='text/os-template' xmlns:my='#my' tag='my:Tag2'>inline2</script><script type='text/os-template' xmlns:my='#my' tag='my:Tag3'>inline3</script><script type='text/os-template' xmlns:my='#my'><my:Tag1/><my:Tag2/><my:Tag3/><my:Tag4/></script>";

    @Before
    public void setUp() {
        ImmutableSet handlers = ImmutableSet.of((Object)TemplateRewriterTest.testTagHandler("Tag1", "default1"));
        this.rewriter = new TemplateRewriter((Provider)new Provider<TemplateProcessor>(){

            public TemplateProcessor get() {
                return new DefaultTemplateProcessor(Expressions.forTesting());
            }
        }, (MessageBundleFactory)new FakeMessageBundleFactory(), Expressions.forTesting(), (TagRegistry)new DefaultTagRegistry((Set)handlers), (TemplateLibraryFactory)new FakeTemplateLibraryFactory(), new ContainerTagLibraryFactory((ContainerConfig)new FakeContainerConfig()));
    }

    private static TagHandler testTagHandler(String name, final String content) {
        return new AbstractTagHandler("#my", name){

            public void process(Node result, Element tag, TemplateProcessor processor) {
                result.appendChild(result.getOwnerDocument().createTextNode(content));
            }
        };
    }

    @Test
    public void simpleTemplate() throws Exception {
        this.testExpectingTransform(TemplateRewriterTest.getGadgetXml(CONTENT_PLAIN), "simple");
        this.testFeatureRemoved();
    }

    @Test
    public void noTemplateFeature() throws Exception {
        this.testExpectingNoTransform(TemplateRewriterTest.getGadgetXml(CONTENT_PLAIN, false), "no feature");
    }

    @Test
    public void requiredDataPresent() throws Exception {
        this.testExpectingTransform(TemplateRewriterTest.getGadgetXml(CONTENT_REQUIRE), "required data");
        this.testFeatureRemoved();
    }

    @Test
    public void requiredDataMissing() throws Exception {
        this.testExpectingNoTransform(TemplateRewriterTest.getGadgetXml(CONTENT_REQUIRE_MISSING), "missing data");
        this.testFeatureNotRemoved();
    }

    @Test
    public void tagAttributePresent() throws Exception {
        this.testExpectingNoTransform(TemplateRewriterTest.getGadgetXml(CONTENT_WITH_TAG), "with @tag");
        this.testFeatureRemoved();
    }

    @Test
    public void templateUsingMessage() throws Exception {
        this.testExpectingTransform(TemplateRewriterTest.getGadgetXml(CONTENT_WITH_MESSAGE), "simple");
        this.testFeatureRemoved();
    }

    @Test
    public void autoUpdateTemplate() throws Exception {
        this.setupGadget(TemplateRewriterTest.getGadgetXml(CONTENT_WITH_AUTO_UPDATE));
        this.rewriter.rewrite(this.gadget, this.content);
        Assert.assertTrue((String)"Template wasn't transformed", (this.content.getContent().indexOf("Hello, John") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Template tag was removed", (boolean)this.content.getContent().contains("text/os-template"));
        Assert.assertTrue((String)"ID span was not created", (boolean)this.content.getContent().contains("<span id=\"_T_template_auto0\">"));
        this.testFeatureNotRemoved();
    }

    @Test
    public void templateWithLibrary() throws Exception {
        this.setupGadget(TemplateRewriterTest.getGadgetXmlWithLibrary(CONTENT_WITH_TAG_FROM_LIBRARY));
        this.rewriter.rewrite(this.gadget, this.content);
        Assert.assertTrue((String)"Script not inserted", (this.content.getContent().indexOf("<script type=\"text/javascript\">script</script>") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Style not inserted", (this.content.getContent().indexOf("<style type=\"text/css\">style</style>") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Tag not executed", (this.content.getContent().indexOf("external4") > 0 ? 1 : 0) != 0);
        this.testFeatureRemoved();
    }

    @Test
    public void osmlWithLibrary() throws Exception {
        this.setupGadget(TemplateRewriterTest.getGadgetXmlWithLibrary(CONTENT_WITH_TAG_FROM_LIBRARY, "osml"));
        this.rewriter.rewrite(this.gadget, this.content);
        Assert.assertTrue((String)"Custom tags were evaluated", (boolean)this.content.getContent().equals("<html><head></head><body><my:Tag4></my:Tag4></body></html>"));
        this.testFeatureRemoved();
    }

    @Test
    public void tagPrecedenceRules() throws Exception {
        this.config.put("${Cur['gadgets.features'].osml.library}", "org/apache/shindig/gadgets/rewrite/OSML_test.xml");
        this.setupGadget(TemplateRewriterTest.getGadgetXmlWithLibrary(CONTENT_TESTING_PRECEDENCE_RULES));
        this.rewriter.rewrite(this.gadget, this.content);
        Assert.assertTrue((String)"Precedence rules violated", (this.content.getContent().indexOf("default1osml2inline3external4") > 0 ? 1 : 0) != 0);
        this.testFeatureRemoved();
    }

    @Test
    public void tagPrecedenceRulesWithOSMLFeature() throws Exception {
        this.config.put("${Cur['gadgets.features'].osml.library}", "org/apache/shindig/gadgets/rewrite/OSML_test.xml");
        this.setupGadget(TemplateRewriterTest.getGadgetXmlWithLibrary(CONTENT_TESTING_PRECEDENCE_RULES, "osml"));
        this.rewriter.rewrite(this.gadget, this.content);
        Assert.assertTrue((String)"Precedence rules violated", (this.content.getContent().indexOf("default1osml2<my:Tag3></my:Tag3><my:Tag4></my:Tag4>") > 0 ? 1 : 0) != 0);
        this.testFeatureRemoved();
    }

    @Test
    public void tagPrecedenceRulesWithoutOSML() throws Exception {
        this.config.put("${Cur['gadgets.features'].osml.library}", "");
        this.setupGadget(TemplateRewriterTest.getGadgetXmlWithLibrary(CONTENT_TESTING_PRECEDENCE_RULES));
        this.rewriter.rewrite(this.gadget, this.content);
        Assert.assertTrue((String)"Precedence rules violated", (this.content.getContent().indexOf("default1inline2inline3external4") > 0 ? 1 : 0) != 0);
        this.testFeatureRemoved();
    }

    @Test
    public void testClientOverride() throws Exception {
        this.testExpectingTransform(TemplateRewriterTest.getGadgetXml(CONTENT_PLAIN, true, "true"), "keep client");
        this.testFeatureNotRemoved();
        this.testExpectingNoTransform(TemplateRewriterTest.getGadgetXml(CONTENT_WITH_TAG, true, "false"), "remove client");
        this.testFeatureRemoved();
    }

    private void testFeatureRemoved() {
        Assert.assertFalse((String)"Feature wasn't removed", (boolean)this.gadget.getDirectFeatureDeps().contains("opensocial-templates"));
    }

    private void testFeatureNotRemoved() {
        Assert.assertTrue((String)"Feature was removed", (boolean)this.gadget.getDirectFeatureDeps().contains("opensocial-templates"));
    }

    private void testExpectingTransform(String code, String condition) throws Exception {
        this.setupGadget(code);
        this.rewriter.rewrite(this.gadget, this.content);
        Assert.assertTrue((String)("Template wasn't transformed (" + condition + ')'), (this.content.getContent().indexOf("Hello, John") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Template tag wasn't removed (" + condition + ')'), (!this.content.getContent().contains("text/os-template") ? 1 : 0) != 0);
    }

    private void testExpectingNoTransform(String code, String condition) throws Exception {
        this.setupGadget(code);
        this.rewriter.rewrite(this.gadget, this.content);
        Assert.assertTrue((String)("Template was transformed (" + condition + ')'), (this.content.getContent().indexOf("${user.name}") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Template tag was removed (" + condition + ')'), (this.content.getContent().indexOf("text/os-template") > 0 ? 1 : 0) != 0);
    }

    private void setupGadget(String gadgetXml) throws SpecParserException, JSONException {
        this.gadgetSpec = new GadgetSpec(GADGET_URI, gadgetXml);
        this.gadget = new Gadget();
        this.gadget.setSpec(this.gadgetSpec);
        this.gadget.setContext(new GadgetContext(){

            public Uri getUrl() {
                return GADGET_URI;
            }
        });
        this.gadget.setCurrentView(this.gadgetSpec.getView("default"));
        this.content = new MutableContent((GadgetHtmlParser)new NekoSimplifiedHtmlParser(new ParseModule.DOMImplementationProvider().get()), this.gadget.getCurrentView().getContent());
        this.putPipelinedData("user", new JSONObject("{ name: 'John'}"));
    }

    private void putPipelinedData(String key, JSONObject data) {
        this.content.addPipelinedData(key, (Object)data);
    }

    private static String getGadgetXml(String content) {
        return TemplateRewriterTest.getGadgetXml(content, true);
    }

    private static String getGadgetXml(String content, boolean requireFeature) {
        return TemplateRewriterTest.getGadgetXml(content, requireFeature, null);
    }

    private static String getGadgetXml(String content, boolean requireFeature, String clientParam) {
        String feature = requireFeature ? "<Require feature='opensocial-templates'" + (clientParam != null ? "><Param name='client'>" + clientParam + "</Param></Require>" : "/>") : "";
        return "<Module><ModulePrefs title='Title'>" + feature + "  <Locale>" + "    <msg name='name'>John</msg>" + "  </Locale>" + "</ModulePrefs>" + "<Content>" + "    <![CDATA[" + content + "]]>" + "</Content></Module>";
    }

    private static String getGadgetXmlWithLibrary(String content) {
        return TemplateRewriterTest.getGadgetXmlWithLibrary(content, "opensocial-templates");
    }

    private static String getGadgetXmlWithLibrary(String content, String feature) {
        return "<Module><ModulePrefs title='Title'>  <Require feature='" + feature + "'>" + "    <Param name='" + "requireLibrary" + "'>" + TEMPLATE_LIBRARY_URI + "    </Param>" + "  </Require>" + "</ModulePrefs>" + "<Content>" + "    <![CDATA[" + content + "]]>" + "</Content></Module>";
    }

    private class FakeContainerConfig
    extends AbstractContainerConfig {
        private FakeContainerConfig() {
        }

        public Object getProperty(String container, String name) {
            return TemplateRewriterTest.this.config.get(name);
        }
    }

    private static class FakeTemplateLibraryFactory
    extends TemplateLibraryFactory {
        public FakeTemplateLibraryFactory() {
            super(null, null);
        }

        public TemplateLibrary loadTemplateLibrary(GadgetContext context, Uri uri) throws GadgetException {
            Assert.assertEquals((Object)TemplateRewriterTest.TEMPLATE_LIBRARY_URI, (Object)uri.toString());
            return new XmlTemplateLibrary(uri, XmlUtil.parseSilent((String)TemplateRewriterTest.TEMPLATE_LIBRARY), TemplateRewriterTest.TEMPLATE_LIBRARY);
        }
    }
}

