/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.rewrite.image.BasicImageRewriter;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImageRewriterTest
extends Assert {
    private static final String SCALE_IMAGE = "org/apache/shindig/gadgets/rewrite/image/dog.gif";
    private static final String EXPAND_IMAGE = "org/apache/shindig/gadgets/rewrite/image/expand.gif";
    private static final String RATIO_IMAGE = "org/apache/shindig/gadgets/rewrite/image/ratio.gif";
    private static final String HUGE_IMAGE = "org/apache/shindig/gadgets/rewrite/image/huge.gif";
    private static final String CONTENT_TYPE_BOGUS = "notimage/anything";
    private static final String CONTENT_TYPE_JPG = "image/jpeg";
    private static final String CONTENT_TYPE_GIF = "image/gif";
    private static final String CONTENT_TYPE_PNG = "image/png";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final Uri IMAGE_URL = Uri.parse((String)"http://www.example.com/image.gif");
    private ResponseRewriter rewriter;
    private IMocksControl mockControl;

    @Before
    public void setUp() throws Exception {
        this.rewriter = new BasicImageRewriter(new OptimizerConfig());
        this.mockControl = EasyMock.createControl();
    }

    private HttpResponseBuilder getImageResponse(String contentType, byte[] imageBytes) {
        return new HttpResponseBuilder().setHeader(CONTENT_TYPE_HEADER, contentType).setHttpStatusCode(200).setResponse(imageBytes);
    }

    private byte[] getImageBytes(String imageResourceName) throws IOException {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        byte[] imageBytes = IOUtils.toByteArray((InputStream)classLoader.getResourceAsStream(imageResourceName));
        ImageRewriterTest.assertNotNull((Object)imageBytes);
        return imageBytes;
    }

    private BufferedImage getResizedHttpResponseContent(String sourceContentType, String targetContentType, String imageName, Integer width, Integer height, Integer quality) throws Exception {
        return this.getResizedHttpResponseContent(sourceContentType, targetContentType, imageName, width, height, quality, false);
    }

    private BufferedImage getResizedHttpResponseContent(String sourceContentType, String targetContentType, String imageName, Integer width, Integer height, Integer quality, boolean noExpand) throws Exception {
        HttpResponseBuilder response = this.getImageResponse(sourceContentType, this.getImageBytes(imageName));
        HttpRequest request = this.getMockRequest(width, height, quality, noExpand);
        this.mockControl.replay();
        this.rewriter.rewrite(request, response);
        this.mockControl.verify();
        ImageRewriterTest.assertEquals((Object)targetContentType, (Object)response.getHeader(CONTENT_TYPE_HEADER));
        return ImageIO.read(response.getContentBytes());
    }

    private HttpRequest getMockRequest(Integer width, Integer height, Integer quality, boolean noExpand) {
        HttpRequest request = (HttpRequest)this.mockControl.createMock(HttpRequest.class);
        EasyMock.expect((Object)request.getUri()).andReturn((Object)IMAGE_URL);
        EasyMock.expect((Object)request.getParamAsInteger(UriCommon.Param.RESIZE_QUALITY.getKey())).andReturn((Object)quality);
        EasyMock.expect((Object)request.getParamAsInteger(UriCommon.Param.RESIZE_WIDTH.getKey())).andReturn((Object)width);
        EasyMock.expect((Object)request.getParamAsInteger(UriCommon.Param.RESIZE_HEIGHT.getKey())).andReturn((Object)height);
        EasyMock.expect((Object)request.getParam(UriCommon.Param.NO_EXPAND.getKey())).andReturn((Object)(noExpand ? "1" : null)).anyTimes();
        return request;
    }

    @Test
    public void testRewriteValidImageWithValidMimeAndExtn() throws Exception {
        byte[] bytes = this.getImageBytes("org/apache/shindig/gadgets/rewrite/image/inefficient.png");
        HttpResponseBuilder response = this.getImageResponse(CONTENT_TYPE_PNG, bytes);
        int originalContentLength = response.getContentLength();
        this.rewriter.rewrite(new HttpRequest(Uri.parse((String)"some.png")), response);
        ImageRewriterTest.assertEquals((long)200L, (long)response.getHttpStatusCode());
        ImageRewriterTest.assertTrue((response.getContentLength() < originalContentLength ? 1 : 0) != 0);
    }

    @Test
    public void testRewriteValidImageWithInvalidMimeAndFileExtn() throws Exception {
        byte[] bytes = this.getImageBytes("org/apache/shindig/gadgets/rewrite/image/inefficient.png");
        HttpResponseBuilder response = this.getImageResponse(CONTENT_TYPE_BOGUS, bytes);
        int originalContentLength = response.getContentLength();
        this.rewriter.rewrite(new HttpRequest(Uri.parse((String)"some.junk")), response);
        ImageRewriterTest.assertEquals((long)200L, (long)response.getHttpStatusCode());
        ImageRewriterTest.assertEquals((long)response.getContentLength(), (long)originalContentLength);
    }

    @Test
    public void testRewriteInvalidImageContentWithValidMime() throws Exception {
        HttpResponseBuilder response = this.getImageResponse(CONTENT_TYPE_PNG, "This is not a PNG".getBytes());
        this.rewriter.rewrite(new HttpRequest(Uri.parse((String)"some.junk")), response);
        ImageRewriterTest.assertEquals((long)415L, (long)response.getHttpStatusCode());
        ImageRewriterTest.assertEquals((Object)"Content is not an image but mime type asserts it is", (Object)response.create().getResponseAsString());
    }

    @Test
    public void testRewriteInvalidImageContentWithValidFileExtn() throws Exception {
        HttpResponseBuilder response = this.getImageResponse(CONTENT_TYPE_BOGUS, "This is not an image".getBytes());
        this.rewriter.rewrite(new HttpRequest(Uri.parse((String)"some.png")), response);
        ImageRewriterTest.assertEquals((long)415L, (long)response.getHttpStatusCode());
        ImageRewriterTest.assertEquals((Object)"Content is not an image but file extension asserts it is", (Object)response.create().getResponseAsString());
    }

    @Test
    public void testNoRewriteAnimatedGIF() throws Exception {
        HttpResponseBuilder response = this.getImageResponse(CONTENT_TYPE_GIF, this.getImageBytes("org/apache/shindig/gadgets/rewrite/image/animated.gif"));
        int changesBefore = response.getNumChanges();
        this.rewriter.rewrite(new HttpRequest(Uri.parse((String)"animated.gif")), response);
        ImageRewriterTest.assertEquals((long)changesBefore, (long)response.getNumChanges());
    }

    @Test
    public void testRewriteUnAnimatedGIF() throws Exception {
        HttpResponseBuilder response = this.getImageResponse(CONTENT_TYPE_GIF, this.getImageBytes("org/apache/shindig/gadgets/rewrite/image/large.gif"));
        this.rewriter.rewrite(new HttpRequest(Uri.parse((String)"large.gif")), response);
        ImageRewriterTest.assertEquals((Object)CONTENT_TYPE_PNG, (Object)response.getHeader(CONTENT_TYPE_HEADER));
    }

    @Test
    public void testResize_width() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, SCALE_IMAGE, 100, null, null);
        ImageRewriterTest.assertEquals((long)100L, (long)image.getWidth());
        ImageRewriterTest.assertEquals((long)100L, (long)image.getHeight());
    }

    @Test
    public void testResize_height() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, SCALE_IMAGE, null, 100, null);
        ImageRewriterTest.assertEquals((long)100L, (long)image.getWidth());
        ImageRewriterTest.assertEquals((long)100L, (long)image.getHeight());
    }

    @Test
    public void testResize_both() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, SCALE_IMAGE, 100, 100, null);
        ImageRewriterTest.assertEquals((long)100L, (long)image.getWidth());
        ImageRewriterTest.assertEquals((long)100L, (long)image.getHeight());
    }

    @Test
    public void testResize_all() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, SCALE_IMAGE, 100, 100, 10);
        ImageRewriterTest.assertEquals((long)100L, (long)image.getWidth());
        ImageRewriterTest.assertEquals((long)100L, (long)image.getHeight());
    }

    @Test
    public void testResize_wideImage() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, SCALE_IMAGE, 100, 50, null);
        ImageRewriterTest.assertEquals((long)100L, (long)image.getWidth());
        ImageRewriterTest.assertEquals((long)50L, (long)image.getHeight());
    }

    @Test
    public void testResize_tallImage() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, SCALE_IMAGE, 50, 100, null);
        ImageRewriterTest.assertEquals((long)50L, (long)image.getWidth());
        ImageRewriterTest.assertEquals((long)100L, (long)image.getHeight());
    }

    @Test
    public void testResize_skipResizeHugeOutputImage() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, SCALE_IMAGE, 10000, 10000, null);
        ImageRewriterTest.assertEquals((long)500L, (long)image.getWidth());
        ImageRewriterTest.assertEquals((long)500L, (long)image.getHeight());
    }

    @Test
    public void testResize_brokenParameter() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_GIF, SCALE_IMAGE, -1, null, null);
        ImageRewriterTest.assertEquals((long)500L, (long)image.getWidth());
        ImageRewriterTest.assertEquals((long)500L, (long)image.getHeight());
    }

    @Test
    public void testResize_expandImage() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, EXPAND_IMAGE, 120, 60, null);
        ImageRewriterTest.assertEquals((long)120L, (long)image.getWidth());
        ImageRewriterTest.assertEquals((long)60L, (long)image.getHeight());
    }

    @Test
    public void testResize_noExpandImage() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_PNG, EXPAND_IMAGE, 120, 60, null, true);
        ImageRewriterTest.assertEquals((long)60L, (long)image.getWidth());
        ImageRewriterTest.assertEquals((long)30L, (long)image.getHeight());
    }

    @Test
    public void testResize_refuseHugeInputImages() throws Exception {
        HttpResponseBuilder response = this.getImageResponse(CONTENT_TYPE_GIF, this.getImageBytes(HUGE_IMAGE));
        HttpRequest request = this.getMockRequest(120, 60, null, false);
        this.mockControl.replay();
        this.rewriter.rewrite(request, response);
        this.mockControl.verify();
        ImageRewriterTest.assertEquals((long)403L, (long)response.getHttpStatusCode());
    }

    @Test
    public void testResize_acceptServeHugeImages() throws Exception {
        byte[] imageBytes = this.getImageBytes(HUGE_IMAGE);
        HttpResponseBuilder response = this.getImageResponse(CONTENT_TYPE_GIF, imageBytes);
        HttpRequest request = this.getMockRequest(null, null, null, false);
        this.mockControl.replay();
        this.rewriter.rewrite(request, response);
        this.mockControl.verify();
        ImageRewriterTest.assertEquals((long)200L, (long)response.getHttpStatusCode());
        ImageRewriterTest.assertTrue((boolean)Arrays.equals(imageBytes, IOUtils.toByteArray((InputStream)response.getContentBytes())));
    }

    @Test
    public void testResize_avoidFloatingPointRoundingProblems() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_PNG, RATIO_IMAGE, 171, 171, null, true);
        ImageRewriterTest.assertEquals((long)171L, (long)image.getWidth());
        ImageRewriterTest.assertEquals((long)114L, (long)image.getHeight());
    }
}

