/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.servlet.ConcatProxyServlet;
import org.apache.shindig.gadgets.servlet.ServletTestFixture;
import org.apache.shindig.gadgets.uri.ConcatUriManager;
import org.apache.shindig.gadgets.uri.UriStatus;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcatProxyServletTest
extends ServletTestFixture {
    private static final String REQUEST_DOMAIN = "example.org";
    private static final Uri URL1 = Uri.parse((String)"http://example.org/1.js");
    private static final Uri URL2 = Uri.parse((String)"http://example.org/2.js");
    private static final Uri URL3 = Uri.parse((String)"http://example.org/3.js");
    private static final String SCRT1 = "var v1 = 1;";
    private static final String SCRT2 = "var v2 = { \"a-b\": 1 , c: \"hello!,\" };";
    private static final String SCRT3 = "var v3 = \"world\";";
    private static final String SCRT1_ESCAPED = "var v1 = 1;";
    private static final String SCRT2_ESCAPED = "var v2 = { \\\"a-b\\\": 1 , c: \\\"hello!,\\\" };";
    private static final String SCRT3_ESCAPED = "var v3 = \\\"world\\\";";
    private final ConcatProxyServlet servlet = new ConcatProxyServlet();
    private TestConcatUriManager uriManager;
    private final ExecutorService sequentialExecutor = Executors.newSingleThreadExecutor();
    private final ExecutorService threadedExecutor = Executors.newCachedThreadPool();

    @Before
    public void setUp() throws Exception {
        this.servlet.setRequestPipeline(this.pipeline);
        this.uriManager = new TestConcatUriManager();
        this.servlet.setConcatUriManager((ConcatUriManager)this.uriManager);
        EasyMock.expect((Object)this.request.getHeader("Host")).andReturn((Object)REQUEST_DOMAIN).anyTimes();
        EasyMock.expect((Object)this.lockedDomainService.isSafeForOpenProxy(REQUEST_DOMAIN)).andReturn((Object)true).anyTimes();
        this.expectGetAndReturnData(URL1, "var v1 = 1;");
        this.expectGetAndReturnData(URL2, SCRT2);
        this.expectGetAndReturnData(URL3, SCRT3);
    }

    private void expectGetAndReturnData(Uri url, String data) throws Exception {
        HttpRequest req = new HttpRequest(url);
        HttpResponse resp = new HttpResponseBuilder().setResponse(data.getBytes()).create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp).anyTimes();
    }

    private String addComment(String data, String url) {
        String res = "/* ---- Start " + url + " ---- */\r\n" + data + "/* ---- End " + url + " ---- */\r\n";
        return res;
    }

    private String addErrComment(String url, int code) {
        return "/* ---- Error " + code + " (" + url + ") ---- */\r\n";
    }

    private String addVar(String url, String data) {
        return '\"' + url + "\":\"" + data + "\",\r\n";
    }

    private void runConcat(ExecutorService exec, String result, String tok, Uri ... uris) throws Exception {
        this.expectRequestWithUris(Lists.newArrayList((Object[])uris), tok);
        this.servlet.setExecutor(exec);
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        ConcatProxyServletTest.assertEquals((Object)result, (Object)this.recorder.getResponseAsString());
        ConcatProxyServletTest.assertEquals((long)200L, (long)this.recorder.getHttpStatusCode());
    }

    @Test
    public void testSimpleConcat() throws Exception {
        String results = this.addComment("var v1 = 1;", URL1.toString()) + this.addComment(SCRT2, URL2.toString());
        this.runConcat(this.sequentialExecutor, results, null, URL1, URL2);
    }

    @Test
    public void testSimpleConcatThreaded() throws Exception {
        String results = this.addComment("var v1 = 1;", URL1.toString()) + this.addComment(SCRT2, URL2.toString());
        this.runConcat(this.threadedExecutor, results, null, URL1, URL2);
    }

    @Test
    public void testThreeConcat() throws Exception {
        String results = this.addComment("var v1 = 1;", URL1.toString()) + this.addComment(SCRT2, URL2.toString()) + this.addComment(SCRT3, URL3.toString());
        this.runConcat(this.sequentialExecutor, results, null, URL1, URL2, URL3);
    }

    @Test
    public void testThreeConcatThreaded() throws Exception {
        String results = this.addComment("var v1 = 1;", URL1.toString()) + this.addComment(SCRT2, URL2.toString()) + this.addComment(SCRT3, URL3.toString());
        this.runConcat(this.threadedExecutor, results, null, URL1, URL2, URL3);
    }

    @Test
    public void testConcatBadException() throws Exception {
        Uri URL4 = Uri.parse((String)"http://example.org/4.js");
        HttpRequest req = new HttpRequest(URL4);
        EasyMock.expect((Object)this.pipeline.execute(req)).andThrow((Throwable)new GadgetException(GadgetException.Code.HTML_PARSE_ERROR)).anyTimes();
        this.expectRequestWithUris(Lists.newArrayList((Object[])new Uri[]{URL1, URL4}));
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        String results = this.addComment("var v1 = 1;", URL1.toString()) + "HTML_PARSE_ERROR concat(http://example.org/4.js) null";
        ConcatProxyServletTest.assertEquals((Object)results, (Object)this.recorder.getResponseAsString());
        ConcatProxyServletTest.assertEquals((long)400L, (long)this.recorder.getHttpStatusCode());
    }

    @Test
    public void testConcat404() throws Exception {
        String url = "http://nobodyhome.com/";
        HttpRequest req = new HttpRequest(Uri.parse((String)url));
        HttpResponse resp = new HttpResponseBuilder().setHttpStatusCode(404).create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp).anyTimes();
        this.expectRequestWithUris(Lists.newArrayList((Object[])new Uri[]{URL1, Uri.parse((String)url)}));
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        String results = this.addComment("var v1 = 1;", URL1.toString()) + this.addErrComment(url, 404);
        ConcatProxyServletTest.assertEquals((Object)results, (Object)this.recorder.getResponseAsString());
        ConcatProxyServletTest.assertEquals((long)200L, (long)this.recorder.getHttpStatusCode());
    }

    @Test
    public void testAsJsonConcat() throws Exception {
        String results = "_js={\r\n" + this.addVar(URL1.toString(), "var v1 = 1;") + this.addVar(URL2.toString(), SCRT2_ESCAPED) + "};\r\n";
        this.runConcat(this.sequentialExecutor, results, "_js", URL1, URL2);
    }

    @Test
    public void testThreeAsJsonConcat() throws Exception {
        String results = "_js={\r\n" + this.addVar(URL1.toString(), "var v1 = 1;") + this.addVar(URL2.toString(), SCRT2_ESCAPED) + this.addVar(URL3.toString(), SCRT3_ESCAPED) + "};\r\n";
        this.runConcat(this.sequentialExecutor, results, "_js", URL1, URL2, URL3);
    }

    @Test
    public void testBadJsonVarConcat() throws Exception {
        this.expectRequestWithUris(Lists.newArrayList(), "bad code;");
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        String results = "/* ---- Error 400, Bad json variable name bad code; ---- */\r\n";
        ConcatProxyServletTest.assertEquals((Object)results, (Object)this.recorder.getResponseAsString());
        ConcatProxyServletTest.assertEquals((long)400L, (long)this.recorder.getHttpStatusCode());
    }

    @Test
    public void testAsJsonConcat404() throws Exception {
        Uri URL4 = Uri.parse((String)"http://example.org/4.js");
        HttpRequest req = new HttpRequest(URL4);
        HttpResponse resp = new HttpResponseBuilder().setHttpStatusCode(404).create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp).anyTimes();
        String results = "_js={\r\n" + this.addVar(URL1.toString(), "var v1 = 1;") + "/* ---- Error 404 (http://example.org/4.js) ---- */\r\n" + "};\r\n";
        this.runConcat(this.sequentialExecutor, results, "_js", URL1, URL4);
    }

    @Test
    public void testAsJsonConcatException() throws Exception {
        Uri URL4 = Uri.parse((String)"http://example.org/4.js");
        HttpRequest req = new HttpRequest(URL4);
        EasyMock.expect((Object)this.pipeline.execute(req)).andThrow((Throwable)new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT)).anyTimes();
        this.expectRequestWithUris(Lists.newArrayList((Object[])new Uri[]{URL1, URL4}), "_js");
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        String results = "_js={\r\n" + this.addVar(URL1.toString(), "var v1 = 1;") + "FAILED_TO_RETRIEVE_CONTENT concat(http://example.org/4.js) null};\r\n";
        ConcatProxyServletTest.assertEquals((Object)results, (Object)this.recorder.getResponseAsString());
        ConcatProxyServletTest.assertEquals((long)400L, (long)this.recorder.getHttpStatusCode());
    }

    @Test
    public void testAsJsonConcatBadException() throws Exception {
        Uri URL4 = Uri.parse((String)"http://example.org/4.js");
        HttpRequest req = new HttpRequest(URL4);
        EasyMock.expect((Object)this.pipeline.execute(req)).andThrow((Throwable)new GadgetException(GadgetException.Code.HTML_PARSE_ERROR)).anyTimes();
        String results = "_js={\r\n" + this.addVar(URL1.toString(), "var v1 = 1;") + "HTML_PARSE_ERROR concat(http://example.org/4.js) null};\r\n";
        this.expectRequestWithUris(Lists.newArrayList((Object[])new Uri[]{URL1, URL4}), "_js");
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        ConcatProxyServletTest.assertEquals((Object)results, (Object)this.recorder.getResponseAsString());
        ConcatProxyServletTest.assertEquals((long)400L, (long)this.recorder.getHttpStatusCode());
    }

    private void expectRequestWithUris(List<Uri> uris) {
        this.expectRequestWithUris(uris, null);
    }

    private void expectRequestWithUris(List<Uri> uris, String tok) {
        EasyMock.expect((Object)this.request.getScheme()).andReturn((Object)"http").anyTimes();
        EasyMock.expect((Object)this.request.getServerPort()).andReturn((Object)80).anyTimes();
        EasyMock.expect((Object)this.request.getServerName()).andReturn((Object)"example.com").anyTimes();
        EasyMock.expect((Object)this.request.getRequestURI()).andReturn((Object)"/path").anyTimes();
        EasyMock.expect((Object)this.request.getQueryString()).andReturn((Object)"").anyTimes();
        this.replay();
        Uri uri = new UriBuilder(this.request).toUri();
        this.uriManager.expect(uri, uris, tok);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestConcatUriManager
    implements ConcatUriManager {
        private final Map<Uri, ConcatUriManager.ConcatUri> uriMap = Maps.newHashMap();

        private TestConcatUriManager() {
        }

        public List<ConcatUriManager.ConcatData> make(List<ConcatUriManager.ConcatUri> resourceUris, boolean isAdjacent) {
            throw new UnsupportedOperationException();
        }

        public ConcatUriManager.ConcatUri process(Uri uri) {
            return this.uriMap.get(uri);
        }

        private void expect(Uri orig, UriStatus status, ConcatUriManager.Type type, List<Uri> uris, String json) {
            this.uriMap.put(orig, new ConcatUriManager.ConcatUri(status, uris, json, type, null));
        }

        private void expect(Uri orig, List<Uri> uris, String tok) {
            this.expect(orig, UriStatus.VALID_UNVERSIONED, ConcatUriManager.Type.JS, uris, tok);
        }
    }
}

