/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.JsonAssert;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.rewrite.CaptureRewriter;
import org.apache.shindig.gadgets.rewrite.DefaultResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.servlet.HttpRequestHandler;
import org.apache.shindig.protocol.DefaultHandlerRegistry;
import org.apache.shindig.protocol.HandlerExecutionListener;
import org.apache.shindig.protocol.HandlerRegistry;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RpcHandler;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.protocol.multipart.FormDataItem;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;

public class HttpRequestHandlerTest
extends EasyMockTestCase {
    private BeanJsonConverter converter;
    private FakeGadgetToken token;
    private final RequestPipeline pipeline = (RequestPipeline)this.mock(RequestPipeline.class);
    private final CaptureRewriter rewriter = new CaptureRewriter();
    private final ResponseRewriterRegistry rewriterRegistry = new DefaultResponseRewriterRegistry(Arrays.asList(this.rewriter), null);
    private HandlerRegistry registry;
    private HttpResponseBuilder builder;
    private final Map<String, FormDataItem> emptyFormItems = Collections.emptyMap();

    @Before
    public void setUp() throws Exception {
        this.token = new FakeGadgetToken();
        this.token.setAppUrl("http://www.example.com/gadget.xml");
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        this.converter = new BeanJsonConverter(injector);
        HttpRequestHandler handler = new HttpRequestHandler(this.pipeline, this.rewriterRegistry);
        this.registry = new DefaultHandlerRegistry(injector, this.converter, (HandlerExecutionListener)new HandlerExecutionListener.NoOpHandler());
        this.registry.addHandlers((Set)ImmutableSet.of((Object)handler));
        this.builder = new HttpResponseBuilder().setResponseString("CONTENT");
    }

    @Test
    public void testSimpleGet() throws Exception {
        JSONObject request = new JSONObject("{method:http.get, id:req1, params : {href:'http://www.example.org/somecontent'}}");
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("GET");
        EasyMock.expect((Object)this.pipeline.execute(HttpRequestHandlerTest.eqRequest(httpRequest))).andReturn((Object)this.builder.create()).anyTimes();
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        HttpRequestHandler.HttpApiResponse httpApiResponse = (HttpRequestHandler.HttpApiResponse)operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
        JsonAssert.assertJsonEquals((String)"{ headers : {}, status : 200, content : 'CONTENT' }}", (String)this.converter.convertToString((Object)httpApiResponse));
    }

    @Test
    public void testFailGetWithBodyGet() throws Exception {
        JSONObject request = new JSONObject("{method:http.get, id:req1, params : {href:'http://www.example.org/somecontent',body:'POSTBODY'}}");
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("GET");
        RpcHandler operation = this.registry.getRpcHandler(request);
        try {
            operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
            HttpRequestHandlerTest.fail((String)"Body should not be allowed in GET request");
        }
        catch (ExecutionException ee) {
            HttpRequestHandlerTest.assertTrue((boolean)(ee.getCause() instanceof ProtocolException));
        }
    }

    @Test
    public void testSimplePost() throws Exception {
        JSONObject request = new JSONObject("{method:http.post, id:req1, params : {href:'http://www.example.org/somecontent',body:'POSTBODY'}}");
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("POST");
        httpRequest.setPostBody("POSTBODY".getBytes());
        EasyMock.expect((Object)this.pipeline.execute(HttpRequestHandlerTest.eqRequest(httpRequest))).andReturn((Object)this.builder.create()).anyTimes();
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        HttpRequestHandler.HttpApiResponse httpApiResponse = (HttpRequestHandler.HttpApiResponse)operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
        JsonAssert.assertJsonEquals((String)"{ headers : {}, status : 200, content : 'CONTENT' }}", (String)this.converter.convertToString((Object)httpApiResponse));
    }

    @Test
    public void testPostWithHeaders() throws Exception {
        JSONObject request = new JSONObject("{method:http.post, id:req1, params : {href:'http://www.example.org/somecontent',body:'POSTBODY',headers:{goodheader:[good], host : [iamstripped], 'Content-Length':['1000']}}}");
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("POST");
        httpRequest.setPostBody("POSTBODY".getBytes());
        httpRequest.setHeader("goodheader", "good");
        httpRequest.setHeader("Content-Length", "1000");
        EasyMock.expect((Object)this.pipeline.execute(HttpRequestHandlerTest.eqRequest(httpRequest))).andReturn((Object)this.builder.create()).anyTimes();
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        HttpRequestHandler.HttpApiResponse httpApiResponse = (HttpRequestHandler.HttpApiResponse)operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
        JsonAssert.assertJsonEquals((String)"{ headers : {}, status : 200, content : 'CONTENT' }}", (String)this.converter.convertToString((Object)httpApiResponse));
    }

    @Test
    public void testFetchContentTypeFeed() throws Exception {
        JSONObject request = new JSONObject("{method:http.get, id:req1, params : {href:'http://www.example.org/somecontent',format : FEED}}");
        String entryTitle = "Feed title";
        String entryLink = "http://example.org/entry/0/1";
        String entrySummary = "This is the summary";
        String rss = "<?xml version=\"1.0\" encoding=\"utf-8\"?><rss version=\"2.0\"><channel><title>dummy</title><link>http://example.org/</link><item><title>" + entryTitle + "</title>" + "<link>" + entryLink + "</link>" + "<description>" + entrySummary + "</description>" + "</item>" + "</channel></rss>";
        this.builder.setResponseString(rss);
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("GET");
        EasyMock.expect((Object)this.pipeline.execute(HttpRequestHandlerTest.eqRequest(httpRequest))).andReturn((Object)this.builder.create()).anyTimes();
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        HttpRequestHandler.HttpApiResponse httpApiResponse = (HttpRequestHandler.HttpApiResponse)operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
        JSONObject feed = (JSONObject)httpApiResponse.getContent();
        JSONObject entry = feed.getJSONArray("Entry").getJSONObject(0);
        HttpRequestHandlerTest.assertEquals((Object)entryTitle, (Object)entry.getString("Title"));
        HttpRequestHandlerTest.assertEquals((Object)entryLink, (Object)entry.getString("Link"));
        HttpRequestHandlerTest.assertNull((String)"getSummaries has the wrong default value (should be false).", (Object)entry.optString("Summary", null));
        HttpRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testFetchFeedWithParameters() throws Exception {
        JSONObject request = new JSONObject("{method:http.get, id:req1, params : {href:'http://www.example.org/somecontent',format : FEED,summarize : true,entryCount : 2}}");
        String entryTitle = "Feed title";
        String entryLink = "http://example.org/entry/0/1";
        String entrySummary = "This is the summary";
        String rss = "<?xml version=\"1.0\" encoding=\"utf-8\"?><rss version=\"2.0\"><channel><title>dummy</title><link>http://example.org/</link><item><title>" + entryTitle + "</title>" + "<link>" + entryLink + "</link>" + "<description>" + entrySummary + "</description>" + "</item>" + "<item>" + "<title>" + entryTitle + "</title>" + "<link>" + entryLink + "</link>" + "<description>" + entrySummary + "</description>" + "</item>" + "<item>" + "<title>" + entryTitle + "</title>" + "<link>" + entryLink + "</link>" + "<description>" + entrySummary + "</description>" + "</item>" + "</channel></rss>";
        this.builder.setResponseString(rss);
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("GET");
        EasyMock.expect((Object)this.pipeline.execute(HttpRequestHandlerTest.eqRequest(httpRequest))).andReturn((Object)this.builder.create()).anyTimes();
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        HttpRequestHandler.HttpApiResponse httpApiResponse = (HttpRequestHandler.HttpApiResponse)operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
        JSONObject feed = (JSONObject)httpApiResponse.getContent();
        JSONArray feeds = feed.getJSONArray("Entry");
        HttpRequestHandlerTest.assertEquals((String)"numEntries not parsed correctly.", (long)2L, (long)feeds.length());
        JSONObject entry = feeds.getJSONObject(1);
        HttpRequestHandlerTest.assertEquals((Object)entryTitle, (Object)entry.getString("Title"));
        HttpRequestHandlerTest.assertEquals((Object)entryLink, (Object)entry.getString("Link"));
        HttpRequestHandlerTest.assertTrue((String)"getSummaries not parsed correctly.", (boolean)entry.has("Summary"));
        HttpRequestHandlerTest.assertEquals((Object)entrySummary, (Object)entry.getString("Summary"));
        HttpRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testJsonGet() throws Exception {
        JSONObject request = new JSONObject("{method:http.get, id:req1, params : {href:'http://www.example.org/somecontent', format:'json'}}");
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("GET");
        this.builder.setResponseString("{key:1}");
        EasyMock.expect((Object)this.pipeline.execute(HttpRequestHandlerTest.eqRequest(httpRequest))).andReturn((Object)this.builder.create()).anyTimes();
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        HttpRequestHandler.HttpApiResponse httpApiResponse = (HttpRequestHandler.HttpApiResponse)operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
        JsonAssert.assertJsonEquals((String)"{ headers : {}, status : 200, content : {key: 1}}}", (String)this.converter.convertToString((Object)httpApiResponse));
    }

    @Test
    public void testSignedGetRequest() throws Exception {
        JSONObject request = new JSONObject("{method:http.get, id:req1, params : {href:'http://www.example.org/somecontent',authz : 'signed' }}}");
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("GET");
        httpRequest.setAuthType(AuthType.SIGNED);
        httpRequest.setOAuthArguments(new OAuthArguments(AuthType.SIGNED, (Map)ImmutableMap.of()));
        EasyMock.expect((Object)this.pipeline.execute(HttpRequestHandlerTest.eqRequest(httpRequest))).andReturn((Object)this.builder.create()).anyTimes();
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        HttpRequestHandler.HttpApiResponse httpApiResponse = (HttpRequestHandler.HttpApiResponse)operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
        JsonAssert.assertJsonEquals((String)"{ headers : {}, status : 200, content : 'CONTENT' }}", (String)this.converter.convertToString((Object)httpApiResponse));
        HttpRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testSignedPostAndUpdateSecurityToken() throws Exception {
        this.token.setUpdatedToken("updated");
        JSONObject request = new JSONObject("{method:http.post, id:req1, params : {href:'http://www.example.org/somecontent',body:'POSTBODY',authz: 'signed' }}}");
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("POST");
        httpRequest.setAuthType(AuthType.SIGNED);
        httpRequest.setOAuthArguments(new OAuthArguments(AuthType.SIGNED, (Map)ImmutableMap.of()));
        httpRequest.setPostBody("POSTBODY".getBytes());
        EasyMock.expect((Object)this.pipeline.execute(HttpRequestHandlerTest.eqRequest(httpRequest))).andReturn((Object)this.builder.create()).anyTimes();
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        HttpRequestHandler.HttpApiResponse httpApiResponse = (HttpRequestHandler.HttpApiResponse)operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
        JsonAssert.assertJsonEquals((String)"{ headers : {}, status : 200, content : 'CONTENT', token : updated }}", (String)this.converter.convertToString((Object)httpApiResponse));
        HttpRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testOAuthRequest() throws Exception {
        JSONObject request = new JSONObject("{method:http.post, id:req1, params : {href:'http://www.example.org/somecontent',body:'POSTBODY',authz: 'oauth' }}}");
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("POST");
        httpRequest.setAuthType(AuthType.OAUTH);
        httpRequest.setOAuthArguments(new OAuthArguments(AuthType.OAUTH, (Map)ImmutableMap.of()));
        httpRequest.setPostBody("POSTBODY".getBytes());
        EasyMock.expect((Object)this.pipeline.execute(HttpRequestHandlerTest.eqRequest(httpRequest))).andReturn((Object)this.builder.create()).anyTimes();
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
    }

    @Test
    public void testOAuthRequestWithParameters() throws Exception {
        JSONObject request = new JSONObject("{method:http.post, id:req1, params : {href:'http://www.example.org/somecontent',body:'POSTBODY',sign_owner:'false',sign_viewer:'true',oauth_service_name:'oauthService',authz: 'oauth' }}}");
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("POST");
        httpRequest.setAuthType(AuthType.OAUTH);
        OAuthArguments oauthArgs = new OAuthArguments(AuthType.OAUTH, (Map)ImmutableMap.of());
        oauthArgs.setSignOwner(false);
        oauthArgs.setServiceName("oauthService");
        httpRequest.setOAuthArguments(oauthArgs);
        httpRequest.setPostBody("POSTBODY".getBytes());
        Capture requestCapture = new Capture();
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.capture((Capture)requestCapture))).andReturn((Object)this.builder.create());
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
        HttpRequestHandlerTest.assertEquals((Object)httpRequest.getOAuthArguments(), (Object)((HttpRequest)requestCapture.getValue()).getOAuthArguments());
    }

    @Test
    public void testInvalidSigningTypeTreatedAsNone() throws Exception {
        JSONObject request = new JSONObject("{method:http.post, id:req1, params : {href:'http://www.example.org/somecontent',body:'POSTBODY',authz : 'rubbish' }}}");
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("POST");
        httpRequest.setAuthType(AuthType.NONE);
        httpRequest.setPostBody("POSTBODY".getBytes());
        EasyMock.expect((Object)this.pipeline.execute(HttpRequestHandlerTest.eqRequest(httpRequest))).andReturn((Object)this.builder.create()).anyTimes();
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
    }

    @Test
    public void testSignedGetRequestNoSecurityToken() throws Exception {
        JSONObject request = new JSONObject("{method:http.get, id:req1, params : {href:'http://www.example.org/somecontent',authz : 'signed'}}}");
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("GET");
        httpRequest.setAuthType(AuthType.SIGNED);
        EasyMock.expect((Object)this.pipeline.execute(HttpRequestHandlerTest.eqRequest(httpRequest))).andReturn((Object)this.builder.create()).anyTimes();
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        try {
            operation.execute(this.emptyFormItems, null, (BeanConverter)this.converter).get();
            HttpRequestHandlerTest.fail((String)"Cannot execute a request without a security token");
        }
        catch (ExecutionException ee) {
            HttpRequestHandlerTest.assertTrue((boolean)(ee.getCause() instanceof ProtocolException));
        }
        this.verify();
    }

    @Test
    public void testBadHttpResponseIsPropagated() throws Exception {
        JSONObject request = new JSONObject("{method:http.get, id:req1, params : {href:'http://www.example.org/somecontent'}}");
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("GET");
        httpRequest.setAuthType(AuthType.NONE);
        this.builder.setHttpStatusCode(500);
        this.builder.setResponseString("I AM AN ERROR MESSAGE");
        EasyMock.expect((Object)this.pipeline.execute(HttpRequestHandlerTest.eqRequest(httpRequest))).andReturn((Object)this.builder.create()).anyTimes();
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        HttpRequestHandler.HttpApiResponse httpApiResponse = (HttpRequestHandler.HttpApiResponse)operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
        JsonAssert.assertJsonEquals((String)"{ headers : {}, status : 500, content : 'I AM AN ERROR MESSAGE' }}", (String)this.converter.convertToString((Object)httpApiResponse));
    }

    @Test
    public void testMetadataCopied() throws Exception {
        JSONObject request = new JSONObject("{method:http.get, id:req1, params : {href:'http://www.example.org/somecontent'}}");
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("GET");
        this.builder.setMetadata("foo", "CONTENT");
        EasyMock.expect((Object)this.pipeline.execute(HttpRequestHandlerTest.eqRequest(httpRequest))).andReturn((Object)this.builder.create()).anyTimes();
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        HttpRequestHandler.HttpApiResponse httpApiResponse = (HttpRequestHandler.HttpApiResponse)operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
        JsonAssert.assertJsonEquals((String)"{ headers : {}, status : 200, content : 'CONTENT', metadata : { foo : 'CONTENT' }}", (String)this.converter.convertToString((Object)httpApiResponse));
    }

    @Test
    public void testSetCookiesReturned() throws Exception {
        JSONObject request = new JSONObject("{method:http.get, id:req1, params : {href:'http://www.example.org/somecontent',}}");
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("GET");
        this.builder.addHeader("Set-Cookie", "foo=bar; Secure");
        this.builder.addHeader("Set-Cookie", "name=value");
        EasyMock.expect((Object)this.pipeline.execute(HttpRequestHandlerTest.eqRequest(httpRequest))).andReturn((Object)this.builder.create()).anyTimes();
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        HttpRequestHandler.HttpApiResponse httpApiResponse = (HttpRequestHandler.HttpApiResponse)operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
        JsonAssert.assertJsonEquals((String)"{ headers : { 'set-cookie' : ['foo=bar; Secure','name=value'] }, status : 200, content : 'CONTENT' }", (String)this.converter.convertToString((Object)httpApiResponse));
    }

    @Test
    public void testLocationReturned() throws Exception {
        JSONObject request = new JSONObject("{method:http.get, id:req1, params : {href:'http://www.example.org/somecontent',}}");
        HttpRequest httpRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/somecontent"));
        httpRequest.setMethod("GET");
        this.builder.addHeader("Location", "here");
        EasyMock.expect((Object)this.pipeline.execute(HttpRequestHandlerTest.eqRequest(httpRequest))).andReturn((Object)this.builder.create()).anyTimes();
        this.replay();
        RpcHandler operation = this.registry.getRpcHandler(request);
        HttpRequestHandler.HttpApiResponse httpApiResponse = (HttpRequestHandler.HttpApiResponse)operation.execute(this.emptyFormItems, (SecurityToken)this.token, (BeanConverter)this.converter).get();
        this.verify();
        JsonAssert.assertJsonEquals((String)"{ headers : { 'location' : ['here'] }, status : 200, content : 'CONTENT' }", (String)this.converter.convertToString((Object)httpApiResponse));
    }

    private static HttpRequest eqRequest(HttpRequest request) {
        EasyMock.reportMatcher((IArgumentMatcher)new RequestMatcher(request));
        return null;
    }

    private static class RequestMatcher
    implements IArgumentMatcher {
        private final HttpRequest req;

        public RequestMatcher(HttpRequest request) {
            this.req = request;
        }

        public void appendTo(StringBuffer buffer) {
            buffer.append("eqRequest[]");
        }

        public boolean matches(Object obj) {
            HttpRequest match = (HttpRequest)obj;
            return match.getMethod().equals(this.req.getMethod()) && match.getUri().equals((Object)this.req.getUri()) && match.getAuthType().equals((Object)this.req.getAuthType()) && match.getPostBodyAsString().equals(this.req.getPostBodyAsString()) && Objects.equal((Object)match.getOAuthArguments(), (Object)this.req.getOAuthArguments()) && ((Object)match.getHeaders()).equals(this.req.getHeaders());
        }
    }
}

