/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.shindig.common.servlet.HttpServletResponseRecorder;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.FakeTimeSource;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.servlet.ServletUtil;
import org.easymock.EasyMock;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletUtilTest {
    @Test
    public void testValidateUrlNoPath() throws Exception {
        Uri url = ServletUtil.validateUrl((Uri)Uri.parse((String)"http://www.example.com"));
        Assert.assertEquals((Object)"http", (Object)url.getScheme());
        Assert.assertEquals((Object)"www.example.com", (Object)url.getAuthority());
        Assert.assertEquals((Object)"/", (Object)url.getPath());
        Assert.assertNull((Object)url.getQuery());
        Assert.assertNull((Object)url.getFragment());
    }

    @Test
    public void testValidateUrlHttps() throws Exception {
        Uri url = ServletUtil.validateUrl((Uri)Uri.parse((String)"https://www.example.com"));
        Assert.assertEquals((Object)"https", (Object)url.getScheme());
        Assert.assertEquals((Object)"www.example.com", (Object)url.getAuthority());
        Assert.assertEquals((Object)"/", (Object)url.getPath());
        Assert.assertNull((Object)url.getQuery());
        Assert.assertNull((Object)url.getFragment());
    }

    @Test
    public void testValidateUrlWithPath() throws Exception {
        Uri url = ServletUtil.validateUrl((Uri)Uri.parse((String)"http://www.example.com/foo"));
        Assert.assertEquals((Object)"http", (Object)url.getScheme());
        Assert.assertEquals((Object)"www.example.com", (Object)url.getAuthority());
        Assert.assertEquals((Object)"/foo", (Object)url.getPath());
        Assert.assertNull((Object)url.getQuery());
        Assert.assertNull((Object)url.getFragment());
    }

    @Test
    public void testValidateUrlWithPort() throws Exception {
        Uri url = ServletUtil.validateUrl((Uri)Uri.parse((String)"http://www.example.com:8080/foo"));
        Assert.assertEquals((Object)"http", (Object)url.getScheme());
        Assert.assertEquals((Object)"www.example.com:8080", (Object)url.getAuthority());
        Assert.assertEquals((Object)"/foo", (Object)url.getPath());
        Assert.assertNull((Object)url.getQuery());
        Assert.assertNull((Object)url.getFragment());
    }

    @Test
    public void testValidateUrlWithEncodedPath() throws Exception {
        Uri url = ServletUtil.validateUrl((Uri)Uri.parse((String)"http://www.example.com/foo%20bar"));
        Assert.assertEquals((Object)"http", (Object)url.getScheme());
        Assert.assertEquals((Object)"www.example.com", (Object)url.getAuthority());
        Assert.assertEquals((Object)"/foo%20bar", (Object)url.getPath());
        Assert.assertNull((Object)url.getQuery());
        Assert.assertNull((Object)url.getFragment());
    }

    @Test
    public void testValidateUrlWithEncodedQuery() throws Exception {
        Uri url = ServletUtil.validateUrl((Uri)Uri.parse((String)"http://www.example.com/foo?q=with%20space"));
        Assert.assertEquals((Object)"http", (Object)url.getScheme());
        Assert.assertEquals((Object)"www.example.com", (Object)url.getAuthority());
        Assert.assertEquals((Object)"/foo", (Object)url.getPath());
        Assert.assertEquals((Object)"q=with%20space", (Object)url.getQuery());
        Assert.assertEquals((Object)"with space", (Object)url.getQueryParameter("q"));
        Assert.assertNull((Object)url.getFragment());
    }

    @Test
    public void testValidateUrlWithNoPathAndEncodedQuery() throws Exception {
        Uri url = ServletUtil.validateUrl((Uri)Uri.parse((String)"http://www.example.com?q=with%20space"));
        Assert.assertEquals((Object)"http", (Object)url.getScheme());
        Assert.assertEquals((Object)"www.example.com", (Object)url.getAuthority());
        Assert.assertEquals((Object)"/", (Object)url.getPath());
        Assert.assertEquals((Object)"q=with%20space", (Object)url.getQuery());
        Assert.assertNull((Object)url.getFragment());
    }

    @Test(expected=GadgetException.class)
    public void testValidateUrlNullInput() throws Exception {
        ServletUtil.validateUrl(null);
    }

    @Test
    public void testOutputDataUri() throws Exception {
        this.checkOutputDataUri("text/foo", "text/foo", "UTF-8");
    }

    @Test
    public void testOutputDataUriWithCharset() throws Exception {
        this.checkOutputDataUri("text/bar; charset=ISO-8859-1", "text/bar", "ISO-8859-1");
    }

    @Test
    public void testOutputDataUriWithEmptyCharset() throws Exception {
        this.checkOutputDataUri("text/bar; charset=", "text/bar", "UTF-8");
    }

    private void checkOutputDataUri(String contentType, String expectedType, String expectedEncoding) throws Exception {
        String theData = "this is the data";
        String mk1 = "meta1";
        String mv1 = "val1";
        String mk2 = "'\"}key";
        String mv2 = "val{\"'";
        HttpResponse response = new HttpResponseBuilder().setResponseString(theData).addHeader("Content-Type", contentType).setMetadata(mk1, mv1).setMetadata(mk2, mv2).setMetadata("dataUri", "foo").create();
        HttpResponse jsonified = ServletUtil.convertToJsonResponse((HttpResponse)response);
        Assert.assertEquals((Object)"application/json; charset=UTF-8", (Object)jsonified.getHeader("Content-Type"));
        String emitted = jsonified.getResponseAsString();
        JSONObject js = new JSONObject(emitted);
        Assert.assertEquals((Object)mv1, (Object)js.getString(mk1));
        Assert.assertEquals((Object)mv2, (Object)js.getString(mk2));
        String content64 = this.getBase64(theData);
        Assert.assertEquals((Object)("data:" + expectedType + ";base64;charset=" + expectedEncoding + "," + content64), (Object)js.getString("dataUri"));
    }

    private String getBase64(String input) throws Exception {
        return new String(Base64.encodeBase64((byte[])input.getBytes("UTF8")), "UTF8");
    }

    @Test
    public void testFromHttpServletRequest() throws Exception {
        HttpServletRequest original = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)original.getScheme()).andReturn((Object)"https");
        EasyMock.expect((Object)original.getServerName()).andReturn((Object)"www.example.org");
        EasyMock.expect((Object)original.getServerPort()).andReturn((Object)444);
        EasyMock.expect((Object)original.getRequestURI()).andReturn((Object)"/path/foo");
        EasyMock.expect((Object)original.getQueryString()).andReturn((Object)"one=two&three=four");
        Vector<String> headerNames = new Vector<String>();
        headerNames.add("Header1");
        headerNames.add("Header2");
        EasyMock.expect((Object)original.getHeaderNames()).andReturn(headerNames.elements());
        EasyMock.expect((Object)original.getHeaders("Header1")).andReturn(this.makeEnumeration("HVal1", "HVal3"));
        EasyMock.expect((Object)original.getHeaders("Header2")).andReturn(this.makeEnumeration("HVal2", "HVal4"));
        EasyMock.expect((Object)original.getMethod()).andReturn((Object)"post");
        final ByteArrayInputStream bais = new ByteArrayInputStream("post body".getBytes());
        ServletInputStream sis = new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }
        };
        EasyMock.expect((Object)original.getInputStream()).andReturn((Object)sis);
        EasyMock.expect((Object)original.getRemoteAddr()).andReturn((Object)"1.2.3.4");
        EasyMock.replay((Object[])new Object[]{original});
        HttpRequest request = ServletUtil.fromHttpServletRequest((HttpServletRequest)original);
        EasyMock.verify((Object[])new Object[]{original});
        Assert.assertEquals((Object)Uri.parse((String)"https://www.example.org:444/path/foo?one=two&three=four"), (Object)request.getUri());
        Assert.assertEquals((long)3L, (long)request.getHeaders().size());
        Assert.assertEquals((Object)"HVal1", request.getHeaders("Header1").get(0));
        Assert.assertEquals((Object)"HVal3", request.getHeaders("Header1").get(1));
        Assert.assertEquals((Object)"HVal2", request.getHeaders("Header2").get(0));
        Assert.assertEquals((Object)"HVal4", request.getHeaders("Header2").get(1));
        Assert.assertEquals((Object)"post", (Object)request.getMethod());
        Assert.assertEquals((Object)"post body", (Object)request.getPostBodyAsString());
        Assert.assertEquals((Object)"1.2.3.4", (Object)request.getParam("RemoteAddress"));
    }

    @Test
    public void testCopyResponseToServlet() throws Exception {
        HttpResponse response = new HttpResponseBuilder().setResponseString("response string").setHttpStatusCode(200).addHeader("h1", "v1").addHeader("h2", "v2").setCacheTtl(1000).create();
        HttpServletResponse servletResponse = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
        HttpServletResponseRecorder recorder = new HttpServletResponseRecorder(servletResponse);
        ServletUtil.copyResponseToServlet((HttpResponse)response, (HttpServletResponse)recorder);
        Assert.assertEquals((long)200L, (long)recorder.getHttpStatusCode());
        Assert.assertEquals((Object)"response string", (Object)recorder.getResponseAsString());
        Assert.assertEquals((Object)"v1", (Object)recorder.getHeader("h1"));
        Assert.assertEquals((Object)"v2", (Object)recorder.getHeader("h2"));
    }

    @Test
    public void testCopyResponseToServletNoCache() throws Exception {
        HttpResponse response = new HttpResponseBuilder().setResponseString("response string").setHttpStatusCode(200).addHeader("h1", "v1").addHeader("h2", "v2").setStrictNoCache().create();
        HttpServletResponse servletResponse = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
        HttpServletResponseRecorder recorder = new HttpServletResponseRecorder(servletResponse);
        FakeTimeSource fakeTime = new FakeTimeSource();
        HttpUtil.setTimeSource((TimeSource)fakeTime);
        ServletUtil.copyResponseToServlet((HttpResponse)response, (HttpServletResponse)recorder);
        Assert.assertEquals((long)200L, (long)recorder.getHttpStatusCode());
        Assert.assertEquals((Object)"response string", (Object)recorder.getResponseAsString());
        Assert.assertEquals((Object)"v1", (Object)recorder.getHeader("h1"));
        Assert.assertEquals((Object)"v2", (Object)recorder.getHeader("h2"));
        Assert.assertEquals((Object)"no-cache", (Object)recorder.getHeader("Pragma"));
        Assert.assertEquals((Object)"no-cache", (Object)recorder.getHeader("Cache-Control"));
    }

    Enumeration<String> makeEnumeration(String ... args) {
        Vector<String> vector = new Vector<String>();
        vector.addAll(Arrays.asList(args));
        return vector.elements();
    }
}

