/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.junit.Assert;
import org.junit.Test;

public class FeatureTest
extends Assert {
    @Test
    public void testRequire() throws Exception {
        String xml = "<Require feature=\"foo\"/>";
        Feature feature = new Feature(XmlUtil.parse((String)xml));
        FeatureTest.assertEquals((Object)"foo", (Object)feature.getName());
        FeatureTest.assertTrue((boolean)feature.getRequired());
    }

    @Test
    public void testOptional() throws Exception {
        String xml = "<Optional feature=\"foo\"/>";
        Feature feature = new Feature(XmlUtil.parse((String)xml));
        FeatureTest.assertEquals((Object)"foo", (Object)feature.getName());
        FeatureTest.assertFalse((boolean)feature.getRequired());
    }

    @Test
    public void testParams() throws Exception {
        String key = "bar";
        String value = "Hello, World!";
        String xml = "<Require feature=\"foo\">  <Param name=\"" + key + "\">" + value + "</Param>" + "</Require>";
        Feature feature = new Feature(XmlUtil.parse((String)xml));
        Multimap params = feature.getParams();
        FeatureTest.assertEquals((long)1L, (long)params.size());
        FeatureTest.assertEquals((Object)ImmutableList.of((Object)value), (Object)params.get((Object)key));
    }

    @Test
    public void testMultiParams() throws Exception {
        String key = "bar";
        String key2 = "bar2";
        String value = "Hello, World!";
        String value2 = "Goodbye, World!";
        String xml = "<Require feature=\"foo\">  <Param name=\"" + key + "\">" + value + "</Param>" + "  <Param name=\"" + key + "\">" + value2 + "</Param>" + "  <Param name=\"" + key2 + "\">" + value2 + "</Param>" + "  <Param name=\"" + key2 + "\">" + value + "</Param>" + "</Require>";
        Feature feature = new Feature(XmlUtil.parse((String)xml));
        Multimap params = feature.getParams();
        FeatureTest.assertEquals((long)2L, (long)params.keySet().size());
        FeatureTest.assertEquals((Object)ImmutableList.of((Object)value, (Object)value2), (Object)params.get((Object)key));
        FeatureTest.assertEquals((Object)value, (Object)feature.getParam(key));
        FeatureTest.assertEquals((Object)ImmutableList.of((Object)value2, (Object)value), (Object)params.get((Object)key2));
        FeatureTest.assertEquals((Object)value2, (Object)feature.getParam(key2));
        FeatureTest.assertTrue((boolean)params.get((Object)"foobar").isEmpty());
        FeatureTest.assertNull((Object)feature.getParam("foobar"));
    }

    @Test(expected=SpecParserException.class)
    public void testDoesNotLikeUnnamedFeatures() throws Exception {
        String xml = "<Require/>";
        new Feature(XmlUtil.parse((String)xml));
    }

    @Test(expected=SpecParserException.class)
    public void testEnforceParamNames() throws Exception {
        String xml = "<Require feature=\"foo\"><Param>Test</Param></Require>";
        new Feature(XmlUtil.parse((String)xml));
    }
}

