/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.junit.Assert;
import org.junit.Test;

public class GadgetSpecTest
extends Assert {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/g.xml");

    @Test
    public void testBasic() throws Exception {
        String xml = "<Module><ModulePrefs title=\"title\"/><UserPref name=\"foo\" datatype=\"string\"/><Content type=\"html\">Hello!</Content></Module>";
        GadgetSpec spec = new GadgetSpec(SPEC_URL, xml);
        GadgetSpecTest.assertEquals((Object)"title", (Object)spec.getModulePrefs().getTitle());
        GadgetSpecTest.assertEquals((Object)UserPref.DataType.STRING, (Object)((UserPref)spec.getUserPrefs().get("foo")).getDataType());
        GadgetSpecTest.assertEquals((Object)"Hello!", (Object)spec.getView("default").getContent());
    }

    @Test
    public void testAlternativeConstructor() throws Exception {
        String xml = "<Module><ModulePrefs title=\"title\"/><UserPref name=\"foo\" datatype=\"string\"/><Content type=\"html\">Hello!</Content></Module>";
        GadgetSpec spec = new GadgetSpec(SPEC_URL, XmlUtil.parse((String)xml), xml);
        GadgetSpecTest.assertEquals((Object)"title", (Object)spec.getModulePrefs().getTitle());
        GadgetSpecTest.assertEquals((Object)UserPref.DataType.STRING, (Object)((UserPref)spec.getUserPrefs().get("foo")).getDataType());
        GadgetSpecTest.assertEquals((Object)"Hello!", (Object)spec.getView("default").getContent());
        GadgetSpecTest.assertEquals((Object)HashUtil.checksum((byte[])xml.getBytes()), (Object)spec.getChecksum());
    }

    @Test
    public void testMultipleContentSections() throws Exception {
        String xml = "<Module><ModulePrefs title=\"title\"/><Content type=\"html\" view=\"hello\">hello </Content><Content type=\"html\" view=\"world\">world</Content><Content type=\"html\" view=\"hello, test\">test</Content></Module>";
        GadgetSpec spec = new GadgetSpec(SPEC_URL, xml);
        GadgetSpecTest.assertEquals((Object)"hello test", (Object)spec.getView("hello").getContent());
        GadgetSpecTest.assertEquals((Object)"world", (Object)spec.getView("world").getContent());
        GadgetSpecTest.assertEquals((Object)"test", (Object)spec.getView("test").getContent());
    }

    @Test(expected=SpecParserException.class)
    public void testMissingModulePrefs() throws Exception {
        String xml = "<Module><Content type=\"html\"/></Module>";
        new GadgetSpec(SPEC_URL, xml);
    }

    @Test(expected=SpecParserException.class)
    public void testEnforceOneModulePrefs() throws Exception {
        String xml = "<Module><ModulePrefs title=\"hello\"/><ModulePrefs title=\"world\"/><Content type=\"html\"/></Module>";
        new GadgetSpec(SPEC_URL, xml);
    }

    @Test
    public void testSubstitutions() throws Exception {
        Substitutions substituter = new Substitutions();
        String title = "Hello, World!";
        String content = "Goodbye, world :(";
        String xml = "<Module><ModulePrefs title=\"__UP_title__\"/><Content type=\"html\">__MSG_content__</Content></Module>";
        substituter.addSubstitution(Substitutions.Type.USER_PREF, "title", title);
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "content", content);
        GadgetSpec baseSpec = new GadgetSpec(SPEC_URL, xml);
        baseSpec.setAttribute("foo", (Object)100);
        baseSpec.setAttribute("bar", (Object)"baz");
        GadgetSpec spec = baseSpec.substitute(substituter);
        GadgetSpecTest.assertEquals((Object)title, (Object)spec.getModulePrefs().getTitle());
        GadgetSpecTest.assertEquals((Object)content, (Object)spec.getView("default").getContent());
        GadgetSpecTest.assertEquals((Object)100, (Object)spec.getAttribute("foo"));
        GadgetSpecTest.assertEquals((Object)"baz", (Object)spec.getAttribute("bar"));
    }
}

