/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.Icon;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.junit.Assert;
import org.junit.Test;

public class IconTest
extends Assert {
    @Test
    public void testBasicIcon() throws Exception {
        String xml = "<Icon type=\"foo\" mode=\"base64\">helloWorld</Icon>";
        Icon icon = new Icon(XmlUtil.parse((String)xml));
        IconTest.assertEquals((Object)"foo", (Object)icon.getType());
        IconTest.assertEquals((Object)"base64", (Object)icon.getMode());
        IconTest.assertEquals((Object)"helloWorld", (Object)icon.getContent());
    }

    @Test(expected=SpecParserException.class)
    public void testInvalidMode() throws Exception {
        String xml = "<Icon type=\"foo\" mode=\"broken\"/>";
        new Icon(XmlUtil.parse((String)xml));
    }

    @Test
    public void testSubstitutions() throws Exception {
        String xml = "<Icon>http://__MSG_domain__/icon.png</Icon>";
        Substitutions substituter = new Substitutions();
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "domain", "example.org");
        Icon icon = new Icon(XmlUtil.parse((String)xml)).substitute(substituter);
        IconTest.assertEquals((Object)"http://example.org/icon.png", (Object)icon.getContent());
    }
}

