/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.spec.Preload;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.junit.Assert;
import org.junit.Test;

public class PreloadTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/g.xml");
    private static final String HREF = "http://example.org/preload.xml";
    private static final Set<String> VIEWS = ImmutableSet.of((Object)"view0", (Object)"view1");

    @Test
    public void basicPreload() throws Exception {
        String xml = "<Preload href='http://example.org/preload.xml'/>";
        Preload preload = new Preload(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)HREF, (Object)preload.getHref().toString());
        Assert.assertEquals((Object)AuthType.NONE, (Object)preload.getAuthType());
        Assert.assertEquals((long)0L, (long)preload.getAttributes().size());
        Assert.assertTrue((String)"Default value for sign_owner should be true.", (boolean)preload.isSignOwner());
        Assert.assertTrue((String)"Default value for sign_viewer should be true.", (boolean)preload.isSignViewer());
    }

    @Test
    public void authzSigned() throws Exception {
        String xml = "<Preload href='http://example.org/preload.xml' authz='signed'/>";
        Preload preload = new Preload(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)AuthType.SIGNED, (Object)preload.getAuthType());
    }

    @Test
    public void authzOAuth() throws Exception {
        String xml = "<Preload href='http://example.org/preload.xml' authz='oauth'/>";
        Preload preload = new Preload(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)AuthType.OAUTH, (Object)preload.getAuthType());
    }

    @Test
    public void authzUnknownTreatedAsNone() throws Exception {
        String xml = "<Preload href='foo' authz='bad-bad-bad value!'/>";
        Preload preload = new Preload(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)AuthType.NONE, (Object)preload.getAuthType());
    }

    @Test
    public void multipleViews() throws Exception {
        String xml = "<Preload href='http://example.org/preload.xml' views='" + StringUtils.join(VIEWS, (char)',') + "'/>";
        Preload preload = new Preload(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals(VIEWS, (Object)preload.getViews());
    }

    @Test
    public void substitutionsOk() throws Exception {
        String xml = "<Preload href='__MSG_preload__'/>";
        Preload preload = new Preload(XmlUtil.parse((String)xml), SPEC_URL);
        Substitutions substituter = new Substitutions();
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "preload", HREF);
        Preload substituted = preload.substitute(substituter);
        Assert.assertEquals((Object)HREF, (Object)substituted.getHref().toString());
    }

    @Test
    public void relativeSubstitutionsOk() throws Exception {
        String xml = "<Preload href='__MSG_preload__'/>";
        Preload preload = new Preload(XmlUtil.parse((String)xml), SPEC_URL);
        Substitutions substituter = new Substitutions();
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "preload", "relative");
        Preload substituted = preload.substitute(substituter);
        Assert.assertEquals((Object)SPEC_URL.resolve(Uri.parse((String)"relative")), (Object)substituted.getHref());
    }

    @Test
    public void arbitraryAttributes() throws Exception {
        String xml = "<Preload href='http://example.org/preload.xml' foo='bar' yo='momma' sub='__MSG_preload__'/>";
        Preload preload = new Preload(XmlUtil.parse((String)xml), SPEC_URL);
        Substitutions substituter = new Substitutions();
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "preload", "stuff");
        Preload substituted = preload.substitute(substituter);
        Assert.assertEquals((Object)"bar", substituted.getAttributes().get("foo"));
        Assert.assertEquals((Object)"momma", substituted.getAttributes().get("yo"));
        Assert.assertEquals((Object)"stuff", substituted.getAttributes().get("sub"));
    }

    @Test
    public void toStringIsSane() throws Exception {
        String xml = "<Preload href='http://example.org/preload.xml' authz='signed' views='" + StringUtils.join(VIEWS, (char)',') + '\'' + " some_attribute='yes' />";
        Preload preload = new Preload(XmlUtil.parse((String)xml), SPEC_URL);
        Preload preload2 = new Preload(XmlUtil.parse((String)preload.toString()), SPEC_URL);
        Assert.assertEquals(VIEWS, (Object)preload2.getViews());
        Assert.assertEquals((Object)HREF, (Object)preload2.getHref().toString());
        Assert.assertEquals((Object)AuthType.SIGNED, (Object)preload2.getAuthType());
        Assert.assertEquals((Object)"yes", preload2.getAttributes().get("some_attribute"));
    }

    @Test(expected=SpecParserException.class)
    public void missingHrefThrows() throws Exception {
        String xml = "<Preload/>";
        new Preload(XmlUtil.parse((String)xml), SPEC_URL);
    }

    @Test(expected=SpecParserException.class)
    public void malformedHrefThrows() throws Exception {
        String xml = "<Preload href='@$%@$%$%'/>";
        new Preload(XmlUtil.parse((String)xml), SPEC_URL);
    }
}

