/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.junit.Assert;
import org.junit.Test;

public class UserPrefTest
extends Assert {
    @Test
    public void testBasic() throws Exception {
        String xml = "<UserPref name=\"name\" display_name=\"display_name\" default_value=\"default_value\" required=\"true\" datatype=\"hidden\"/>";
        UserPref userPref = new UserPref(XmlUtil.parse((String)xml));
        UserPrefTest.assertEquals((Object)"name", (Object)userPref.getName());
        UserPrefTest.assertEquals((Object)"display_name", (Object)userPref.getDisplayName());
        UserPrefTest.assertEquals((Object)"default_value", (Object)userPref.getDefaultValue());
        UserPrefTest.assertTrue((boolean)userPref.getRequired());
        UserPrefTest.assertEquals((Object)UserPref.DataType.HIDDEN, (Object)userPref.getDataType());
    }

    @Test
    public void testEnum() throws Exception {
        String xml = "<UserPref name=\"foo\" datatype=\"enum\"> <EnumValue value=\"0\" display_value=\"Zero\"/> <EnumValue value=\"1\"/></UserPref>";
        UserPref userPref = new UserPref(XmlUtil.parse((String)xml));
        UserPrefTest.assertEquals((long)2L, (long)userPref.getEnumValues().size());
        UserPrefTest.assertEquals((Object)"Zero", userPref.getEnumValues().get("0"));
        UserPrefTest.assertEquals((Object)"1", userPref.getEnumValues().get("1"));
    }

    @Test
    public void testSubstitutions() throws Exception {
        String xml = "<UserPref name=\"name\" datatype=\"enum\" display_name=\"__MSG_display_name__\" default_value=\"__MSG_default_value__\"> <EnumValue value=\"0\" display_value=\"__MSG_dv__\"/></UserPref>";
        String displayName = "This is the display name";
        String defaultValue = "This is the default value";
        String displayValue = "This is the display value";
        Substitutions substituter = new Substitutions();
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "display_name", displayName);
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "default_value", defaultValue);
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "dv", displayValue);
        UserPref userPref = new UserPref(XmlUtil.parse((String)xml)).substitute(substituter);
        UserPrefTest.assertEquals((Object)displayName, (Object)userPref.getDisplayName());
        UserPrefTest.assertEquals((Object)defaultValue, (Object)userPref.getDefaultValue());
        UserPrefTest.assertEquals((Object)displayValue, userPref.getEnumValues().get("0"));
    }

    @Test(expected=SpecParserException.class)
    public void testMissingName() throws Exception {
        String xml = "<UserPref datatype=\"string\"/>";
        new UserPref(XmlUtil.parse((String)xml));
    }

    @Test
    public void testMissingDataType() throws Exception {
        String xml = "<UserPref name=\"name\"/>";
        UserPref pref = new UserPref(XmlUtil.parse((String)xml));
        UserPrefTest.assertEquals((Object)UserPref.DataType.STRING, (Object)pref.getDataType());
    }

    @Test(expected=SpecParserException.class)
    public void testMissingEnumValue() throws Exception {
        String xml = "<UserPref name=\"foo\" datatype=\"enum\"> <EnumValue/></UserPref>";
        new UserPref(XmlUtil.parse((String)xml));
    }

    @Test
    public void testToString() throws Exception {
        String xml = "<UserPref name=\"name\" display_name=\"__MSG_display_name__\" default_value=\"__MSG_default_value__\" required=\"false\" datatype=\"enum\"><EnumValue value=\"0\" display_value=\"__MSG_dv__\"/></UserPref>";
        UserPref userPref = new UserPref(XmlUtil.parse((String)xml));
        UserPrefTest.assertEquals((Object)xml, (Object)userPref.toString().replace("\n", ""));
    }
}

